/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.kony.adapter.service.constants.CollectionType;
import com.kony.adapter.service.runtime.AbstractServiceList;
import com.kony.adapter.service.runtime.AbstractServiceObject;
import com.kony.adapter.service.runtime.AbstractServiceParam;
import com.kony.adapter.service.runtime.ServiceData;
import com.kony.mapper.model.AbstractNode;
import com.kony.mapper.model.NodeElement;
import com.kony.mapper.model.NodePrimitive;
import com.kony.mapper.model.impl.object.ObjectNodePrimitive;
import com.konylabs.middleware.mapper.ServiceDataList;
import com.konylabs.middleware.mapper.ServiceDataNodeCreatorFactory;
import java.util.HashSet;
import java.util.Set;

public class ServiceDataNode
extends AbstractNode {
    private final AbstractServiceObject serviceObject;

    public ServiceDataNode(AbstractServiceObject serviceObject) {
        this.serviceObject = serviceObject;
    }

    public AbstractServiceObject getServiceObject() {
        return this.serviceObject;
    }

    public NodeElement getValue(String key) {
        ServiceData serviceData = this.getValueFromServiceData((ServiceData)this.serviceObject, key);
        if (serviceData != null) {
            if (serviceData.getType() == CollectionType.PARAM) {
                return new ObjectNodePrimitive(((AbstractServiceParam)serviceData).getValue());
            }
            if (serviceData.getType() == CollectionType.RECORD) {
                return new ServiceDataNode((AbstractServiceObject)serviceData);
            }
            if (serviceData.getType() == CollectionType.DATASET) {
                return new ServiceDataList((AbstractServiceList)serviceData);
            }
        }
        return null;
    }

    public void setValue(String key, NodeElement nodeElement) {
        if (nodeElement instanceof NodePrimitive) {
            Object serviceDataPrimitive = ((NodePrimitive)nodeElement).getValue();
            AbstractServiceParam serviceParam = ServiceDataNodeCreatorFactory.getNodeCreator((ServiceData)this.serviceObject).createServiceParam(key, serviceDataPrimitive);
            this.serviceObject.addParamRecordDataset((ServiceData)serviceParam);
        } else if (nodeElement instanceof ServiceDataNode) {
            ServiceDataNode serviceDataNode = (ServiceDataNode)nodeElement;
            serviceDataNode.getServiceObject().setName(key);
            this.serviceObject.addParamRecordDataset((ServiceData)serviceDataNode.getServiceObject());
        } else if (nodeElement instanceof ServiceDataList) {
            ServiceDataList serviceDataList = (ServiceDataList)nodeElement;
            serviceDataList.getServiceList().setName(key);
            this.serviceObject.addParamRecordDataset((ServiceData)serviceDataList.getServiceList());
        }
    }

    public void remove(String key) {
    }

    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        this.getKeysFromServiceData(keys, (ServiceData)this.serviceObject);
        return keys;
    }

    private void getKeysFromServiceData(Set<String> keys, ServiceData serviceData) {
        for (ServiceData serviceDataValue : serviceData.getParamRecordDataset()) {
            keys.add(serviceDataValue.getName());
        }
    }

    private ServiceData getValueFromServiceData(ServiceData serviceData, String key) {
        for (ServiceData serviceDataValue : serviceData.getParamRecordDataset()) {
            if (!serviceDataValue.getName().equalsIgnoreCase(key)) continue;
            return serviceDataValue;
        }
        return null;
    }
}

