/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.kony.mapper.model.AbstractNodeCreator;
import com.kony.mapper.model.Node;
import com.kony.mapper.model.NodeElement;
import com.kony.mapper.model.NodeList;
import com.kony.mapper.model.NodePrimitive;
import com.konylabs.middleware.mapper.EntityNodeCreator;
import com.konylabs.middleware.mapper.MapNode;
import com.konylabs.middleware.mapper.ServiceDataInputNodeCreator;
import com.konylabs.middleware.mapper.ServiceDataOutputNodeCreator;
import com.konylabs.middleware.mapper.ServiceInputNode;
import java.util.Map;

public class ServiceInputNodeCreator
extends AbstractNodeCreator {
    private final AbstractNodeCreator nodeCreator;
    private final Map<String, NodeElement> map;

    public ServiceInputNodeCreator(Map<String, NodeElement> map, AbstractNodeCreator nodeCreator) {
        this.map = map;
        this.nodeCreator = nodeCreator;
    }

    public Node createNode(String nodeName) {
        if (nodeName.equals("")) {
            return new ServiceInputNode();
        }
        if (nodeName.equals("request_headers") || nodeName.equals("session") || "criteria".equals(nodeName)) {
            return (Node)this.map.get(nodeName);
        }
        if (nodeName.equals("request_out")) {
            if (this.nodeCreator instanceof EntityNodeCreator) {
                EntityNodeCreator entityNodecreator = (EntityNodeCreator)this.nodeCreator;
                return entityNodecreator.createRootEntity();
            }
            if (this.nodeCreator instanceof ServiceDataInputNodeCreator) {
                ServiceDataInputNodeCreator serviceDataInputNodeCreator = (ServiceDataInputNodeCreator)this.nodeCreator;
                return serviceDataInputNodeCreator.createNode(nodeName);
            }
            if (this.nodeCreator instanceof ServiceDataOutputNodeCreator) {
                ServiceDataOutputNodeCreator serviceDataOutputNodeCreator = (ServiceDataOutputNodeCreator)this.nodeCreator;
                return serviceDataOutputNodeCreator.createNode(nodeName);
            }
            return new MapNode();
        }
        return this.nodeCreator.createNode(nodeName);
    }

    public NodeList createNodeList(String nodeName) {
        return this.nodeCreator.createNodeList(nodeName);
    }

    public NodePrimitive createNodePrimitive(Object value) {
        return this.nodeCreator.createNodePrimitive(value);
    }
}

