/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mbaas;

import com.kony.api.gateway.Gateway;
import com.kony.api.gateway.GatewayConfig;
import com.kony.api.gateway.GatewayException;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.exceptions.MBaaSException;
import com.konylabs.middleware.identityproviders.MBaaSIdentityProvider;
import com.konylabs.middleware.identityproviders.impl.AbstractMBaaSIdentityProvider;
import com.konylabs.middleware.identityproviders.impl.OAuth2IdentityProvider;
import com.konylabs.middleware.identityproviders.impl.SKYRestMBaaSIdentityProvider;
import com.konylabs.middleware.identityproviders.impl.SalesForceMBaaSIdentityProvider;
import com.konylabs.middleware.mbaas.MBAASGateWayWrapper;
import com.konylabs.middleware.registry.vo.Service;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class MiddlewareMBaasUtils {
    private static final Logger LOGGER = Logger.getLogger(MiddlewareMBaasUtils.class);

    public static MBaaSIdentityProvider getIdentityProviderInstance(Service service, Map<String, Object> requestHeaderMap, DataControllerRequest dataControllerRequest) throws MBaaSException {
        AbstractMBaaSIdentityProvider mbaasProviderType = null;
        String providerType = service.getServiceConfig().getConfigParamValue("identityProviderType");
        if (StringUtils.isNotBlank((String)providerType)) {
            LOGGER.debug((Object)("Identity Provider Type is :" + providerType));
            if (MBaaSIdentityProvider.IDENTITY_PROVIDER_TYPE_ENUM.Salesforce.toString().equalsIgnoreCase(providerType)) {
                mbaasProviderType = new SalesForceMBaaSIdentityProvider(service, requestHeaderMap, dataControllerRequest);
            } else if (MBaaSIdentityProvider.IDENTITY_PROVIDER_TYPE_ENUM.sky.toString().equalsIgnoreCase(providerType)) {
                mbaasProviderType = new SKYRestMBaaSIdentityProvider(service, requestHeaderMap, dataControllerRequest);
            } else if (MBaaSIdentityProvider.IDENTITY_PROVIDER_TYPE_ENUM.oauth2.toString().equalsIgnoreCase(providerType)) {
                mbaasProviderType = new OAuth2IdentityProvider(service, requestHeaderMap, dataControllerRequest);
            } else if (MBaaSIdentityProvider.IDENTITY_PROVIDER_TYPE_ENUM.facebook.toString().equalsIgnoreCase(providerType)) {
                mbaasProviderType = new OAuth2IdentityProvider(service, requestHeaderMap, dataControllerRequest);
            }
        }
        return mbaasProviderType;
    }

    public static Service validateIdentityProviderChanges(Gateway gateway, Service service) throws MBaaSException {
        return MiddlewareMBaasUtils.validateIdentityProviderChanges(gateway, service, null, null);
    }

    public static Service validateIdentityProviderChanges(Gateway gateway, Service service, Map<String, Object> requestHeaderMap, DataControllerRequest dataControllerRequest) throws MBaaSException {
        LOGGER.debug((Object)"Validating the Identity Provider type in service def.");
        MBaaSIdentityProvider identityProvider = MiddlewareMBaasUtils.getIdentityProviderInstance(service, requestHeaderMap, dataControllerRequest);
        if (identityProvider != null) {
            service = identityProvider.popoulateIdentityProviderChanges(gateway);
        }
        return service;
    }

    public static Service validateIdentityProviderChanges(Service service, Map<String, Object> requestHeaderMap, DataControllerRequest dataControllerRequest) throws MBaaSException {
        if (EnvironmentFactory.getEnvironment() != null && EnvironmentFactory.getEnvironment().isGatewayEnabled() && MiddlewareMBaasUtils.hasIdentityProviderType(service)) {
            LOGGER.debug((Object)"Service has Identity Provider settings");
            service = MiddlewareMBaasUtils.validateIdentityProviderChanges(MiddlewareMBaasUtils.getGatewayFromDCR(dataControllerRequest), service, requestHeaderMap, dataControllerRequest);
        } else {
            LOGGER.debug((Object)"Gateway is not enabled or Service does not have Identity Provider settings");
        }
        return service;
    }

    public static MBAASGateWayWrapper getGatewayWrapper(String xKonyAuthHeader, String requestId, GatewayConfig gatewayConfig) throws GatewayException {
        return new MBAASGateWayWrapper(xKonyAuthHeader, requestId, gatewayConfig);
    }

    @Deprecated
    public static String getAccountsLoginURL() {
        return EnvironmentFactory.getEnvironment().getAccountsLoginURL(null);
    }

    public static boolean hasIdentityProviderType(Service service) {
        boolean hasIdentityProvider = false;
        String providerType = service.getServiceConfig().getConfigParamValue("identityProviderType");
        if (StringUtils.isNotBlank((String)providerType)) {
            hasIdentityProvider = true;
        }
        return hasIdentityProvider;
    }

    public static String getGatewayVersion() {
        return "8.3.0.4";
    }

    public static MBAASGateWayWrapper getGatewayWrapperFromDCR(DataControllerRequest dcRequest) {
        MBAASGateWayWrapper gatewayWrapper = null;
        if (dcRequest != null) {
            gatewayWrapper = (MBAASGateWayWrapper)dcRequest.getAttribute("gatewaywrapperobject");
        }
        return gatewayWrapper;
    }

    public static Gateway getGatewayFromDCR(DataControllerRequest dcRequest) {
        MBAASGateWayWrapper gateWayWrapper = MiddlewareMBaasUtils.getGatewayWrapperFromDCR(dcRequest);
        return gateWayWrapper == null ? null : gateWayWrapper.getGateway();
    }

    public static void populateIdentityHeaders(DataControllerRequest request, Map<String, String> headerMap) {
        String instanceURL;
        Object identityHeaders = request.getAttribute("IDENTITY_HEADERS");
        if (identityHeaders != null) {
            headerMap.putAll((Map)identityHeaders);
        }
        if (StringUtils.isNotBlank((String)(instanceURL = (String)request.getAttribute("instance_url")))) {
            headerMap.put("instance_url", instanceURL);
        }
    }

    private MiddlewareMBaasUtils() {
    }
}

