/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.metrics;

import com.kony.mobilefabric.logger.DiagnosticContext;
import com.kony.mobilefabric.timer.FabricTimer;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.monitoring.MonitoringUtils;
import org.apache.log4j.Logger;

public class MWMetricsTimer
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(MWMetricsTimer.class);
    private final DataControllerRequest request;
    private final FabricTimer fabricTimer;
    private final String metricsName;

    public MWMetricsTimer(DataControllerRequest request, FabricTimerCategory fabricTimerCategory, String metricsName) {
        DiagnosticContext.setStageName((String)fabricTimerCategory.name());
        this.request = request;
        this.metricsName = metricsName;
        String parentTimerName = MonitoringUtils.getParentTimerName(request);
        String timerName = MWMetricsTimer.getTimerName(fabricTimerCategory, parentTimerName);
        this.fabricTimer = FabricTimer.startNew((FabricTimerCategory)fabricTimerCategory, (String)timerName, (String)parentTimerName);
        LOGGER.debug((Object)("Created Fabric Timer name with timer name " + timerName + " and parent " + parentTimerName));
    }

    @Override
    public void close() {
        this.fabricTimer.close();
        long elapsedTimeInMilliseconds = this.fabricTimer.getElapsedTimeInMilliseconds();
        MWMetricsTimer.updateServiceTimeToMetricsBean(this.request, elapsedTimeInMilliseconds, this.metricsName);
        DiagnosticContext.removeStageName();
        LOGGER.debug((Object)("Updated metrics bean and stopped the Fabric Timer " + this.fabricTimer.getTimerName()));
    }

    public static void manualUpdate(DataControllerRequest request, FabricTimerCategory fabricTimerCategory, String metricsName, long elapsedTimeInMilliseconds) {
        String parentTimerName = MonitoringUtils.getParentTimerName(request);
        String timerName = MWMetricsTimer.getTimerName(fabricTimerCategory, parentTimerName);
        FabricTimer.manualUpdate((FabricTimerCategory)fabricTimerCategory, (String)timerName, (String)parentTimerName, (long)elapsedTimeInMilliseconds);
        MWMetricsTimer.updateServiceTimeToMetricsBean(request, elapsedTimeInMilliseconds, metricsName);
        LOGGER.debug((Object)("Updated metrics bean and manually updated the Fabric Timer " + timerName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateServiceTimeToMetricsBean(DataControllerRequest request, long serviceTime, String durationType) {
        MetricsBean metricsBean = null;
        DataControllerRequest dataControllerRequest = request;
        synchronized (dataControllerRequest) {
            metricsBean = MonitoringUtils.getMetricsBeanFromRequest(request);
        }
        if (metricsBean != null) {
            metricsBean.incrementParamValue(durationType, serviceTime);
        }
    }

    public static String getTimerName(FabricTimerCategory fabricTimerCategory, String parentTimerName) {
        return parentTimerName + "-" + fabricTimerCategory.name().toLowerCase();
    }
}

