/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.monitoring;

import com.kony.mobilefabric.memory.FabricMemoryConfig;
import com.kony.mobilefabric.memory.FabricMemoryReporterController;
import com.kony.mobilefabric.timer.FabricTimerConfig;
import com.kony.mobilefabric.timer.FabricTimerReporterController;
import com.konylabs.middleware.environment.MiddlewareDbManager;
import com.konylabs.middleware.monitoring.MonitoringProperties;
import com.konylabs.middleware.utilities.TenantUtilities;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public final class MonitoringInitializer {
    private static final Logger LOGGER = Logger.getLogger(MonitoringInitializer.class);

    public static void initialize(String instanceId) {
        boolean isMultiTenant = TenantUtilities.isMultiTenant();
        LOGGER.debug((Object)("Initializing monitoring properties - isMultiTenant = " + isMultiTenant));
        if (!isMultiTenant) {
            MonitoringInitializer.initializeFabricTimerConfigAndStartReporter(instanceId);
            MonitoringInitializer.initializeFabricMemoryConfigAndStartReporter(instanceId);
        }
    }

    public static void destroy() {
        FabricTimerReporterController.stopFabricTimerReporter();
        FabricMemoryReporterController.stopFabricMemoryReporter();
    }

    private static void initializeFabricTimerConfigAndStartReporter(String instanceIdentifier) {
        LOGGER.debug((Object)("Initializing timer config for instance  " + instanceIdentifier));
        boolean enablePerfMeasure = (Boolean)MonitoringProperties.KONY_SERVER_PERF_MEASUREMENT.getFromConfig();
        int perfThreshold = (Integer)MonitoringProperties.THRESHOLD_FOR_PERF_MEASUREMENT.getFromConfig();
        int reportingInterval = (Integer)MonitoringProperties.REPORTING_INTERVAL_FOR_PERF_MEASUREMENT.getFromConfig();
        FabricTimerConfig.setEnabled((boolean)enablePerfMeasure);
        FabricTimerConfig.setThresholdInMilliSeconds((int)perfThreshold);
        FabricTimerConfig.setReporterPollingPeriodInMinutes((int)reportingInterval);
        FabricTimerReporterController.startFabricTimerReporter((String)instanceIdentifier, (DataSource)MiddlewareDbManager.getAdminDataSource(), (String)MonitoringProperties.SERVER_TIMER_METRICS_TABLE_NAME_PREFIX.getName(), (boolean)true);
        LOGGER.debug((Object)("Initialized timer config - enabled = " + enablePerfMeasure + " for instance " + instanceIdentifier));
    }

    private static void initializeFabricMemoryConfigAndStartReporter(String instanceIdentifier) {
        LOGGER.debug((Object)("Initializing memory config for instance  " + instanceIdentifier));
        boolean enableEnvMonitoring = (Boolean)MonitoringProperties.KONY_SERVER_ENVIRONMENT_MONITORING.getFromConfig();
        int envMonitoringReportingInterval = (Integer)MonitoringProperties.KONY_SERVER_ENVIRONMENT_MONITORING_REPORTING_INTERVAL.getFromConfig();
        FabricMemoryConfig.setEnabled((boolean)enableEnvMonitoring);
        FabricMemoryConfig.setReporterPollingPeriodInMinutes((int)envMonitoringReportingInterval);
        FabricMemoryReporterController.startFabricMemoryReporter((String)instanceIdentifier, (DataSource)MiddlewareDbManager.getAdminDataSource(), (String)MonitoringProperties.SERVER_ENVIRONMENT_METRICS_TABLE_NAME_PREFIX.getName());
        LOGGER.debug((Object)("Initialized memory config - enabled = " + enableEnvMonitoring + " for instance " + instanceIdentifier));
    }

    private MonitoringInitializer() {
    }
}

