/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.monitoring;

import com.kony.mobilefabric.amazonaws.AWSUtils;
import com.kony.mobilefabric.timer.FabricTimer;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.kony.mobilefabric.timer.FabricTimerConfig;
import com.kony.mobilefabric.util.NetworkUtils;
import com.konylabs.middleware.common.MiddlewareValidationListener;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.datasourcelogs.DeviceResponseData;
import com.konylabs.middleware.datasourcelogs.LogDeviceResponseData;
import com.konylabs.middleware.identityproviders.MBaaSIdentityProvider;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.monitoring.MonitoringProperties;
import com.konylabs.middleware.request.builder.RequestContext;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public final class MonitoringUtils {
    private static final String SEPARATOR = "-";
    private static final int WEEK_IN_MILLS = 604800000;
    private static final int INSTANCE_ID_MAX_SIZE = 24;

    public static String buildTimerName(RequestContext requestContext) {
        StringBuilder timerNameBuilder = new StringBuilder(requestContext.getAppId());
        if (StringUtils.isNotBlank((String)requestContext.getServiceId())) {
            timerNameBuilder.append(SEPARATOR).append(requestContext.getServiceId());
        }
        if (StringUtils.isNotBlank((String)requestContext.getObjectId())) {
            timerNameBuilder.append(SEPARATOR).append(requestContext.getObjectId());
        }
        if (requestContext.getDefaultOperation() != null) {
            timerNameBuilder.append(SEPARATOR).append(requestContext.getDefaultOperation());
        }
        if (StringUtils.isNotBlank((String)requestContext.getApiVersion())) {
            timerNameBuilder.append(SEPARATOR).append(requestContext.getApiVersion());
        }
        return timerNameBuilder.toString();
    }

    public static String getParentTimerName(DataControllerRequest request) {
        MetricsBean metricsBean = MonitoringUtils.getMetricsBeanFromRequest(request);
        if (metricsBean != null) {
            return metricsBean.getParentTimerName();
        }
        if (request.getAttribute(MonitoringProperties.PARENT_TIMER_NAME.getName()) != null) {
            return (String)request.getAttribute(MonitoringProperties.PARENT_TIMER_NAME.getName());
        }
        return "child";
    }

    public static MetricsBean getMetricsBeanFromRequest(DataControllerRequest request) {
        return (MetricsBean)request.getAttribute("metricsBean");
    }

    public static MetricsBean getMetricsBeanFromRequestIfNotNullElseDefault(DataControllerRequest request) {
        return MonitoringUtils.getMetricsBeanFromRequest(request) != null ? MonitoringUtils.getMetricsBeanFromRequest(request) : new MetricsBean();
    }

    public static boolean isOrchestrationService(String serviceType) {
        return MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.LoopingConnector.name().equalsIgnoreCase(serviceType) || MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.CompositeConnector.name().equalsIgnoreCase(serviceType);
    }

    public static void prepareClonedMetricsBeanAndSetInRequest(DataControllerRequest request, String serviceId, String timerName, MetricsBean originalMetricsBean) {
        MetricsBean clonedMetricsBean = originalMetricsBean.clone();
        clonedMetricsBean.setServiceName(serviceId);
        clonedMetricsBean.setParentServiceName(originalMetricsBean.getServiceName());
        clonedMetricsBean.setParentTimerName(timerName);
        request.setAttribute("metricsBean", (Object)clonedMetricsBean);
    }

    public static boolean checkForError(HttpServletRequest httpServletRequest) {
        Result result = (Result)httpServletRequest.getAttribute("results");
        if (result != null && result.getParamByName("opstatus") != null && !"0".equals(result.getParamByName("opstatus").getValue())) {
            return true;
        }
        DeviceResponseData deviceResponseData = (DeviceResponseData)httpServletRequest.getAttribute("DeviceResLogBean");
        try {
            if (deviceResponseData != null) {
                return !"0".equals(LogDeviceResponseData.getOpstatusFromDeviceResponseData(deviceResponseData));
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static void closeTimerAndUpdateInternalDurationManually(FabricTimer fabricTimer, MetricsBean metricsBean, String timerName) {
        fabricTimer.close();
        if (FabricTimerConfig.isEnabled()) {
            long totalServiceTime = fabricTimer.getElapsedTimeInMilliseconds();
            long internalDuration = MetricsUtils.getInternalDurationAndAddDurationDataToJsonIfNotNull(totalServiceTime, metricsBean, null);
            FabricTimer.manualUpdate((FabricTimerCategory)FabricTimerCategory.INTERNAL_DURATION, (String)MWMetricsTimer.getTimerName(FabricTimerCategory.INTERNAL_DURATION, timerName), (String)timerName, (long)internalDuration);
        }
    }

    public static int getFactorToCalculateDayKey() {
        return FabricTimerConfig.getNumberOfDaysToPersistData() + 2;
    }

    public static long getCurrentDay(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().toEpochDay();
    }

    public static int getDayKeyToSelect(Date date) {
        return (int)(MonitoringUtils.getCurrentDay(date) % (long)MonitoringUtils.getFactorToCalculateDayKey());
    }

    public static String getUnionQuery(String baseQuery, Date from, Date to) {
        int fromTable = MonitoringUtils.getDayKeyToSelect(from);
        int toTable = MonitoringUtils.getDayKeyToSelect(to);
        if (toTable < fromTable) {
            toTable += MonitoringUtils.getFactorToCalculateDayKey();
        }
        StringBuilder unionSelect = new StringBuilder();
        for (int i = fromTable; i <= toTable; ++i) {
            if (i != fromTable) {
                unionSelect.append(" UNION ");
            }
            unionSelect.append(String.format(baseQuery, i % MonitoringUtils.getFactorToCalculateDayKey() + 1));
        }
        return unionSelect.toString();
    }

    public static Date getFromDate(Long fromDate) {
        fromDate = fromDate != null ? fromDate : Instant.now().toEpochMilli() - 604800000L;
        return new Date(fromDate);
    }

    public static Date getToDate(Long toDate) {
        toDate = toDate != null ? toDate.longValue() : Instant.now().toEpochMilli();
        return new Date(toDate);
    }

    public static String getInstanceId(String warFileLocation) {
        String instanceId = (String)MonitoringProperties.KONY_SERVER_NODE_NAME.getFromConfig();
        if (StringUtils.isBlank((String)instanceId) && MiddlewareValidationListener.isCloudSupport()) {
            instanceId = AWSUtils.getInstanceId();
        }
        if (StringUtils.isBlank((String)instanceId)) {
            String string = instanceId = StringUtils.isNotBlank((String)warFileLocation) ? NetworkUtils.getHostName() + SEPARATOR + warFileLocation.hashCode() : NetworkUtils.getHostName();
        }
        if (StringUtils.isBlank((String)instanceId)) {
            String string = instanceId = StringUtils.isNotBlank((String)warFileLocation) ? NetworkUtils.getMacAddress() + SEPARATOR + warFileLocation.hashCode() : NetworkUtils.getMacAddress();
        }
        if (StringUtils.isBlank((String)instanceId)) {
            instanceId = UUID.randomUUID().toString();
        }
        if (instanceId.length() > 24) {
            instanceId = instanceId.substring(0, 24);
        }
        return instanceId;
    }

    private MonitoringUtils() {
    }
}

