/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.objservices.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.konylabs.middleware.appservices.common.constants.FieldparamEnum;
import com.konylabs.middleware.appservices.common.constants.ObjectParamEnum;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.dataaccess.dto.ResponseDto;
import com.konylabs.middleware.appservices.common.dataaccess.dto.UniqueKeys;
import com.konylabs.middleware.appservices.common.helper.IncrementalMetadataHelper;
import com.konylabs.middleware.objservices.metadata.ActionsDto;
import com.konylabs.middleware.objservices.metadata.CustomSerializerForFieldDto;
import com.konylabs.middleware.objservices.metadata.FieldDto;
import com.konylabs.middleware.objservices.metadata.NamespaceDto;
import com.konylabs.middleware.objservices.metadata.ObjectDto;
import com.konylabs.middleware.objservices.metadata.RelationshipDto;
import com.konylabs.middleware.objservices.metadata.SupportedObjectDto;
import com.konylabs.middleware.objservices.runtime.metadata.FieldMetadata;
import com.konylabs.middleware.registry.impl.ActionBean;
import com.konylabs.middleware.registry.impl.ApplicationDiffBean;
import com.konylabs.middleware.registry.impl.MetadataKey;
import com.konylabs.middleware.registry.impl.ObjectBean;
import com.konylabs.middleware.registry.impl.ObjectMetadataBean;
import com.konylabs.middleware.registry.vo.Actions;
import com.konylabs.middleware.registry.vo.Field;
import com.konylabs.middleware.registry.vo.Fieldparam;
import com.konylabs.middleware.registry.vo.Index;
import com.konylabs.middleware.registry.vo.Indexfield;
import com.konylabs.middleware.registry.vo.Keyfield;
import com.konylabs.middleware.registry.vo.Objectparam;
import com.konylabs.middleware.registry.vo.Objectparams;
import com.konylabs.middleware.registry.vo.Operationmapping;
import com.konylabs.middleware.registry.vo.Relation;
import com.konylabs.middleware.registry.vo.Relationfield;
import com.konylabs.middleware.registry.vo.SupportedObject;
import com.konylabs.middleware.registry.vo.SupportedObjects;
import com.konylabs.middleware.registry.vo.Uniquekey;
import com.konylabs.middleware.utilities.DBUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MetadataUtils {
    private static final Logger LOGGER = Logger.getLogger(MetadataUtils.class);
    public static final String dateFormat = "YYYY-MM-DDTHH:mm:ss.sssZ";

    public static ObjectDto getObjectDtoFromObject(com.konylabs.middleware.registry.vo.Object object, String objectGroupName) {
        ObjectDto objectDto = new ObjectDto("");
        objectDto.setName(object.getName());
        objectDto.setObject_group(objectGroupName);
        List<String> primaryKeyNames = MetadataUtils.getPrimaryKeys(object);
        objectDto.setKey(primaryKeyNames);
        MetadataUtils.setFieldsToObjectDto(object, objectDto, primaryKeyNames);
        Objectparams objectparams = object.getObjectParams();
        if (objectparams != null) {
            HashMap<String, String> objectParamMap = new HashMap<String, String>();
            List objectparamList = objectparams.getObjectParam();
            if (objectparamList != null && objectparamList.size() > 0) {
                for (Objectparam objectparam : objectparamList) {
                    objectParamMap.put(objectparam.getName(), objectparam.getValue());
                }
            }
            MetadataUtils.setObjectParamsToObjectDto(objectParamMap, objectDto);
        }
        MetadataUtils.setRelationshipsToObjectDto(object, objectDto);
        objectDto.setUnique_keys(MetadataUtils.getUniqueKeys(object));
        objectDto.setIndexes(MetadataUtils.getIndexes(object));
        return objectDto;
    }

    public static void setFieldsToObjectDto(com.konylabs.middleware.registry.vo.Object object, ObjectDto objectDto, List<String> primaryKeyNames) {
        if (object != null && object.getFields() != null) {
            List fields = object.getFields().getField();
            ArrayList<FieldDto> fieldDtosList = new ArrayList<FieldDto>();
            for (Field field : fields) {
                FieldDto fieldDto = MetadataUtils.getFieldDtoFromField(field, primaryKeyNames);
                fieldDtosList.add(fieldDto);
            }
            objectDto.setFields(fieldDtosList);
        }
    }

    public static void setFieldMetadataToObjectDto(Map<String, FieldMetadata> fieldMetadataMap, ObjectDto objectDto) {
        if (fieldMetadataMap != null && !fieldMetadataMap.isEmpty()) {
            ArrayList<FieldDto> fieldDtosList = new ArrayList<FieldDto>();
            for (String fieldName : fieldMetadataMap.keySet()) {
                FieldMetadata fieldMetadata = fieldMetadataMap.get(fieldName);
                FieldDto fieldDto = new FieldDto("");
                fieldDto.setName(fieldMetadata.getName());
                fieldDto.setDatatype(fieldMetadata.getDatatype());
                if ("date".equalsIgnoreCase(fieldDto.getDatatype())) {
                    fieldDto.setDate_format(dateFormat);
                }
                fieldDto.setAuto_generated(fieldMetadata.isAutoGenerated());
                fieldDto.setUpdatable(fieldMetadata.isUpdateable());
                fieldDto.setSource_datatype(fieldMetadata.getSourceDatatype());
                fieldDto.setNullable(fieldMetadata.isNullable());
                fieldDto.setCreatable(fieldMetadata.isCreatable());
                fieldDto.setLength(fieldMetadata.getLength());
                if (fieldMetadata.getTimeStampFieldFormat() != null) {
                    fieldDto.setDate_format(dateFormat);
                }
                fieldDtosList.add(fieldDto);
            }
            objectDto.setFields(fieldDtosList);
        }
    }

    public static void setRelationshipsToObjectDto(com.konylabs.middleware.registry.vo.Object object, ObjectDto objectDto) {
        if (object.getRelations() != null && object.getRelations().getRelation() != null) {
            ArrayList<RelationshipDto> relationshipDtos = new ArrayList<RelationshipDto>();
            for (Relation relation : object.getRelations().getRelation()) {
                relationshipDtos.add(MetadataUtils.getChildRelationshipDtoFromRelation(relation));
            }
            objectDto.setRelationships(relationshipDtos);
        }
    }

    public static Map<String, List<String>> getUniqueKeys(com.konylabs.middleware.registry.vo.Object object) {
        if (object.getUniqueKeys() != null && object.getUniqueKeys().getUniqueKey() != null && object.getUniqueKeys().getUniqueKey().size() > 0) {
            List uniqueKeys = object.getUniqueKeys().getUniqueKey();
            HashMap<String, List<String>> uniqueKeysDto = new HashMap<String, List<String>>();
            int noNameUniqueKeyCount = 1;
            for (Uniquekey uniqueKey : uniqueKeys) {
                String uniqueKeyName;
                if (uniqueKey.getKeyField() == null || uniqueKey.getKeyField().size() <= 0) continue;
                List keyFields = uniqueKey.getKeyField();
                ArrayList<String> keyFieldsDto = new ArrayList<String>();
                if (StringUtils.isEmpty((String)uniqueKey.getName()) && keyFields.size() == 1) {
                    uniqueKeyName = "uk_" + ((Keyfield)keyFields.get(0)).getName();
                } else if (StringUtils.isEmpty((String)uniqueKey.getName())) {
                    uniqueKeyName = object.getName() + "_" + Integer.toString(noNameUniqueKeyCount);
                    ++noNameUniqueKeyCount;
                } else {
                    uniqueKeyName = uniqueKey.getName();
                }
                for (Keyfield keyField : keyFields) {
                    keyFieldsDto.add(keyField.getName());
                }
                uniqueKeysDto.put(uniqueKeyName, keyFieldsDto);
            }
            return uniqueKeysDto;
        }
        return null;
    }

    public static Map<String, List<String>> getIndexes(com.konylabs.middleware.registry.vo.Object object) {
        if (object.getIndexes() != null && object.getIndexes().getIndex() != null && object.getIndexes().getIndex().size() > 0) {
            List indexes = object.getIndexes().getIndex();
            HashMap<String, List<String>> indexesDto = new HashMap<String, List<String>>();
            for (Index index : indexes) {
                if (index.getIndexField() == null || index.getIndexField().size() <= 0) continue;
                List indexFields = index.getIndexField();
                ArrayList<String> indexFieldsDto = new ArrayList<String>();
                for (Indexfield indexField : indexFields) {
                    indexFieldsDto.add(indexField.getName());
                }
                indexesDto.put(index.getName(), indexFieldsDto);
            }
            return indexesDto;
        }
        return null;
    }

    public static List<String> getPrimaryKeys(com.konylabs.middleware.registry.vo.Object object) {
        List keyset;
        ArrayList<String> primaryKeys = new ArrayList<String>();
        if (object.getKey() != null && object.getKey().getKeyField() != null && object.getKey().getKeyField().size() != 0 && ((Keyfield)object.getKey().getKeyField().get(0)).getName() != null && (keyset = object.getKey().getKeyField()).size() > 0) {
            for (Keyfield keyfield : keyset) {
                primaryKeys.add(keyfield.getName());
            }
        }
        return primaryKeys;
    }

    public static void setObjectParamsToObjectDto(Map<String, String> objectParamMap, ObjectDto objectDto) {
        if (objectParamMap != null && !objectParamMap.isEmpty()) {
            for (Map.Entry<String, String> objectparam : objectParamMap.entrySet()) {
                MetadataUtils.setObjectparamInObjectDto(objectDto, objectparam.getKey(), objectparam.getValue());
            }
        } else {
            objectDto.setOffline("false");
        }
    }

    public static void setObjectparamInObjectDto(ObjectDto objectDto, String objectParamName, String objectParamValue) {
        ObjectParamEnum objectParamEnum = ObjectParamEnum.getObjectParamByValue(objectParamName);
        if (objectParamEnum != null) {
            switch (objectParamEnum) {
                case storage: {
                    objectDto.setStorage(objectParamValue);
                    break;
                }
                case offline: {
                    objectDto.setOffline(objectParamValue != null ? objectParamValue : "false");
                    break;
                }
                case cache_timeOut: {
                    objectDto.setCache_timeout(Long.parseLong(objectParamValue));
                    break;
                }
                case conflict_policy: {
                    objectDto.setConflict_policy(objectParamValue);
                    break;
                }
            }
        }
    }

    public static FieldDto getFieldDtoFromField(Field field, List<String> primaryFieldNames) {
        FieldDto fieldDto = new FieldDto("");
        fieldDto.setName(field.getName());
        fieldDto.setDatatype(field.getDatatype());
        if ("date".equalsIgnoreCase(fieldDto.getDatatype())) {
            fieldDto.setDate_format(dateFormat);
        }
        for (Fieldparam fieldParam : field.getFieldParam()) {
            FieldparamEnum fieldparamEnum = FieldparamEnum.getFiledParamByValue(fieldParam.getName());
            if (fieldparamEnum == null) continue;
            switch (fieldparamEnum) {
                case autoGenerated: {
                    fieldDto.setAuto_generated(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case updateable: {
                    fieldDto.setUpdatable(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case sourceDatatype: {
                    fieldDto.setSource_datatype(fieldParam.getValue());
                    break;
                }
                case nullable: {
                    fieldDto.setNullable(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case creatable: {
                    fieldDto.setCreatable(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case fieldlength: {
                    fieldDto.setLength(Integer.parseInt(fieldParam.getValue()));
                    break;
                }
                case timeStampFieldFormat: {
                    fieldDto.setDate_format(dateFormat);
                    break;
                }
            }
        }
        return fieldDto;
    }

    public static FieldDto getFieldDtoFromFieldMetadata(FieldMetadata fieldMetadata, List<String> primaryFieldNames) {
        FieldDto fieldDto = new FieldDto("");
        fieldDto.setName(fieldMetadata.getName());
        fieldDto.setDatatype(fieldMetadata.getDatatype());
        if ("date".equalsIgnoreCase(fieldDto.getDatatype())) {
            fieldDto.setDate_format(dateFormat);
        }
        fieldDto.setAuto_generated(fieldMetadata.isAutoGenerated());
        fieldDto.setUpdatable(fieldMetadata.isUpdateable());
        fieldDto.setSource_datatype(fieldMetadata.getSourceDatatype());
        fieldDto.setNullable(fieldMetadata.isNullable());
        fieldDto.setCreatable(fieldMetadata.isCreatable());
        fieldDto.setLength(fieldMetadata.getLength());
        if (fieldMetadata.isUpdateTimeStampField()) {
            fieldDto.setDate_format(dateFormat);
        }
        return fieldDto;
    }

    public static RelationshipDto getChildRelationshipDtoFromRelation(Relation relation) {
        RelationshipDto relationshipDto = new RelationshipDto("");
        relationshipDto.setName(relation.getName());
        relationshipDto.setCascade(relation.isCascade());
        relationshipDto.setType(relation.getType());
        relationshipDto.setTarget_object(relation.getTargetObject());
        ArrayList<String> sourceFields = new ArrayList<String>();
        ArrayList<String> targetFields = new ArrayList<String>();
        if (relation.getRelationFields() != null && relation.getRelationFields().getRelationField() != null && relation.getRelationFields().getRelationField().size() > 0) {
            List relationfields = relation.getRelationFields().getRelationField();
            for (Relationfield relationfield : relationfields) {
                sourceFields.add(relationfield.getSourceField());
                targetFields.add(relationfield.getTargetField());
            }
            relationshipDto.setSource_fields(sourceFields);
            relationshipDto.setTarget_fields(targetFields);
        }
        return relationshipDto;
    }

    public static UniqueKeys getUniqueKeysObjectFromUniqueKey(Uniquekey uniqueKey) {
        UniqueKeys uniqueKeys = new UniqueKeys();
        if (uniqueKey.getKeyField() != null && uniqueKey.getKeyField().size() > 0) {
            List keyfields = uniqueKey.getKeyField();
            ArrayList<String> uniquekey1 = new ArrayList<String>();
            for (Keyfield keyfield : keyfields) {
                uniquekey1.add(keyfield.getName());
            }
            uniqueKeys.setColumns(uniquekey1);
        }
        return uniqueKeys;
    }

    public static Map<String, SupportedObjectDto> setSupportedObjectsForEachOperation(Map<String, Operationmapping> operationMappingMap, ObjectDto objectDto) {
        HashMap<String, SupportedObjectDto> operations = new HashMap<String, SupportedObjectDto>();
        if (operationMappingMap != null) {
            for (Map.Entry<String, Operationmapping> entry : operationMappingMap.entrySet()) {
                String operation = entry.getKey();
                if (entry.getValue() == null) continue;
                SupportedObjects supportedObjects = entry.getValue().getSupportedObjects();
                SupportedObjectDto supportedObjectDto = null;
                if (supportedObjects != null) {
                    List supportedObjectsList = supportedObjects.getSupportedObject();
                    for (SupportedObject supportedObject : supportedObjectsList) {
                        supportedObjectDto = new SupportedObjectDto(supportedObject.getObjectid());
                        StringBuffer odataExpand = new StringBuffer();
                        MetadataUtils.setSupportedObjectDto(supportedObject, supportedObjectDto, operation, odataExpand, "");
                        if (odataExpand.length() <= 0) continue;
                        supportedObjectDto.setExpand(odataExpand.toString());
                    }
                } else {
                    supportedObjectDto = new SupportedObjectDto(objectDto.getName());
                }
                operations.put(operation, supportedObjectDto);
            }
        }
        objectDto.setOperations(operations);
        return operations;
    }

    private static void setSupportedObjectDto(SupportedObject supportedObject, SupportedObjectDto supportedObjectDto, String operation, StringBuffer odataExpand, String parentHierarchyForGet) {
        List actionsList = supportedObject.getActions();
        ActionsDto actionsDto = null;
        if (actionsList != null && actionsList.size() > 0) {
            for (Actions actions : actionsList) {
                String actionTypes = actions.getType();
                StringTokenizer st = new StringTokenizer(actionTypes, ",");
                actionsDto = new ActionsDto();
                while (st.hasMoreTokens()) {
                    String actionType = st.nextToken();
                    actionsDto.getType().add(actionType);
                }
                List supportedObjectList = actions.getSupportedObject();
                MetadataUtils.updateSupportedObjectDto(operation, supportedObjectList, actionsDto, odataExpand, parentHierarchyForGet);
                supportedObjectDto.getActions().add(actionsDto);
            }
        } else {
            String actionTypes = MetadataUtils.getActionTypesBasedOnOperation(operation);
            StringTokenizer st = new StringTokenizer(actionTypes, ",");
            actionsDto = new ActionsDto();
            while (st.hasMoreTokens()) {
                String actionType = st.nextToken();
                actionsDto.getType().add(actionType);
            }
            List supportedObjectList = supportedObject.getSupportedObject();
            MetadataUtils.updateSupportedObjectDto(operation, supportedObjectList, actionsDto, odataExpand, parentHierarchyForGet);
            supportedObjectDto.getActions().add(actionsDto);
        }
    }

    public static void updateSupportedObjectDto(String operation, List<SupportedObject> supportedObjectList, ActionsDto actionsDto, StringBuffer odataExpand, String parentHierarchyForGet) {
        if (supportedObjectList != null && supportedObjectList.size() > 0) {
            for (SupportedObject childSupportedObject : supportedObjectList) {
                SupportedObjectDto childSupportedObjectDto = new SupportedObjectDto(childSupportedObject.getObjectid());
                MetadataUtils.setSupportedObjectDto(childSupportedObject, childSupportedObjectDto, operation, odataExpand, OperationEnum.get.getOperationName().equalsIgnoreCase(operation) ? MetadataUtils.buildOdataExpand(parentHierarchyForGet, childSupportedObject) : parentHierarchyForGet);
                actionsDto.getSupportedObjects().add(childSupportedObjectDto);
            }
        } else {
            if (odataExpand.length() > 0) {
                odataExpand.append(",");
            }
            odataExpand.append(parentHierarchyForGet);
        }
    }

    public static String buildOdataExpand(String parentHierarchyForGet, SupportedObject childSupportedObject) {
        StringBuffer parentHierarchy = new StringBuffer();
        if (parentHierarchyForGet.isEmpty()) {
            parentHierarchy.append(childSupportedObject.getObjectid());
        } else {
            parentHierarchy.append(parentHierarchyForGet + "/" + childSupportedObject.getObjectid());
        }
        return parentHierarchy.toString();
    }

    private static String getActionTypesBasedOnOperation(String operation) {
        if (OperationEnum.get.getOperationName().equalsIgnoreCase(operation)) {
            return new String(OperationEnum.get.getOperationName());
        }
        if (OperationEnum.delete.getOperationName().equalsIgnoreCase(operation)) {
            return new String(OperationEnum.delete.getOperationName());
        }
        return new String(OperationEnum.create.getOperationName() + "," + OperationEnum.update.getOperationName() + "," + OperationEnum.partialupdate.getOperationName());
    }

    public static <T> ObjectMetadataBean<T> getMetadataBeanFromType(String metadataBeanType) {
        if ("com.konylabs.middleware.registry.vo.Field".equalsIgnoreCase(metadataBeanType)) {
            return new ObjectMetadataBean("");
        }
        if ("com.konylabs.middleware.registry.vo.Relation".equalsIgnoreCase(metadataBeanType)) {
            return new ObjectMetadataBean("");
        }
        return null;
    }

    public static <T> String getMetadataType(ObjectMetadataBean<T> publishedObjectMetadataBean) {
        if ("com.konylabs.middleware.objservices.metadata.FieldDto".equalsIgnoreCase(publishedObjectMetadataBean.getMetadata().getClass().getName())) {
            return "com.konylabs.middleware.registry.vo.Field";
        }
        if ("com.konylabs.middleware.objservices.metadata.RelationshipDto".equalsIgnoreCase(publishedObjectMetadataBean.getMetadata().getClass().getName())) {
            return "com.konylabs.middleware.registry.vo.Relation";
        }
        return null;
    }

    public static String getMetadataFromAppDiffBean(Timestamp timestamp, ApplicationDiffBean toBePublishedAppDiffBean, ResponseDto responseDto) {
        List<NamespaceDto> namespaceDtoList = IncrementalMetadataHelper.getNamespaceDtosFromAppDiffBean(toBePublishedAppDiffBean);
        IncrementalMetadataHelper.setAppConfigParamsToRespDto(toBePublishedAppDiffBean, responseDto);
        responseDto.setNamespaces(namespaceDtoList);
        MetadataUtils.setResponseDto(responseDto, timestamp);
        return MetadataUtils.getGsonStringFromResponseDto(responseDto, new GsonBuilder());
    }

    public static String getGsonStringFromResponseDto(ResponseDto responseDto, GsonBuilder gsonBuilder) {
        Gson gson = gsonBuilder.create();
        String metadata = gson.toJson((Object)responseDto);
        return metadata;
    }

    public static ApplicationDiffBean getAppDiffBeanFromSerializedObject(InputStream publishedAppDiffBlobAsStream) throws SQLException {
        Gson gson = new Gson();
        ApplicationDiffBean appDiffBean = new ApplicationDiffBean();
        ResponseDto responseDto = (ResponseDto)gson.fromJson((Reader)new InputStreamReader(publishedAppDiffBlobAsStream), ResponseDto.class);
        List<NamespaceDto> namespaceDtoList = responseDto.getNamespaces();
        for (int i = 0; i < namespaceDtoList.size(); ++i) {
            NamespaceDto namespaceDto = namespaceDtoList.get(i);
            String namespace = namespaceDto.getName();
            List<ObjectDto> objectDtoList = namespaceDto.getObjects();
            for (int j = 0; j < objectDtoList.size(); ++j) {
                ObjectDto objectDto = objectDtoList.get(j);
                String objectId = MetadataUtils.getObjectIdBasedOnNamespaceAndObject(namespace, objectDto.getName());
                String actionOnObject = objectDto.getAction();
                ObjectBean objectBean = new ObjectBean(actionOnObject, objectId);
                if (!ActionBean.ACTION_VALUES.CREATE.name().equalsIgnoreCase(actionOnObject)) {
                    List<RelationshipDto> relationshipDtoList;
                    List<FieldDto> fieldDtoList = objectDto.getFields();
                    if (fieldDtoList != null) {
                        if (fieldDtoList.size() == 0) {
                            objectBean.getObjectDto().setFields(fieldDtoList);
                        } else {
                            objectBean.getObjectDto().setFields(new ArrayList<FieldDto>());
                            for (FieldDto fieldDto : fieldDtoList) {
                                ObjectMetadataBean<FieldDto> fieldMetadata = new ObjectMetadataBean<FieldDto>(fieldDto.getAction(), fieldDto);
                                MetadataKey metadataKey = new MetadataKey(fieldDto.getName(), "com.konylabs.middleware.registry.vo.Field");
                                objectBean.getObjectMetadataMap().put(metadataKey, fieldMetadata);
                            }
                        }
                    }
                    if ((relationshipDtoList = objectDto.getRelationships()) != null) {
                        if (relationshipDtoList.size() == 0) {
                            objectBean.getObjectDto().setRelationships(relationshipDtoList);
                        } else {
                            objectBean.getObjectDto().setRelationships(new ArrayList<RelationshipDto>());
                            for (RelationshipDto relationshipDto : relationshipDtoList) {
                                ObjectMetadataBean<RelationshipDto> relationMetadata = new ObjectMetadataBean<RelationshipDto>(relationshipDto.getAction(), relationshipDto);
                                MetadataKey metadataKey = new MetadataKey(relationshipDto.getName(), "com.konylabs.middleware.registry.vo.Relation");
                                objectBean.getObjectMetadataMap().put(metadataKey, relationMetadata);
                            }
                        }
                    }
                } else {
                    objectBean.setObjectDto(objectDto);
                }
                objectBean.getObjectDto().setKey(objectDto.getKey());
                objectBean.getObjectDto().setDelete_keys(objectDto.getDelete_keys());
                objectBean.getObjectDto().setCache_timeout(objectDto.getCache_timeout());
                objectBean.getObjectDto().setDelta_context_field(objectDto.getDelta_context_field());
                objectBean.getObjectDto().setObject_group(objectDto.getObject_group());
                objectBean.getObjectDto().setOffline(objectDto.isOffline());
                objectBean.getObjectDto().setStorage(objectDto.getStorage());
                appDiffBean.getAppDiffMap().put(objectId, objectBean);
            }
        }
        if (Boolean.parseBoolean(responseDto.isOffline())) {
            appDiffBean.getAppConfigParmDiffMap().put("conflict_policy", responseDto.getConflict_policy());
            appDiffBean.getAppConfigParmDiffMap().put(ObjectParamEnum.uploadCache.name(), responseDto.isUploadCache());
        }
        appDiffBean.getAppConfigParmDiffMap().put(ObjectParamEnum.offline.name(), responseDto.isOffline());
        return appDiffBean;
    }

    public static void setResponseDto(ResponseDto responseDto, Timestamp timestamp) {
        responseDto.setOpstatus(0);
        responseDto.setHttpStatusCode(200);
        if (timestamp != null) {
            responseDto.setTimestamp(MetadataUtils.getTimeTillSeconds(timestamp));
        }
    }

    public static long getTimeTillSeconds(Timestamp timestamp) {
        return 1000L * (timestamp.getTime() / 1000L);
    }

    public static String getMetadataFromAppDiffBean(Blob publishedAppDiffBlob, Timestamp nextTimeStampToBeUsedInFilter) {
        String metadata = "";
        ResponseDto responseDto = new ResponseDto();
        try {
            byte[] publishedAppDiffBlobAsBytes = DBUtils.uncompressAndDecrypt((Blob)publishedAppDiffBlob, (String)"gzipdata");
            ByteArrayInputStream publishedAppDiffBlobAsStream = new ByteArrayInputStream(publishedAppDiffBlobAsBytes);
            Gson gson = new Gson();
            responseDto = (ResponseDto)gson.fromJson((Reader)new InputStreamReader(publishedAppDiffBlobAsStream), ResponseDto.class);
            responseDto.setTimestamp(nextTimeStampToBeUsedInFilter.getTime());
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(FieldDto.class, (Object)new CustomSerializerForFieldDto());
            metadata = MetadataUtils.getGsonStringFromResponseDto(responseDto, gsonBuilder);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while performing incremental metadata", (Throwable)e);
        }
        return metadata;
    }

    private static String getObjectIdBasedOnNamespaceAndObject(String namespace, String objectId) {
        return StringUtils.isEmpty((String)namespace) ? objectId : namespace + "." + objectId;
    }

    public static String getServiceVersionForMetadata(String versionInHeader) {
        if (!StringUtils.isEmpty((String)versionInHeader)) {
            return versionInHeader;
        }
        return "1.0";
    }
}

