/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.objservices.metadata;

import com.konylabs.middleware.appservices.common.constants.ObjectParamEnum;
import com.konylabs.middleware.appservices.common.dataaccess.dto.ResponseDto;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.vo.ConfigParam;

public enum ObjectServiceConfig {
    conflict_policy{

        @Override
        public void setObjectServiceConfig(ResponseDto responseDto, ApplicationMetadata appMetadata) {
            ConfigParam conflictConfigParam = appMetadata.getConfigParamByParamName("conflict_policy");
            if (conflictConfigParam != null) {
                responseDto.setConflict_policy(conflictConfigParam.getValue());
            }
        }
    }
    ,
    offline{

        @Override
        public void setObjectServiceConfig(ResponseDto responseDto, ApplicationMetadata appMetadata) {
            ConfigParam offlineConfigParam = appMetadata.getConfigParamByParamName(ObjectParamEnum.offline.name());
            String offlineParamValue = offlineConfigParam != null ? offlineConfigParam.getValue() : "false";
            responseDto.setOffline(offlineParamValue);
        }
    }
    ,
    uploadCache{

        @Override
        public void setObjectServiceConfig(ResponseDto responseDto, ApplicationMetadata appMetadata) {
            ConfigParam uploadCacheConfigParam = appMetadata.getConfigParamByParamName(ObjectParamEnum.uploadCache.name());
            if (uploadCacheConfigParam != null) {
                responseDto.setUploadCache(uploadCacheConfigParam.getValue());
            }
        }
    };


    public abstract void setObjectServiceConfig(ResponseDto var1, ApplicationMetadata var2);

    public static void setObjectServiceConfigToResponseDto(ResponseDto responseDto, ApplicationMetadata appMetadata) {
        for (ObjectServiceConfig objectServiceConfig : ObjectServiceConfig.values()) {
            objectServiceConfig.setObjectServiceConfig(responseDto, appMetadata);
        }
    }
}

