/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.objservices.metadata;

import com.konylabs.middleware.appservices.common.dataaccess.dao.LocalMetadataDaoImpl;
import com.konylabs.middleware.appservices.common.dataaccess.dto.ResponseDto;
import com.konylabs.middleware.appservices.common.dataaccess.exception.DataAccessException;
import com.konylabs.middleware.objservices.metadata.IObjectServiceMetadata;
import com.konylabs.middleware.objservices.metadata.MetadataUtils;
import com.konylabs.middleware.objservices.metadata.NamespaceDto;
import com.konylabs.middleware.objservices.metadata.ObjectDto;
import com.konylabs.middleware.objservices.metadata.ObjectServiceConfig;
import com.konylabs.middleware.objservices.runtime.metadata.DeltaContextFieldObject;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.SoftDeleteFieldObject;
import com.konylabs.middleware.registry.impl.ActionBean;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ObjectServiceMetadataImpl
implements IObjectServiceMetadata {
    private static final Logger LOGGER = Logger.getLogger(LocalMetadataDaoImpl.class);

    @Override
    public ResponseDto getObjectServiceMetadata(ApplicationMetadata appMetadata) throws DataAccessException {
        ResponseDto responseDto = new ResponseDto();
        HashMap<String, List<ObjectDto>> namespaceMap = new HashMap<String, List<ObjectDto>>();
        ArrayList<NamespaceDto> namespaceDtos = null;
        if (appMetadata != null) {
            namespaceDtos = new ArrayList<NamespaceDto>();
            ObjectServiceConfig.setObjectServiceConfigToResponseDto(responseDto, appMetadata);
            List<String> objectNames = appMetadata.getObjectNames();
            for (String string : objectNames) {
                this.getObjectDtoFromObject(appMetadata, string, namespaceMap);
            }
            if (namespaceMap != null && namespaceMap.size() > 0) {
                for (Map.Entry entry : namespaceMap.entrySet()) {
                    NamespaceDto namespaceDto = new NamespaceDto("");
                    namespaceDto.setName((String)entry.getKey());
                    namespaceDto.setAction(ActionBean.ACTION_VALUES.CREATE.name());
                    namespaceDto.setObjects((List)entry.getValue());
                    namespaceDtos.add(namespaceDto);
                }
            }
            if (namespaceDtos.size() == 0) {
                LOGGER.error((Object)"Error in getTableDto, object not found");
                throw new DataAccessException(404006, "Object not found", null);
            }
            responseDto.setNamespaces(namespaceDtos);
            return responseDto;
        }
        LOGGER.error((Object)"Error in getTableDto, object service not found");
        throw new DataAccessException(404005, "Object service not found", null);
    }

    private void getObjectDtoFromObject(ApplicationMetadata appMetadata, String objectID, Map<String, List<ObjectDto>> namespaceMap) {
        DeltaContextFieldObject deltaContextObject;
        ObjectMetadata objectMetadata = appMetadata.getObjectMetadata(objectID);
        String namespace = objectID.contains(".") ? objectID.split("\\.")[0] : "";
        List<ObjectDto> objectDtoList = null;
        if (namespaceMap != null && (objectDtoList = namespaceMap.get(namespace)) == null) {
            objectDtoList = new ArrayList<ObjectDto>();
        }
        ObjectDto objectDto = new ObjectDto("");
        objectDto.setName(objectID.contains(".") ? objectID.split("\\.")[1] : objectID);
        objectDto.setKey(objectMetadata.getPrimaryKeys());
        MetadataUtils.setObjectParamsToObjectDto(objectMetadata.getObjectParamMap(), objectDto);
        objectDto.setObject_group(appMetadata.getObjectGroupMap().get(objectID).getName());
        objectDto.setRelationships(objectMetadata.getRelationshipMetadata());
        objectDto.setUnique_keys(objectMetadata.getUniqueKeys());
        MetadataUtils.setFieldMetadataToObjectDto(objectMetadata.getFieldMetadataMap(), objectDto);
        objectDto.setIndexes(objectMetadata.getIndexes());
        SoftDeleteFieldObject softDeleteObject = objectMetadata.getSoftDeleteFieldObj();
        if (softDeleteObject != null) {
            objectDto.setSoftdelete_field(softDeleteObject.getSoftDeleteFieldName());
        }
        if ((deltaContextObject = objectMetadata.getDeltaContextfieldObj()) != null) {
            objectDto.setDelta_context_field(deltaContextObject.getDeltaContextFieldName());
        }
        MetadataUtils.setSupportedObjectsForEachOperation(appMetadata.getOperatonMapingByObjectId(objectID), objectDto);
        if (namespaceMap != null) {
            objectDtoList.add(objectDto);
            namespaceMap.put(namespace, objectDtoList);
        }
    }
}

