/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.objservices.runtime;

import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.servlet.RowUploadHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.objservices.runtime.ConflictDetector;
import com.konylabs.middleware.objservices.runtime.ConflictHolder;
import com.konylabs.middleware.objservices.runtime.ConflictResolver;
import com.konylabs.middleware.objservices.runtime.ConflictType;
import com.konylabs.middleware.objservices.runtime.CreateConflictDetector;
import com.konylabs.middleware.objservices.runtime.DeleteConflictDetector;
import com.konylabs.middleware.objservices.runtime.UpdateConflictDetector;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.SoftDeleteFieldObject;
import com.konylabs.middleware.request.builder.GetAfterConflictResolver;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.Row;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;

public class ConflictResolvingHandler
implements RowUploadHandler {
    private static final Logger LOGGER = Logger.getLogger(ConflictResolvingHandler.class);
    private static final Map<String, ConflictDetector> conflictDetectorMap = new HashMap<String, ConflictDetector>();
    private final Row requestRow;
    private final ConflictResolver conflictResolver;
    private final InputPayloadMetadata inputPayloadMetadata;
    private final GetAfterConflictResolver rowUploadHandler;

    public ConflictResolvingHandler(Row requestRow, InputPayloadMetadata inputPayloadMetadata, ConflictResolver conflictResolver, GetAfterConflictResolver rowUploadHandler) {
        this.requestRow = requestRow;
        this.inputPayloadMetadata = inputPayloadMetadata;
        this.conflictResolver = conflictResolver;
        this.rowUploadHandler = rowUploadHandler;
    }

    private ConflictHolder conflictDetector(ConflictDetector detector, Row result) throws JSONException {
        JsonObject responseJsonOnGet = result.getJsonElement().getAsJsonObject();
        ConflictHolder conflictHolder = null;
        if (responseJsonOnGet.toString().equals("{}")) {
            conflictHolder = detector.detectIfBackendHasNoRecord("", this.requestRow);
        } else {
            String serverCheckSum = result.getMetadata().getCheckSum();
            conflictHolder = this.checkIfJsonObjectHasSoftDeleteFieldSet(responseJsonOnGet) ? detector.detectIfBackendHasRecordWithSoftDeleteSet(serverCheckSum, this.requestRow) : detector.detectIfBackendHasRecord(serverCheckSum, this.requestRow);
        }
        return conflictHolder;
    }

    private void conflictsResolver(ConflictResolver conflictResolver, ConflictHolder conflictHolder, Row result, Context context) {
        if (ConflictType.CLIENT_CREATE_SERVER_EXISTS.name().equalsIgnoreCase(conflictHolder.getConflictType().name())) {
            conflictResolver.resolveClientCreateServerExists(this.requestRow, result, this.inputPayloadMetadata, context, conflictHolder.isBackendRecordSoftDeleted());
        } else if (ConflictType.CLIENT_UPDATE_SERVER_UPDATE.name().equalsIgnoreCase(conflictHolder.getConflictType().name())) {
            conflictResolver.resolveClientUpdateServerUpdate(this.requestRow, result, this.inputPayloadMetadata, context, conflictHolder.isBackendRecordSoftDeleted());
        } else if (ConflictType.CLIENT_UPDATE_SERVER_DELETE.name().equalsIgnoreCase(conflictHolder.getConflictType().name())) {
            conflictResolver.resolveClientUpdateServerDelete(this.requestRow, result, this.inputPayloadMetadata, context, conflictHolder.isBackendRecordSoftDeleted());
        } else if (ConflictType.CLIENT_DELETE_SERVER_UPDATE.name().equalsIgnoreCase(conflictHolder.getConflictType().name())) {
            conflictResolver.resolveClientDeleteServerUpdate(this.requestRow, result, this.inputPayloadMetadata, context, conflictHolder.isBackendRecordSoftDeleted());
        } else {
            conflictResolver.resolveClientDeleteServerDelete(this.requestRow, result, this.inputPayloadMetadata, context, conflictHolder.isBackendRecordSoftDeleted());
        }
    }

    protected boolean checkIfJsonObjectHasSoftDeleteFieldSet(JsonObject resultJson) throws JSONException {
        ObjectMetadata objMetadata = this.requestRow.getMetadata().getObjectMetadata();
        SoftDeleteFieldObject softDeleteObject = objMetadata.getSoftDeleteFieldObj();
        if (softDeleteObject != null) {
            String softDeleteField = softDeleteObject.getSoftDeleteFieldName();
            return resultJson.has(softDeleteField) && this.isRowDeleted(softDeleteObject, resultJson.get(softDeleteField).getAsString());
        }
        return false;
    }

    protected boolean isRowDeleted(SoftDeleteFieldObject softDeleteObject, String softDeleteFieldValue) {
        if (softDeleteObject.getDeletedValue() != null) {
            return softDeleteObject.getDeletedValue().equals(softDeleteFieldValue);
        }
        return !softDeleteObject.getActiveValue().equals(softDeleteFieldValue);
    }

    @Override
    public void onSuccess(HttpServletRequest request, HttpServletResponse response, Row result, Context context) {
        try {
            ConflictDetector detector = conflictDetectorMap.get(this.requestRow.getMetadata().getOperationId());
            ConflictHolder conflictHolder = this.conflictDetector(detector, result);
            context.put("handler", (Object)this.rowUploadHandler);
            if (ConflictType.NONE.name().equalsIgnoreCase(conflictHolder.getConflictType().name())) {
                LOGGER.debug((Object)"no conflict");
                this.requestRow.getStrategy().process(this.requestRow, this.inputPayloadMetadata, context);
            } else {
                LOGGER.debug((Object)"conflict has occured");
                MetricsBean metricsBean = (MetricsBean)request.getAttribute("metricsBean");
                metricsBean.incrementParamValue("cnfcnt", 1L);
                this.conflictsResolver(this.conflictResolver, conflictHolder, result, context);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Error while resolving conflicts", (Throwable)ex);
            this.rowUploadHandler.onError(request, response, ex, context);
        }
    }

    @Override
    public void onError(HttpServletRequest request, HttpServletResponse response, Exception exception, Context context) {
        this.rowUploadHandler.onError(request, response, exception, context);
    }

    @Override
    public void onFailure(HttpServletRequest request, HttpServletResponse response, Row result, Context context) {
        this.rowUploadHandler.onFailure(request, response, result, context);
    }

    static {
        conflictDetectorMap.put(OperationEnum.create.toString(), new CreateConflictDetector());
        conflictDetectorMap.put(OperationEnum.update.toString(), new UpdateConflictDetector());
        conflictDetectorMap.put(OperationEnum.delete.toString(), new DeleteConflictDetector());
    }
}

