/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.objservices.runtime;

import com.konylabs.middleware.objservices.runtime.ConflictDetector;
import com.konylabs.middleware.objservices.runtime.ConflictHolder;
import com.konylabs.middleware.objservices.runtime.ConflictType;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowUtil;
import org.apache.log4j.Logger;

public class DeleteConflictDetector
implements ConflictDetector {
    private static final Logger LOGGER = Logger.getLogger(DeleteConflictDetector.class);

    @Override
    public ConflictHolder detectIfBackendHasNoRecord(String serverCheckSum, Row requestRow) {
        ConflictHolder conflictHolder = new ConflictHolder(ConflictType.CLIENT_DELETE_SERVER_DELETE);
        return conflictHolder;
    }

    @Override
    public ConflictHolder detectIfBackendHasRecordWithSoftDeleteSet(String serverCheckSum, Row requestRow) {
        ConflictHolder conflictHolder = new ConflictHolder(ConflictType.CLIENT_DELETE_SERVER_DELETE);
        conflictHolder.setBackendRecordSoftDeleted(true);
        return conflictHolder;
    }

    @Override
    public ConflictHolder detectIfBackendHasRecord(String serverCheckSum, Row requestRow) {
        ConflictHolder conflictHolder = null;
        try {
            conflictHolder = RowUtil.getChecksumFromRow(requestRow).equalsIgnoreCase(serverCheckSum) ? new ConflictHolder(ConflictType.NONE) : new ConflictHolder(ConflictType.CLIENT_DELETE_SERVER_UPDATE);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return conflictHolder;
    }
}

