/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.objservices.runtime.request.cache;

import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.environment.MiddlewareDbManager;
import com.konylabs.middleware.exceptions.MiddlewareDbException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.exceptions.ObjectServicesException;
import com.konylabs.middleware.objservices.runtime.request.cache.PurgeWithRotation;
import com.konylabs.middleware.objservices.runtime.request.cache.UploadCache;
import com.konylabs.middleware.objservices.runtime.request.cache.UploadCacheSQL;
import com.konylabs.middleware.objservices.runtime.request.cache.UploadCacheService;
import com.konylabs.middleware.utilities.DBUtils;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DatabaseUploadCacheImpl
implements UploadCacheService {
    private static final Logger LOGGER = Logger.getLogger(DatabaseUploadCacheImpl.class);
    private final String schemaName;

    public DatabaseUploadCacheImpl(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public void insertRequestToCache(String hash, long requestHitTime) throws MiddlewareException {
        this.executeUpsert("insertRequest", hash, null, false, requestHitTime);
    }

    @Override
    public void updateResponseToCache(String requestHash, Object response, boolean isException, long requestHitTime) throws MiddlewareException {
        this.executeUpsert("updateResponse", requestHash, response, isException, requestHitTime);
    }

    @Override
    public void deleteCacheOnMaxWaitTimeExceeded(String requestHash, long requestHitTime) throws MiddlewareException {
        this.executeUpsert("deleteCache", requestHash, null, false, requestHitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadCache getResponseFromCache(String hash) throws ObjectServicesException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        UploadCache uc;
        block4: {
            uc = null;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = this.getConnection();
                if (con == null) break block4;
                pstmt = con.prepareStatement(UploadCacheSQL.getSelectSQL());
                pstmt.setString(1, hash);
                pstmt.setString(2, hash);
                pstmt.setString(3, hash);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                uc = new UploadCache(rs.getLong(2));
                byte[] decompressedBytes = DBUtils.uncompressAndDecrypt((Blob)rs.getBlob(1), (String)"gzipdata");
                uc.setResponse(decompressedBytes != null ? new String(decompressedBytes) : null);
                uc.setErrorResponse(rs.getBoolean(3));
            }
            catch (Exception e) {
                try {
                    LOGGER.error((Object)"Exception while getting response from db cache ", (Throwable)e);
                    this.throwExceptionForUploadCacheDBConnection(e);
                }
                catch (Throwable throwable) {
                    Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, pstmt, con});
                    throw throwable;
                }
                Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, pstmt, con});
            }
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, pstmt, con});
        return uc;
    }

    public UploadCacheSQL getTableNameForRequest() throws ObjectServicesException {
        return PurgeWithRotation.getInstance().getTableNameAfterTruncate(this);
    }

    public UploadCacheSQL getTableNameForUpdateOrDelete(Long firstHitTime) throws ObjectServicesException {
        return PurgeWithRotation.getInstance().getTableNameByFirstHitTime(firstHitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateTable(String truncateSQL) throws ObjectServicesException {
        PreparedStatement stmt;
        Connection con;
        block4: {
            con = null;
            stmt = null;
            try {
                truncateSQL = DBUtils.getDbSpecificTruncateSQL((String)truncateSQL);
                con = this.getConnection();
                if (con == null) break block4;
                stmt = con.prepareStatement(truncateSQL);
                stmt.executeUpdate();
            }
            catch (Exception e) {
                try {
                    LOGGER.error((Object)"Exception while purging the tableName ", (Throwable)e);
                    this.throwExceptionForUploadCacheDBConnection(e);
                }
                catch (Throwable throwable) {
                    Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{stmt, con});
                    throw throwable;
                }
                Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{stmt, con});
            }
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{stmt, con});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void executeUpsert(String operation, String requestHash, Object response, boolean isException, Long requestResubmitHitTime) throws ObjectServicesException {
        block14: {
            PreparedStatement pstmt;
            Connection con;
            block12: {
                con = null;
                pstmt = null;
                con = this.getConnection();
                if (con != null) {
                    con.setAutoCommit(false);
                    pstmt = this.getPrepareStatementAfterBinding(con, operation, requestHash, response, isException, requestResubmitHitTime);
                    pstmt.executeUpdate();
                    con.commit();
                }
                if (con == null) break block12;
                try {
                    con.setAutoCommit(true);
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"Exception while setting auto commit in upserting response to db cache", (Throwable)e);
                }
            }
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{pstmt, con});
            break block14;
            catch (Exception e) {
                block13: {
                    try {
                        LOGGER.error((Object)"Exception while upserting response to db cache ", (Throwable)e);
                        this.throwExceptionForUploadCacheDBConnection(e);
                        if (con == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (con != null) {
                            try {
                                con.setAutoCommit(true);
                            }
                            catch (SQLException e2) {
                                LOGGER.error((Object)"Exception while setting auto commit in upserting response to db cache", (Throwable)e2);
                            }
                        }
                        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{pstmt, con});
                        throw throwable;
                    }
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (SQLException e3) {
                        LOGGER.error((Object)"Exception while setting auto commit in upserting response to db cache", (Throwable)e3);
                    }
                }
                Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{pstmt, con});
            }
        }
    }

    private PreparedStatement getPrepareStatementAfterBinding(Connection con, String operation, String requestHash, Object response, boolean isException, Long requestResubmitHitTime) throws SQLException, ObjectServicesException {
        PreparedStatement pstmt = null;
        switch (operation) {
            case "insertRequest": {
                pstmt = this.getInsertRequestToCachePStmt(requestHash, requestResubmitHitTime, con, this.getTableNameForRequest().getInsertSQL());
                break;
            }
            case "updateResponse": {
                pstmt = this.getUpdateResponseToCachePStmt(requestHash, response, isException, con, this.getTableNameForUpdateOrDelete(requestResubmitHitTime).getUpdateSQL());
                break;
            }
            case "deleteCache": {
                pstmt = this.getDeleteCacheOnMaxWaitTimeReachedPstmt(requestHash, con, this.getTableNameForUpdateOrDelete(requestResubmitHitTime).getDeleteSQL());
            }
        }
        return pstmt;
    }

    private PreparedStatement getUpdateResponseToCachePStmt(String requestHash, Object response, boolean isException, Connection con, String sql) throws SQLException {
        PreparedStatement pstmt = con.prepareStatement(sql);
        pstmt.setBytes(1, null != response ? DBUtils.compressAndEncrypt((InputStream)IOUtils.toInputStream((String)response.toString())) : null);
        pstmt.setBoolean(2, isException);
        pstmt.setString(3, requestHash);
        return pstmt;
    }

    private PreparedStatement getInsertRequestToCachePStmt(String hash, long requestHitTime, Connection con, String sql) throws SQLException {
        PreparedStatement pstmt = con.prepareStatement(sql);
        pstmt.setString(1, hash);
        pstmt.setLong(2, requestHitTime);
        return pstmt;
    }

    private PreparedStatement getDeleteCacheOnMaxWaitTimeReachedPstmt(String requestHash, Connection con, String sql) throws SQLException {
        PreparedStatement pstmt = con.prepareStatement(sql);
        pstmt.setString(1, requestHash);
        return pstmt;
    }

    private Connection getConnection() throws MiddlewareDbException {
        return MiddlewareDbManager.getConnectionForSingleOrMultiTenanancy((String)this.schemaName);
    }

    private ObjectServicesException throwExceptionForUploadCacheDBConnection(Exception e) throws ObjectServicesException {
        String errorMessage = ObjectServicesException.getErrorMessage("500212", e.getMessage());
        throw new ObjectServicesException("500212", errorMessage, 500);
    }
}

