/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.objservices.runtime.request.cache;

import com.konylabs.middleware.exceptions.ObjectServicesException;
import com.konylabs.middleware.objservices.runtime.request.cache.DatabaseUploadCacheImpl;
import com.konylabs.middleware.objservices.runtime.request.cache.UploadCachePurge;
import com.konylabs.middleware.objservices.runtime.request.cache.UploadCacheSQL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

public class PurgeWithRotation {
    private static final String ROTATE_ENUM_PREFIX = "TABLE";
    private static long epochDay;
    private static UploadCacheSQL todaysTable;
    private static final PurgeWithRotation purgeWithRotation;

    private PurgeWithRotation() {
    }

    public static PurgeWithRotation getInstance() {
        return purgeWithRotation;
    }

    public UploadCacheSQL getTableNameAfterTruncate(DatabaseUploadCacheImpl dbcache) throws ObjectServicesException {
        if (this.isDayChanged()) {
            UploadCachePurge currentPurgeTable = this.getNextRotate(LocalDate.now());
            dbcache.truncateTable(currentPurgeTable.getTruncateTable());
            todaysTable = currentPurgeTable.getDMLTable();
        }
        return todaysTable;
    }

    public UploadCacheSQL getTableNameByFirstHitTime(long firstHitTime) throws ObjectServicesException {
        return this.getNextRotate(this.getLocalDateFromMilliseconds(firstHitTime)).getDMLTable();
    }

    private LocalDate getLocalDateFromMilliseconds(long firstHitTime) {
        return Instant.ofEpochMilli(firstHitTime).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public UploadCachePurge getNextRotate(LocalDate localDate) {
        return UploadCachePurge.valueOf(ROTATE_ENUM_PREFIX + localDate.toEpochDay() % 3L);
    }

    public boolean isDayChanged() {
        long today = LocalDate.now().toEpochDay();
        if (epochDay != today) {
            epochDay = today;
            return true;
        }
        return false;
    }

    static {
        purgeWithRotation = new PurgeWithRotation();
    }
}

