/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.registry.impl;

import com.kony.mapper.javascript.JavaScriptEngineWrapper;
import com.kony.mobilefabric.rest.ResourceTracer;
import com.kony.mobilefabric.rest.ResourceTracerImpl;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.api.processor.impl.ProcessorInfo;
import com.konylabs.middleware.frontendurls.FrontendResourceIdentifier;
import com.konylabs.middleware.processors.ServiceProcessorInfo;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.ModifiableAppCache;
import com.konylabs.middleware.registry.ServiceVersionCache;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class AbstractAppCache
implements ModifiableAppCache {
    private static final Logger LOGGER = Logger.getLogger(AbstractAppCache.class);
    private final Map<AppVersion, Timestamp> appTimestampCache = new HashMap<AppVersion, Timestamp>();
    private final Map<AppVersion, TreeMap<Timestamp, String>> appDiffTimestampCache = new LinkedHashMap<AppVersion, TreeMap<Timestamp, String>>();
    private final Map<String, Map<String, Object>> sharedAssetsCache = new HashMap<String, Map<String, Object>>();
    private final JavaScriptEngineWrapper javaScriptEngineWrapper;
    private final ServiceVersionCache serviceVersionCache = new ServiceVersionCache();
    private ResourceTracer resourceTracer = new ResourceTracerImpl();
    private FrontendResourceIdentifier frontendResourceIdentifier = new FrontendResourceIdentifier((AppCache)this);

    public AbstractAppCache(JavaScriptEngineWrapper javaScriptEngineWrapper) {
        this.javaScriptEngineWrapper = javaScriptEngineWrapper;
    }

    @Override
    public void putAppDiffResult(AppVersion appVersion, Timestamp createdTimestamp, String metadataResponse) {
        TreeMap<Timestamp, String> timestampMap = this.appDiffTimestampCache.get(appVersion);
        if (timestampMap == null) {
            timestampMap = new TreeMap();
        }
        timestampMap.put(createdTimestamp, metadataResponse);
        this.appDiffTimestampCache.put(appVersion, timestampMap);
    }

    public Timestamp getTimestamp(AppVersion appVersion) {
        return this.appTimestampCache.get(appVersion);
    }

    public String getAppDiffResult(AppVersion appVersion, Timestamp timestamp) {
        TreeMap<Timestamp, String> timestampMap = this.appDiffTimestampCache.get(appVersion);
        if (timestampMap != null) {
            String metadataResponse = timestampMap.get(timestamp);
            if (metadataResponse == null && timestampMap.higherEntry(timestamp) != null) {
                metadataResponse = timestampMap.higherEntry(timestamp).getValue();
            }
            return metadataResponse;
        }
        return null;
    }

    @Override
    public void putTimestamp(AppVersion appVersion, Timestamp timestamp) {
        this.appTimestampCache.put(appVersion, timestamp);
    }

    public Map<String, Map<String, Object>> getSharedAssetsCache() {
        return this.sharedAssetsCache;
    }

    @Override
    public void putSharedAsset(String assetType, String assetName, Object assetValue) {
        if (this.sharedAssetsCache.get(assetType) != null) {
            this.sharedAssetsCache.get(assetType).put(assetName, assetValue);
        } else {
            HashMap<String, Object> assetNameValueMap = new HashMap<String, Object>();
            assetNameValueMap.put(assetName, assetValue);
            this.sharedAssetsCache.put(assetType, assetNameValueMap);
        }
    }

    public Object getSharedAssetByName(String assetType, String assetName) {
        return this.sharedAssetsCache.get(assetType) != null ? this.sharedAssetsCache.get(assetType).get(assetName) : null;
    }

    public Map<String, Object> getSharedAssetMapByType(String assetType) {
        return this.sharedAssetsCache.get(assetType);
    }

    public JavaScriptEngineWrapper getJavaScriptEngineWrapper() {
        return this.javaScriptEngineWrapper;
    }

    @Override
    public void addProcessorMetadata(AppVersion appVersion, ServiceProcessorInfo metadata) {
    }

    public ProcessorInfo getProcessorMetadata(AppVersion appVersion, String objectIdVerb) {
        return null;
    }

    @Override
    public void removeProcessorMetadata(AppVersion appVersion) {
    }

    public ResourceTracer getResourceTracer() {
        return this.resourceTracer;
    }

    public FrontendResourceIdentifier getFrontendResourceIdentifier() {
        return this.frontendResourceIdentifier;
    }

    public void remove(AppVersion appVersion) {
        LOGGER.debug((Object)("Removing appVersion " + appVersion + " from Resource Identifier"));
        this.getFrontendResourceIdentifier().getResourceIdentifierBuilder().remove(appVersion);
        LOGGER.debug((Object)("Removing appVersion " + appVersion + " from Service Version cache"));
        this.getServiceVersionCache().remove(appVersion);
    }

    public ServiceVersionCache getServiceVersionCache() {
        return this.serviceVersionCache;
    }

    public void initializeFrontendResourceTracer(FrontendResourceIdentifier frontendResourceIdentifier) {
        this.frontendResourceIdentifier = frontendResourceIdentifier;
        this.resourceTracer = this.getFrontendResourceIdentifier().buildResourceTracer();
    }

    public String getRuntimeVersion(String appId) {
        String version = this.getServiceVersionCache().getHighestVersion(appId);
        if (version == null) {
            version = this.getHighestVersion(appId);
        }
        LOGGER.debug((Object)("Highest version identifier for appid " + appId + " is " + version));
        return version;
    }

    @Override
    public void addAppMetadata(AppVersion appVersion, ApplicationMetadata appMetadata) {
        LOGGER.debug((Object)("Adding app version to service version cache " + appVersion));
        this.getServiceVersionCache().putVersion(appVersion);
    }

    protected abstract String getHighestVersion(String var1);
}

