/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.registry.impl;

import com.kony.adapter.DataAdapterFactory;
import com.kony.adapter.criteria.ExpandTreeNode;
import com.kony.adapter.criteria.TreeNode;
import com.kony.middleware.db.DatabaseHelper;
import com.kony.middleware.db.DatabaseHelperFactory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.api.processor.impl.ProcessorInfo;
import com.konylabs.middleware.appservices.common.constants.FieldparamEnum;
import com.konylabs.middleware.appservices.common.constants.ObjectParamEnum;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.RelationshipType;
import com.konylabs.middleware.connectors.dataadapter.StorageConnectorUtils;
import com.konylabs.middleware.connectors.dataadapter.StorageDatabaseDetails;
import com.konylabs.middleware.connectors.dataadapter.StorageEntityMetadata;
import com.konylabs.middleware.connectors.dataadapter.StorageEntityMetadataBuilder;
import com.konylabs.middleware.frontendurls.ResourceIdentifierBuilder;
import com.konylabs.middleware.objservices.metadata.MetadataUtils;
import com.konylabs.middleware.objservices.metadata.ObjectDto;
import com.konylabs.middleware.objservices.metadata.RelationshipDto;
import com.konylabs.middleware.objservices.runtime.ConflictPolicy;
import com.konylabs.middleware.objservices.runtime.ConflictResolver;
import com.konylabs.middleware.objservices.runtime.metadata.DeltaContextFieldObject;
import com.konylabs.middleware.objservices.runtime.metadata.FieldMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.ParentChildType;
import com.konylabs.middleware.objservices.runtime.metadata.SoftDeleteFieldObject;
import com.konylabs.middleware.processors.ServiceProcessorInfo;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.ApplicationInfo;
import com.konylabs.middleware.registry.ModifiableAppCache;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.impl.StorageApplicationMetadata;
import com.konylabs.middleware.registry.vo.Application;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Field;
import com.konylabs.middleware.registry.vo.FieldMappings;
import com.konylabs.middleware.registry.vo.Fieldparam;
import com.konylabs.middleware.registry.vo.MappingField;
import com.konylabs.middleware.registry.vo.ObjectMapping;
import com.konylabs.middleware.registry.vo.ObjectMappings;
import com.konylabs.middleware.registry.vo.ObjectSource;
import com.konylabs.middleware.registry.vo.ObjectSourceMappings;
import com.konylabs.middleware.registry.vo.Objectgroup;
import com.konylabs.middleware.registry.vo.Objectparam;
import com.konylabs.middleware.registry.vo.Objectparams;
import com.konylabs.middleware.registry.vo.OperationMappings;
import com.konylabs.middleware.registry.vo.Operationmapping;
import com.konylabs.middleware.registry.vo.Relation;
import com.konylabs.middleware.registry.vo.Relationfield;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.registry.vo.Services;
import com.konylabs.middleware.request.builder.BaseCustomConflictResolver;
import com.konylabs.middleware.request.builder.ClientWinsConflictResolver;
import com.konylabs.middleware.request.builder.ConflictUploadStrategy;
import com.konylabs.middleware.request.builder.DefaultUploadStrategy;
import com.konylabs.middleware.request.builder.ServerWinsConflictResolver;
import com.konylabs.middleware.utilities.DBUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class ApplicationHelper {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHelper.class);

    public static Application buildApplication(InputStream fileStream) throws AppRegistryException {
        if (fileStream != null) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Application.class});
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
                XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(fileStream);
                Unmarshaller um = context.createUnmarshaller();
                return (Application)um.unmarshal(xmlStreamReader);
            }
            catch (Exception e) {
                String errorCode = "14023";
                String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
                throw new AppRegistryException(errorCode, errorMessage, e);
            }
        }
        return null;
    }

    public static AppVersion getAppVersionFromApplication(Application application) {
        LOGGER.debug((Object)"inside getAppMetadata(Application application)");
        String version = application.getApiVersion();
        if (StringUtils.isBlank((String)version)) {
            version = "1.0";
        }
        LOGGER.debug((Object)("version is " + version));
        LOGGER.debug((Object)("application id " + application.getId()));
        AppVersion appVersion = new AppVersion(application.getId(), version);
        return appVersion;
    }

    public static ApplicationMetadata prepareAppMetadata(Application application, ModifiableAppCache appCache, AppVersion appVersion, String envGuid) {
        ApplicationMetadata appMetadata = ApplicationHelper.buildAppMetadata(application, appCache, appVersion, envGuid);
        appCache.addAppMetadata(appVersion, appMetadata);
        return appMetadata;
    }

    public static ApplicationMetadata buildAppMetadata(Application application, ModifiableAppCache appCache, AppVersion appVersion, String envGuid) {
        LOGGER.debug((Object)"inside prepareAppMetadata");
        ApplicationMetadata appMetadata = null;
        if (StorageConnectorUtils.isStorageAsService(application)) {
            if (StringUtils.isBlank((String)envGuid)) {
                return null;
            }
            Map<String, StorageEntityMetadata> tableMetaMap = StorageEntityMetadataBuilder.buildEntityMetadataObject(application, envGuid);
            appMetadata = new StorageApplicationMetadata(appCache, tableMetaMap);
        } else {
            appMetadata = new ApplicationMetadata(appCache);
        }
        appMetadata.setApplicationVersion(appVersion);
        application.setApiVersion(appVersion.getVersion());
        try {
            appMetadata.setFunctions(application.getFunctions());
            ApplicationHelper.setServiceMetadataPerApp(application, appMetadata, envGuid);
            ArrayList configparamList = application.getAppconfig().getConfigparam();
            HashMap<String, ConfigParam> configparamMap = new HashMap<String, ConfigParam>();
            for (ConfigParam configParam : configparamList) {
                configparamMap.put(configParam.getName(), configParam);
            }
            appMetadata.setConfigParamMap(configparamMap);
            ObjectMappings objectMappings = application.getObjectMappings();
            if (objectMappings != null) {
                List objectMappingList = objectMappings.getObjectMapping();
                for (ObjectMapping objectMapping : objectMappingList) {
                    ObjectSourceMappings objectSrcMap;
                    OperationMappings operationMappings;
                    HashMap<String, String> fieldsMap = new HashMap<String, String>();
                    HashMap<String, Operationmapping> operationMap = new HashMap<String, Operationmapping>();
                    String objectId = objectMapping.getObjectid();
                    FieldMappings fieldMapping = objectMapping.getFieldMappings();
                    if (fieldMapping != null) {
                        List fieldParams = fieldMapping.getMappingField();
                        for (MappingField param : fieldParams) {
                            fieldsMap.put(param.getSourceField(), param.getTargetField());
                        }
                        appMetadata.getObjFieldMap().put(objectId, fieldsMap);
                    }
                    if ((operationMappings = objectMapping.getOperationMappings()) != null) {
                        MappingField param;
                        List operationMapping = operationMappings.getOperationMapping();
                        param = operationMapping.iterator();
                        while (param.hasNext()) {
                            Operationmapping param2 = (Operationmapping)param.next();
                            operationMap.put(param2.getOperation(), param2);
                        }
                        appMetadata.getOperatonMapingsMap().put(objectId, operationMap);
                    }
                    if ((objectSrcMap = objectMapping.getObjectSourceMappings()) == null) continue;
                    List objectSrcList = objectSrcMap.getObjectSource();
                    appMetadata.getObjectSourceMap().put(objectId, ApplicationHelper.prepareNodeList(objectSrcList));
                }
            }
            if (application.getObjectGroups() != null && application.getObjectGroups().getObjectGroup() != null && !application.getObjectGroups().getObjectGroup().isEmpty()) {
                ApplicationHelper.processObjectGroups(application, appMetadata);
                ApplicationHelper.setNextDownloadableObject(appMetadata);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while preparing appMetadata", (Throwable)e);
        }
        return appMetadata;
    }

    @Deprecated
    public static ApplicationMetadata prepareAppMetadata(Application application, ModifiableAppCache appCache, AppVersion appVersion) {
        return ApplicationHelper.prepareAppMetadata(application, appCache, appVersion, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationMetadata buildAppMetadataFromAppInfo(ApplicationInfo appInfo, AppVersion appVersion, ModifiableAppCache appCache, String envGuid) throws AppRegistryException, SQLException {
        ApplicationMetadata applicationMetadata;
        ByteArrayInputStream inputStream = null;
        try {
            byte[] decompress = DBUtils.uncompressAndDecrypt((Blob)appInfo.getAppContent(), (String)appInfo.getContentType());
            inputStream = new ByteArrayInputStream(decompress);
            Application application = ApplicationHelper.buildApplication(inputStream);
            applicationMetadata = ApplicationHelper.buildAppMetadata(application, appCache, appVersion, envGuid);
        }
        catch (Throwable throwable) {
            Closer.closeQuietly(inputStream);
            throw throwable;
        }
        Closer.closeQuietly((Closeable)inputStream);
        return applicationMetadata;
    }

    public static ServiceProcessorInfo preparePrePostProcessorsMetadata(ApplicationMetadata appMetadata, String jarModule) {
        LOGGER.debug((Object)("Preparing pre/post processors metadata for the service " + appMetadata.getApplicationVersion()));
        ServiceProcessorInfo serviceProcessorInfo = new ServiceProcessorInfo();
        appMetadata.getOperatonMapingsMap().forEach((objectId, operationMappings) -> operationMappings.forEach((operationId, operationMapping) -> {
            String serviceUniqueId = operationMapping.getServiceid();
            ServiceMetadata serviceMetadata = appMetadata.getServiceMetadata(serviceUniqueId);
            String requestProcessorName = serviceMetadata.getServiceConfigParamByParamName("requestprocessorname");
            String responseProcessorName = serviceMetadata.getServiceConfigParamByParamName("responseprocessorname");
            ProcessorInfo processorInfo = new ProcessorInfo(requestProcessorName, responseProcessorName, jarModule);
            LOGGER.debug((Object)String.format("Configured processor names for the object [%s] operation [%s] are %s", objectId, operationId, processorInfo));
            serviceProcessorInfo.addProcessorInfo(objectId.concat(":").concat((String)operationId), processorInfo);
        }));
        return serviceProcessorInfo;
    }

    private static void setNextDownloadableObject(ApplicationMetadata appMetadata) {
        List<String> objectOrderList = appMetadata.getObjectNames();
        for (int i = 0; i < objectOrderList.size() - 1; ++i) {
            appMetadata.getObjectMap().get(objectOrderList.get(i)).setNextdownloadableObjId(objectOrderList.get(i + 1));
        }
    }

    private static void processObjectGroups(Application application, ApplicationMetadata appMetadata) {
        List objectGroupList = application.getObjectGroups().getObjectGroup();
        HashMap<String, com.konylabs.middleware.registry.vo.Object> serviceDefObjMap = new HashMap<String, com.konylabs.middleware.registry.vo.Object>();
        HashMap<String, ObjectMetadata> objectMetadataMap = new HashMap<String, ObjectMetadata>();
        for (Objectgroup objectGroup : objectGroupList) {
            if (objectGroup.getObject() == null || objectGroup.getObject().isEmpty()) continue;
            List objects = objectGroup.getObject();
            for (com.konylabs.middleware.registry.vo.Object servicedefObject : objects) {
                serviceDefObjMap.put(servicedefObject.getId(), servicedefObject);
            }
            for (com.konylabs.middleware.registry.vo.Object servicedefObject : objects) {
                String objectName = servicedefObject.getName();
                appMetadata.getObjectGroupMap().put(objectName, objectGroup);
                if (appMetadata.getObjectMap().get(objectName) == null) {
                    String objGroupName = objectGroup.getName() != null ? objectGroup.getName() : "";
                    ObjectMetadata runtimeObject = ApplicationHelper.getObjectMetadata(objGroupName, servicedefObject, serviceDefObjMap, appMetadata, objectMetadataMap);
                    appMetadata.getObjectMap().put(objectName, runtimeObject);
                }
                appMetadata.getObjectNames().add(servicedefObject.getName());
            }
        }
    }

    private static void setConflictResolver(ObjectMetadata runtimeObject, ApplicationMetadata appMetadata) {
        ConfigParam configParam;
        String conflictPolicy = runtimeObject.getObjectParamMap().get(ObjectParamEnum.conflict_policy.toString());
        if (StringUtils.isEmpty((String)conflictPolicy) && (configParam = appMetadata.getConfigParamByParamName(ObjectParamEnum.conflict_policy.toString())) != null) {
            conflictPolicy = configParam.getValue();
            runtimeObject.getObjectParamMap().put(ObjectParamEnum.conflict_policy.toString(), conflictPolicy);
        }
        if (StringUtils.isEmpty((String)conflictPolicy) || ConflictPolicy.none.toString().equals(conflictPolicy)) {
            runtimeObject.setUploadRowStrategy(new DefaultUploadStrategy());
        } else {
            runtimeObject.setConflictResolver(ApplicationHelper.getConflictResolverBasedOnPolicy(conflictPolicy));
            runtimeObject.setUploadRowStrategy(new ConflictUploadStrategy());
        }
    }

    private static ConflictResolver getConflictResolverBasedOnPolicy(String conflictPolicy) {
        try {
            if (ConflictPolicy.client_win.name().equalsIgnoreCase(conflictPolicy)) {
                return new ClientWinsConflictResolver();
            }
            if (ConflictPolicy.server_win.name().equalsIgnoreCase(conflictPolicy)) {
                return new ServerWinsConflictResolver();
            }
            if (ConflictPolicy.custom.name().equalsIgnoreCase(conflictPolicy)) {
                return new BaseCustomConflictResolver();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static ObjectMetadata getObjectMetadata(String objectGroupName, com.konylabs.middleware.registry.vo.Object servicedefObject, Map<String, com.konylabs.middleware.registry.vo.Object> objectsMap, ApplicationMetadata appMetadata, Map<String, ObjectMetadata> objectMetadataMap) {
        List relationShipList;
        List objectparamList;
        ObjectMetadata runtimeObject = new ObjectMetadata(appMetadata);
        String objectName = servicedefObject.getName();
        runtimeObject.setId(servicedefObject.getId());
        runtimeObject.setName(objectName);
        runtimeObject.getObjectGroupName().add(objectGroupName);
        runtimeObject.setServiceDefObject(servicedefObject);
        objectMetadataMap.put(objectName, runtimeObject);
        runtimeObject.setPrimaryKeys(MetadataUtils.getPrimaryKeys(servicedefObject));
        Objectparams objectparams = servicedefObject.getObjectParams();
        if (objectparams != null && (objectparamList = objectparams.getObjectParam()) != null && !objectparamList.isEmpty()) {
            for (Objectparam objectparam : objectparamList) {
                runtimeObject.getObjectParamMap().put(objectparam.getName(), objectparam.getValue());
            }
        }
        runtimeObject.setUniqueKeys(MetadataUtils.getUniqueKeys(servicedefObject));
        String isOffline = runtimeObject.getObjectParamMap().get(ObjectParamEnum.offline.toString());
        if (isOffline != null && "true".equals(isOffline)) {
            runtimeObject.setOffline(true);
        }
        ApplicationHelper.setConflictResolver(runtimeObject, appMetadata);
        runtimeObject.setIndexes(MetadataUtils.getIndexes(servicedefObject));
        ApplicationHelper.processFieldsAndItsParams(servicedefObject, runtimeObject);
        List list = relationShipList = servicedefObject.getRelations() != null ? servicedefObject.getRelations().getRelation() : null;
        if (relationShipList != null) {
            for (Relation relation : relationShipList) {
                RelationshipDto relationshipMetadata = MetadataUtils.getChildRelationshipDtoFromRelation(relation);
                runtimeObject.getRelationshipMetadata().add(relationshipMetadata);
                if (!servicedefObject.getId().equalsIgnoreCase(relation.getTargetObject())) {
                    ObjectMetadata relatedObjectMetadata = objectMetadataMap.get(relation.getTargetObject());
                    if (objectsMap.get(relation.getTargetObject()) == null) continue;
                    if (relatedObjectMetadata == null) {
                        relatedObjectMetadata = ApplicationHelper.getObjectMetadata(objectGroupName, objectsMap.get(relation.getTargetObject()), objectsMap, appMetadata, objectMetadataMap);
                        appMetadata.getObjectMap().put(relation.getTargetObject(), relatedObjectMetadata);
                    }
                    ApplicationHelper.setParentChildTypeForRelatedObjectMetadata(appMetadata, runtimeObject, relation, relatedObjectMetadata);
                    continue;
                }
                ApplicationHelper.setParentChildTypeForRelatedObjectMetadata(appMetadata, runtimeObject, relation, runtimeObject);
            }
        }
        runtimeObject.getSupportedObjectHierarchy().putAll(MetadataUtils.setSupportedObjectsForEachOperation(appMetadata.getOperatonMapingByObjectId(objectName), new ObjectDto("", objectName)));
        return runtimeObject;
    }

    private static void setParentChildTypeForRelatedObjectMetadata(ApplicationMetadata appMetadata, ObjectMetadata runtimeObject, Relation relation, ObjectMetadata relatedObjectMetadata) {
        ParentChildType pcType = null;
        if (RelationshipType.OneToMany.name().equals(relation.getType())) {
            pcType = ApplicationHelper.getParentChildType(runtimeObject, relatedObjectMetadata, relation, appMetadata);
            ApplicationHelper.addRelationToAppMetadata(relatedObjectMetadata, pcType, appMetadata);
            runtimeObject.putChildObjectMetadata(relatedObjectMetadata.getId(), relatedObjectMetadata);
        } else if (RelationshipType.ManyToOne.name().equals(relation.getType())) {
            pcType = ApplicationHelper.getParentChildType(relatedObjectMetadata, runtimeObject, relation, appMetadata);
            ApplicationHelper.addRelationToAppMetadata(runtimeObject, pcType, appMetadata);
            relatedObjectMetadata.putChildObjectMetadata(runtimeObject.getId(), runtimeObject);
            relatedObjectMetadata.getParentChildList().add(pcType);
        }
        runtimeObject.getParentChildList().add(pcType);
    }

    public static ParentChildType getParentChildType(ObjectMetadata parentObject, ObjectMetadata childObject, Relation relation, ApplicationMetadata appMetadata) {
        ParentChildType pcType = new ParentChildType(relation.getName(), parentObject.getId(), childObject.getId());
        for (Relationfield relatedFields : relation.getRelationFields().getRelationField()) {
            pcType.addFields(relatedFields.getSourceField(), relatedFields.getTargetField());
        }
        return pcType;
    }

    private static void addRelationToAppMetadata(ObjectMetadata objMetadata, ParentChildType pcType, ApplicationMetadata appMetadata) {
        if (appMetadata.getParentChildListByChildObjectname().get(objMetadata.getName()) != null) {
            appMetadata.getParentChildListByChildObjectname().get(objMetadata.getName()).add(pcType);
        } else {
            ArrayList<ParentChildType> pcTypeList = new ArrayList<ParentChildType>();
            pcTypeList.add(pcType);
            appMetadata.getParentChildListByChildObjectname().put(objMetadata.getName(), pcTypeList);
        }
    }

    private static void processFieldsAndItsParams(com.konylabs.middleware.registry.vo.Object servicedefObject, ObjectMetadata runtimeObject) {
        LinkedHashMap<String, FieldMetadata> fieldMetadataMap = new LinkedHashMap<String, FieldMetadata>();
        for (Field field : servicedefObject.getFields().getField()) {
            FieldMetadata fieldMetadata = ApplicationHelper.getFieldMetadataFromField(field);
            if (fieldMetadata.isSoftDeleteField()) {
                SoftDeleteFieldObject softDeleteObj = new SoftDeleteFieldObject();
                softDeleteObj.setSoftDeleteFieldName(field.getName());
                if (fieldMetadata.getSoftDeleteInactiveValue() != null) {
                    softDeleteObj.setDeletedValue(fieldMetadata.getSoftDeleteInactiveValue());
                } else if (fieldMetadata.getSoftDeleteActiveValue() != null) {
                    softDeleteObj.setActiveValue(fieldMetadata.getSoftDeleteActiveValue());
                } else if ("boolean".equals(fieldMetadata.getDatatype())) {
                    softDeleteObj.setDeletedValue(String.valueOf(fieldMetadata.isSoftDeleteField()));
                }
                runtimeObject.setSoftDeleteFieldObj(softDeleteObj);
            } else if (fieldMetadata.isUpdateTimeStampField()) {
                DeltaContextFieldObject deltaCtxtObj = new DeltaContextFieldObject();
                deltaCtxtObj.setDeltaContextFieldName(field.getName());
                deltaCtxtObj.setDataType(fieldMetadata.getDatatype());
                if (fieldMetadata.getTimeStampFieldFormat() != null) {
                    deltaCtxtObj.setTimeStampFieldFormat(fieldMetadata.getTimeStampFieldFormat());
                }
                runtimeObject.setDeltaContextfieldObj(deltaCtxtObj);
            }
            fieldMetadataMap.put(field.getName(), fieldMetadata);
        }
        runtimeObject.setFieldMetadtaMap(fieldMetadataMap);
    }

    public static FieldMetadata getFieldMetadataFromField(Field field) {
        FieldMetadata fieldMetadta = new FieldMetadata();
        fieldMetadta.setName(field.getName());
        fieldMetadta.setDisplayName(field.getDisplayName());
        fieldMetadta.setDatatype(field.getDatatype());
        for (Fieldparam fieldParam : field.getFieldParam()) {
            FieldparamEnum fieldparamEnum = FieldparamEnum.getFiledParamByValue(fieldParam.getName());
            if (fieldparamEnum == null) continue;
            switch (fieldparamEnum) {
                case auditColumn: {
                    fieldMetadta.setAuditColumn(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case hasIndex: {
                    fieldMetadta.setHasIndex(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case hasTranslation: {
                    fieldMetadta.setHasTranslation(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case customizable: {
                    fieldMetadta.setCustomizable(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case description: {
                    fieldMetadta.setDescription(fieldParam.getValue());
                    break;
                }
                case sourceFieldName: {
                    fieldMetadta.setSourceFieldName(fieldParam.getValue());
                    break;
                }
                case autoGenerated: {
                    fieldMetadta.setAutoGenerated(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case sourceDatatype: {
                    fieldMetadta.setSourceDatatype(fieldParam.getValue());
                    break;
                }
                case nullable: {
                    fieldMetadta.setNullable(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case creatable: {
                    fieldMetadta.setCreatable(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case fieldlength: {
                    fieldMetadta.setLength(Integer.parseInt(fieldParam.getValue()));
                    break;
                }
                case table: {
                    fieldMetadta.setTable(fieldParam.getValue());
                    break;
                }
                case isSoftDeleteField: {
                    fieldMetadta.setSoftDeleteField(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case softDeleteInactiveValue: {
                    fieldMetadta.setSoftDeleteInactiveValue(fieldParam.getValue());
                    break;
                }
                case softDeleteActiveValue: {
                    fieldMetadta.setSoftDeleteActiveValue(fieldParam.getValue());
                    break;
                }
                case isUpdateTimeStampField: {
                    fieldMetadta.setUpdateTimeStampField(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
                case timeStampFieldFormat: {
                    fieldMetadta.setTimeStampFieldFormat(fieldParam.getValue());
                    break;
                }
                case updateable: {
                    fieldMetadta.setUpdateable(Boolean.valueOf(fieldParam.getValue()));
                    break;
                }
            }
        }
        return fieldMetadta;
    }

    private static void setServiceMetadataPerApp(Application application, ApplicationMetadata appMetadata, String envGuid) {
        ResourceIdentifierBuilder resourceIdentifierBuilder = appMetadata.getAppCache().getFrontendResourceIdentifier().getResourceIdentifierBuilder();
        resourceIdentifierBuilder.remove(appMetadata.getApplicationVersion());
        Services services = application.getServices();
        for (Service service : services.getService()) {
            ServiceMetadata servMeta = new ServiceMetadata(appMetadata, service);
            ArrayList configParams = service.getServiceConfig().getServiceConfig();
            service.getCustomObjMap().put("serviceMetadataKey", servMeta);
            for (ConfigParam configParam : configParams) {
                servMeta.getServiceConfigParamMap().put(configParam.getName(), configParam.getValue());
            }
            if (appMetadata instanceof StorageApplicationMetadata) {
                ApplicationHelper.populateStorageContextConfiguration(servMeta.getServiceConfigParamMap(), application.getId(), envGuid);
            }
            String frontendUrl = servMeta.getServiceConfigParamByParamName("frontend_url");
            String frontendUrlVerb = servMeta.getServiceConfigParamByParamName("frontend_supported_method");
            if (StringUtils.isNotBlank((String)frontendUrl) && StringUtils.isNotBlank((String)frontendUrlVerb)) {
                resourceIdentifierBuilder.add(appMetadata.getApplicationVersion(), servMeta.getService().getId(), frontendUrlVerb, frontendUrl);
            }
            appMetadata.addServiceMetadata(service.getId(), servMeta);
            appMetadata.populateThrottlingInfo(configParams);
        }
    }

    public static void populateStorageContextConfiguration(Map<String, Object> config, String appId, String envGuid) {
        LOGGER.debug((Object)"Populating RDBMS context configuration");
        StorageDatabaseDetails storageDatabaseDetails = ApplicationHelper.getStorageDatabaseDetails(appId, envGuid);
        config.put("jdbcClass".toString(), storageDatabaseDetails.getDriverClass());
        config.put("jdbcUrl".toString(), storageDatabaseDetails.getJdbcURL());
        config.put("userId".toString(), storageDatabaseDetails.getUsername());
        config.put("password", storageDatabaseDetails.getPassword());
        config.put("maxPoolSize", storageDatabaseDetails.getMaxConnections());
        config.put("connectionTimeout", storageDatabaseDetails.getConnectionTimeout());
        config.put("adaptertype", DataAdapterFactory.DataAdapterType.CUSTOM.toString());
        config.put("basepackage".toString(), "com.kony.rdbms");
    }

    private static StorageDatabaseDetails getStorageDatabaseDetails(String appId, String envGuid) {
        DatabaseHelper databaseHelper = DatabaseHelperFactory.createDatabaseHelper();
        StorageDatabaseDetails storageDatabaseDetails = databaseHelper.getStorageDatabaseDetails();
        String databaseName = databaseHelper.getStorageDatabaseName(appId, envGuid);
        storageDatabaseDetails.setJdbcURL(databaseHelper.getJdbcUrlWithDatabaseName(databaseName));
        return storageDatabaseDetails;
    }

    public static List<TreeNode<String>> prepareNodeList(List<ObjectSource> objectSrcList) {
        ArrayList<TreeNode<String>> treeNodeList = new ArrayList<TreeNode<String>>();
        for (ObjectSource objectSrc : objectSrcList) {
            treeNodeList.add(ApplicationHelper.prepareNodeTree(objectSrc));
        }
        return treeNodeList;
    }

    private static TreeNode<String> prepareNodeTree(ObjectSource objectSource) {
        ExpandTreeNode objNode = new ExpandTreeNode((Object)objectSource.getSourceObject());
        List objectSrcList = objectSource.getObjectSource();
        for (ObjectSource objectSrc : objectSrcList) {
            objNode.addChildNode(ApplicationHelper.prepareNodeTree(objectSrc));
        }
        return objNode;
    }

    private ApplicationHelper() {
    }
}

