/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.registry.impl;

import com.kony.adapter.criteria.TreeNode;
import com.kony.mapper.registry.vo.Functions;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.ParentChildType;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Objectgroup;
import com.konylabs.middleware.registry.vo.Operationmapping;
import com.konylabs.middleware.throttle.MWThrottle;
import com.konylabs.middleware.throttle.ThrottleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApplicationMetadata {
    private final AppCache appCache;
    private AppVersion applicationVersion;
    private final Map<String, Map<String, String>> objFieldMap;
    private final Map<String, Map<String, Operationmapping>> operatonMapingsMap;
    private final Map<String, List<TreeNode<String>>> objectSourceMap;
    private final Map<String, ObjectMetadata> objectMap;
    private final List<String> objectNames;
    private Map<String, ConfigParam> configParamMap;
    private Functions functions;
    private final Map<String, Objectgroup> objectGroupMap;
    private final Map<String, Map<String, Object>> assetMap;
    private final Map<String, ServiceMetadata> serviceMetadataMap;
    private final Map<String, String> appConfig;
    private final Map<String, List<ParentChildType>> parentChildListByChildObjectname;
    private final MWThrottle totalLimitThrottle = new MWThrottle("totalRateLimit", true, "Total Rate Limit has been exceeded for service {0} at {1}. Please contact your administrator for more details.");
    private final MWThrottle ipLimitThrottle = new MWThrottle("rateLimitPerIP", false, "Rate Limit per IP has been exceeded by the address {0} at {1}. Please contact your administrator for more details.");
    private String jarModuleName;

    public ApplicationMetadata(AppCache appCache) {
        this.appCache = appCache;
        this.objFieldMap = new HashMap<String, Map<String, String>>();
        this.objectSourceMap = new HashMap<String, List<TreeNode<String>>>();
        this.functions = new Functions();
        this.operatonMapingsMap = new HashMap<String, Map<String, Operationmapping>>();
        this.objectMap = new LinkedHashMap<String, ObjectMetadata>();
        this.objectNames = new ArrayList<String>();
        this.objectGroupMap = new HashMap<String, Objectgroup>();
        this.assetMap = new HashMap<String, Map<String, Object>>();
        this.serviceMetadataMap = new HashMap<String, ServiceMetadata>();
        this.appConfig = new HashMap<String, String>();
        this.parentChildListByChildObjectname = new HashMap<String, List<ParentChildType>>();
    }

    public AppCache getAppCache() {
        return this.appCache;
    }

    public Map<String, Map<String, String>> getObjFieldMap() {
        return this.objFieldMap;
    }

    public Map<String, String> getFieldMapByObjId(String objectId) {
        return this.objFieldMap.get(objectId);
    }

    public List<TreeNode<String>> getObjectSourceNodeListByObjectId(String objectId) {
        return this.objectSourceMap.get(objectId);
    }

    public Map<String, List<TreeNode<String>>> getObjectSourceMap() {
        return this.objectSourceMap;
    }

    public Functions getFunctions() {
        return this.functions;
    }

    public void setFunctions(Functions functions) {
        this.functions = functions;
    }

    public Map<String, ConfigParam> getConfigParamMap() {
        return this.configParamMap;
    }

    public void setConfigParamMap(Map<String, ConfigParam> configParamList) {
        this.configParamMap = configParamList;
    }

    public ConfigParam getConfigParamByParamName(String paramName) {
        return this.getConfigParamMap().get(paramName);
    }

    public Map<String, Map<String, Operationmapping>> getOperatonMapingsMap() {
        return this.operatonMapingsMap;
    }

    public Map<String, Operationmapping> getOperatonMapingByObjectId(String objectId) {
        return this.operatonMapingsMap.get(objectId);
    }

    public ObjectMetadata getObjectMetadata(String objectName) {
        return this.objectMap.get(objectName);
    }

    public AppVersion getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(AppVersion applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public Map<String, Map<String, Object>> getAssetMap() {
        return this.assetMap;
    }

    public void putAsset(String assetType, String assetName, Object assetValue) {
        if (this.assetMap.get(assetType) != null) {
            this.assetMap.get(assetType).put(assetName, assetValue);
        } else {
            HashMap<String, Object> assetNameValueMap = new HashMap<String, Object>();
            assetNameValueMap.put(assetName, assetValue);
            this.assetMap.put(assetType, assetNameValueMap);
        }
    }

    public Object getAssetByName(String assetType, String assetName) {
        return this.assetMap.get(assetType) != null ? this.assetMap.get(assetType).get(assetName) : null;
    }

    public Map<String, Objectgroup> getObjectGroupMap() {
        return this.objectGroupMap;
    }

    public ServiceMetadata getServiceMetadata(String serviceId) {
        return this.serviceMetadataMap.get(serviceId);
    }

    public Set<String> getServiceNames() {
        return this.serviceMetadataMap.keySet();
    }

    public List<String> getObjectNames() {
        return this.objectNames;
    }

    Map<String, ObjectMetadata> getObjectMap() {
        return this.objectMap;
    }

    public void addServiceMetadata(String serviceId, ServiceMetadata serviceMetadata) {
        this.serviceMetadataMap.put(serviceId, serviceMetadata);
    }

    Map<String, ServiceMetadata> getServiceMetadataMap() {
        return this.serviceMetadataMap;
    }

    public Map<String, List<ParentChildType>> getParentChildListByChildObjectname() {
        return this.parentChildListByChildObjectname;
    }

    public MWThrottle getTotalLimitThrottle() {
        return this.totalLimitThrottle;
    }

    public MWThrottle getIpLimitThrottle() {
        return this.ipLimitThrottle;
    }

    public void populateAppConfig(Map<String, String> newAppConfig) {
        this.appConfig.clear();
        if (newAppConfig != null) {
            this.appConfig.putAll(newAppConfig);
        }
        this.totalLimitThrottle.updateRuntimeLimit(this.appConfig);
        this.ipLimitThrottle.updateRuntimeLimit(this.appConfig);
    }

    public void populateThrottlingInfo(List<ConfigParam> configParams) {
        Map<String, String> throttlingInfo = ThrottleUtil.getMapFromConfig(configParams);
        this.totalLimitThrottle.updateDesignTimeLimit(throttlingInfo);
        this.ipLimitThrottle.updateDesignTimeLimit(throttlingInfo);
    }

    public String getJarModuleName() {
        return this.jarModuleName;
    }

    public void setJarModuleName(String jarModuleName) {
        this.jarModuleName = jarModuleName;
    }
}

