/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.registry.impl;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.cache.IKonyCache;
import com.konylabs.middleware.factory.KonyAppFactory;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.IRegistryManager;
import com.konylabs.middleware.registry.impl.ApplicationHelper;
import com.konylabs.middleware.registry.vo.Application;
import com.konylabs.middleware.registry.vo.Service;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class KonyAbstractRegistryManager
implements IRegistryManager {
    private static final Logger LOGGER = Logger.getLogger(KonyAbstractRegistryManager.class);

    @Override
    public Application buildApplication(InputStream fileStream) throws AppRegistryException {
        LOGGER.debug((Object)"inside buildApplication(InputStream fileStream)");
        try {
            return ApplicationHelper.buildApplication(fileStream);
        }
        catch (Exception e) {
            String errorCode = "14023";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage, (Throwable)e);
            throw new AppRegistryException(errorCode, errorMessage, 500);
        }
    }

    @Override
    public List<String> getAppIdList() throws Exception {
        ArrayList<String> listOfAppId = new ArrayList<String>();
        Hashtable<String, String> appMap = this.getAllAppsFromRegistry();
        if (appMap != null) {
            listOfAppId = new ArrayList(appMap.keySet());
        }
        return listOfAppId;
    }

    @Override
    @Deprecated
    public Service getService(AppVersion appVersion, String serviceId) throws AppRegistryException {
        String errorMessage;
        String errorCode;
        IKonyCache cache = KonyAppFactory.getKonyCacheInstance();
        Object app = cache.get(appVersion);
        Application application = app != null && app instanceof Application ? (Application)app : this.buildApplication(appVersion);
        Service serviceObj = null;
        ArrayList listOfServices = new ArrayList();
        if (application != null && application.getServices() != null && (listOfServices = application.getServices().getService()).size() > 0) {
            for (Service service : listOfServices) {
                if (!serviceId.equalsIgnoreCase(service.getId())) continue;
                serviceObj = service;
                break;
            }
        }
        if (application == null) {
            errorCode = "10101";
            errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage);
            throw new AppRegistryException(errorCode, errorMessage);
        }
        if (serviceObj == null) {
            errorCode = "10102";
            errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            errorMessage = MessageFormat.format(errorMessage, serviceId);
            LOGGER.error((Object)errorMessage);
            throw new AppRegistryException(errorCode, errorMessage);
        }
        return serviceObj;
    }
}

