/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.registry.impl;

import com.kony.mapper.javascript.JavaScriptEngineWrapperFactory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.api.processor.impl.ProcessorInfo;
import com.konylabs.middleware.cache.IKonyCache;
import com.konylabs.middleware.processors.ServiceProcessorInfo;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.Cacheable;
import com.konylabs.middleware.registry.impl.AbstractAppCache;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class KonyAppCache
extends AbstractAppCache
implements IKonyCache,
AppCache {
    private static final Logger LOGGER = Logger.getLogger(KonyAppCache.class);
    private static AppCache instance;
    private final HashMap<String, Object> genericCache = new HashMap();
    private final HashMap<Object, Object> appCache = new HashMap();
    private final HashMap<Object, Object> appConfigCache = new HashMap();
    private final Map<AppVersion, ApplicationMetadata> appMetadataCache = new HashMap<AppVersion, ApplicationMetadata>();
    private final Map<AppVersion, ServiceProcessorInfo> prePostProcessorsMetadata = new HashMap<AppVersion, ServiceProcessorInfo>();

    public KonyAppCache() {
        super(JavaScriptEngineWrapperFactory.getCoreJavaScriptEngineWrapper());
    }

    @Deprecated
    public static AppCache getInstance() {
        return instance;
    }

    @Deprecated
    public static void setInstance(Cacheable appCache) {
        instance = (AppCache)appCache;
    }

    @Override
    public void put(Object key, Object object, int duration) {
        this.appCache.put(key, object);
    }

    @Override
    public void put(Object key, Object appData) {
        this.appCache.put(key, appData);
    }

    @Override
    public Object getItem(String key) {
        return this.genericCache.get(key);
    }

    @Override
    public void putItem(String key, Object Object2, int duration) {
        this.genericCache.put(key, Object2);
    }

    @Override
    public void putItem(String key, Object Object2) {
        this.genericCache.put(key, Object2);
    }

    @Override
    public Object get(Object key) {
        return this.appCache.get(key);
    }

    public Set getAllApps() {
        return new HashSet<Object>(this.appCache.values());
    }

    public Set<AppVersion> getAllKeys() {
        Set<AppVersion> keyset = this.appMetadataCache.keySet();
        return keyset;
    }

    @Override
    public boolean remove(Object key) {
        LOGGER.debug((Object)("In remove method : " + key));
        this.appCache.remove(key);
        this.appConfigCache.remove(key);
        this.appMetadataCache.remove(key);
        return !this.appCache.containsKey(key);
    }

    public void addAppConfig(Object appId, Object appConfig) {
        if (this.appCache.containsKey(appId)) {
            this.appConfigCache.put(appId, appConfig);
        }
    }

    public Object getAppConfig(Object appId) {
        return this.appConfigCache.get(appId);
    }

    @Override
    public void shutdown() {
        LOGGER.debug((Object)"In shutdown method...");
        this.appCache.clear();
        this.appConfigCache.clear();
        this.appMetadataCache.clear();
        this.genericCache.clear();
    }

    public ApplicationMetadata getAppMetadata(AppVersion appVersion) {
        LOGGER.debug((Object)"In getAppMetadata(AppVersion appVersion)");
        return this.appMetadataCache.get(appVersion);
    }

    @Override
    public void addAppMetadata(AppVersion appVersion, ApplicationMetadata appMetadata) {
        super.addAppMetadata(appVersion, appMetadata);
        LOGGER.debug((Object)"in addAppMetadata(AppVersion appVersion, ApplicationMetadata appMetadata)");
        this.appMetadataCache.put(appVersion, appMetadata);
    }

    @Override
    public void remove(AppVersion appVersion) {
        super.remove(appVersion);
        LOGGER.debug((Object)("Removing appVersion " + appVersion + " from appCache"));
        this.appCache.remove(appVersion);
        this.appConfigCache.remove(appVersion);
        this.appMetadataCache.remove(appVersion);
    }

    @Override
    public void addProcessorMetadata(AppVersion appVersion, ServiceProcessorInfo metadata) {
        this.prePostProcessorsMetadata.put(appVersion, metadata);
    }

    @Override
    public ProcessorInfo getProcessorMetadata(AppVersion appVersion, String objectIdVerb) {
        ServiceProcessorInfo serviceProcessorInfo = this.prePostProcessorsMetadata.get(appVersion);
        return serviceProcessorInfo != null ? serviceProcessorInfo.getProcessorInfo(objectIdVerb) : null;
    }

    @Override
    public void removeProcessorMetadata(AppVersion appVersion) {
        this.prePostProcessorsMetadata.remove(appVersion);
    }

    @Override
    protected String getHighestVersion(String appId) {
        return null;
    }
}

