/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.registry.impl;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.cache.IKonyCache;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.IKonyAppRegistryRead;
import com.konylabs.middleware.registry.IKonyAppRegistryWrite;
import com.konylabs.middleware.registry.IRegistryManager;
import com.konylabs.middleware.registry.vo.Application;
import com.konylabs.middleware.registry.vo.Service;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;

@Deprecated
public class KonyApplicationRegistry
implements IKonyAppRegistryRead,
IKonyAppRegistryWrite {
    private static final Logger LOGGER = Logger.getLogger(KonyApplicationRegistry.class);
    private IRegistryManager registryManager = null;

    private KonyApplicationRegistry(IRegistryManager registryManager) {
        this.registryManager = registryManager;
    }

    public static synchronized KonyApplicationRegistry getInstance() {
        IRegistryManager iRegistry = EnvironmentFactory.getEnvironment().getRegistryManager();
        return new KonyApplicationRegistry(iRegistry);
    }

    @Override
    public Hashtable<String, String> getAllApplications() throws AppRegistryException {
        Hashtable<String, String> appTable = null;
        try {
            appTable = this.getRegistryManager().getAllAppsFromRegistry();
        }
        catch (Exception e) {
            String errorCode = "14022";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage, (Throwable)e);
            throw new AppRegistryException(errorCode, errorMessage, 500);
        }
        return appTable;
    }

    @Override
    public synchronized Application getApplication(InputStream fileStream) throws AppRegistryException {
        if (fileStream == null) {
            LOGGER.debug((Object)"Input File stream is null");
            return null;
        }
        Application returnApp = null;
        returnApp = this.registryManager.buildApplication(fileStream);
        return returnApp;
    }

    @Override
    public synchronized Application addApplication(String appID, InputStream xmlFile) throws AppRegistryException {
        Application returnApp = null;
        returnApp = this.getRegistryManager().buildApplication(xmlFile);
        if (returnApp != null) {
            returnApp = this.addApplication(appID, returnApp);
        }
        return returnApp;
    }

    @Override
    @Deprecated
    public synchronized Application addApplication(String appID, Application returnApp) throws AppRegistryException {
        LOGGER.debug((Object)("Adding/Updating the application : " + appID));
        try {
            String appXML = this.getAppXML(returnApp);
            if (appXML.length() > 0) {
                this.getRegistryManager().addApplication(appID, appXML.getBytes());
            }
        }
        catch (Exception e) {
            String errorCode = "14020";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage, (Throwable)e);
            throw new AppRegistryException(errorCode, errorMessage, 500);
        }
        return returnApp;
    }

    @Override
    public synchronized Application updateApplication(String appID, String smsID, InputStream xmlFile) throws AppRegistryException {
        Application application = null;
        application = this.getRegistryManager().buildApplication(xmlFile);
        if (application != null) {
            application = this.updateApplication(appID, smsID, application);
        }
        return application;
    }

    @Override
    @Deprecated
    public synchronized Application updateApplication(String appID, String smsID, Application application) throws AppRegistryException {
        LOGGER.debug((Object)("Updating the application : " + appID));
        try {
            this.getRegistryManager().deleteApplication(appID);
            String appXML = this.getAppXML(application);
            this.getRegistryManager().addApplication(appID, appXML.getBytes());
        }
        catch (Exception e) {
            String errorCode = "14021";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage, (Throwable)e);
            throw new AppRegistryException(errorCode, errorMessage, 500);
        }
        return application;
    }

    @Override
    public synchronized boolean deleteApplication(String appID) throws AppRegistryException {
        return this.deleteApplication(appID, null);
    }

    @Override
    @Deprecated
    public synchronized boolean deleteApplication(String appID, String smsID) throws AppRegistryException {
        boolean status = false;
        LOGGER.debug((Object)("Deleting the application : " + appID));
        try {
            status = this.getRegistryManager().deleteApplication(appID);
        }
        catch (Exception e) {
            String errorCode = "14024";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage, (Throwable)e);
            throw new AppRegistryException(errorCode, errorMessage, 500);
        }
        return status;
    }

    @Override
    @Deprecated
    public Application getApplication(String appID) throws AppRegistryException {
        return this.getApplication(new AppVersion(appID, "1.0"));
    }

    @Override
    @Deprecated
    public Application getApplication(AppVersion appVersion) throws AppRegistryException {
        return null;
    }

    public String getAppXML(Application application) throws JAXBException {
        String appXMLStr = null;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Application.class});
        Marshaller marshaller = context.createMarshaller();
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)application, (Writer)writer);
        appXMLStr = writer.toString();
        return appXMLStr;
    }

    @Override
    public void addProps(String fileName, String filePath) throws AppRegistryException {
        LOGGER.debug((Object)"********* addSAPProps()method executing ************");
        this.getRegistryManager().storeProps(fileName, filePath);
    }

    @Override
    public Service getService(AppVersion appID, String serviceId) throws AppRegistryException {
        return this.getRegistryManager().getService(appID, serviceId);
    }

    @Override
    @Deprecated
    public Application buildApplication(String appId) throws AppRegistryException {
        Application returnApp = null;
        returnApp = this.getRegistryManager().buildApplication(appId);
        return returnApp;
    }

    @Override
    public List<String> getAppIdList() throws AppRegistryException {
        try {
            return this.getRegistryManager().getAppIdList();
        }
        catch (Exception e) {
            String errorCode = "14022";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage, (Throwable)e);
            throw new AppRegistryException(errorCode, errorMessage, 500);
        }
    }

    @Override
    public void loadAllApplicationsToCache(IKonyCache appCache) throws AppRegistryException {
        Map<AppVersion, Application> allApps = null;
        try {
            allApps = this.getRegistryManager().getApplicationsFromRegistry();
            for (AppVersion appVersion : allApps.keySet()) {
                appCache.put(appVersion, allApps.get(appVersion));
            }
        }
        catch (Exception e) {
            String errorCode = "14022";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage, (Throwable)e);
            throw new AppRegistryException(errorCode, errorMessage, 500);
        }
    }

    public IRegistryManager getRegistryManager() {
        return this.registryManager;
    }

    @Override
    public Map<AppVersion, Application> getApplicationsFromRegistry() throws Exception {
        return this.getRegistryManager().getApplicationsFromRegistry();
    }

    @Override
    public Application buildApplication(AppVersion appVersion) throws AppRegistryException {
        return this.getRegistryManager().buildApplication(appVersion);
    }

    @Override
    public List<AppVersion> getAppVersions(String appId) throws AppRegistryException {
        return this.getRegistryManager().getAppVersions(appId);
    }
}

