/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.registry.impl;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.KonyAbstractRegistryManager;
import com.konylabs.middleware.registry.impl.XMLFilter;
import com.konylabs.middleware.registry.vo.Application;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KonyFileRegistryManager
extends KonyAbstractRegistryManager {
    private static final Logger LOGGER = Logger.getLogger(KonyFileRegistryManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplication(String appId, byte[] appendBuf) throws Exception {
        String filePath = this.getAppRegistryDir() + "/" + appId + ".xml";
        LOGGER.debug((Object)("Application File:" + filePath));
        File appFile = null;
        FileOutputStream fos = null;
        try {
            if (!MiddlewareUtils.isFilePathValid(appId)) {
                LOGGER.error((Object)("Invalid file name " + filePath));
                throw new AppRegistryException("14023", "Path manipulation - file name contains malicious text " + filePath);
            }
            this.createParentFoldersIfNotExist(filePath);
            appFile = new File(filePath);
            this.moveToTempFolder(appId, appFile);
            fos = new FileOutputStream(appFile);
            fos.write(appendBuf);
            fos.flush();
            LOGGER.debug((Object)"Adding Application File is successful");
        }
        catch (Throwable throwable) {
            Closer.closeQuietly(fos);
            throw throwable;
        }
        Closer.closeQuietly((Closeable)fos);
    }

    @Override
    public void createParentFoldersIfNotExist(String fileName) throws Exception {
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            LOGGER.debug((Object)("Creating the Parent Folders.." + parent.getName()));
            parent.mkdirs();
        }
    }

    @Override
    public Hashtable<String, String> getAllAppsFromRegistry() throws Exception {
        Hashtable<String, String> allApps = new Hashtable<String, String>();
        String fileExtension = null;
        File appFolder = new File(this.getAppRegistryDir());
        String[] fileNames = null;
        fileNames = appFolder.list(new XMLFilter());
        if (fileNames != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                Application application;
                if (!StringUtils.isNotBlank((String)fileNames[i]) || (application = this.loadApplication(fileNames[i], fileExtension)) == null) continue;
                allApps.put(application.getId(), application.getName());
                LOGGER.debug((Object)("Application ID:" + application.getId() + " Name:" + application.getName()));
            }
        } else {
            LOGGER.debug((Object)"There are no Apps in the registry");
        }
        return allApps;
    }

    private String getAppRegistryDir() throws AppRegistryException {
        String appRegistryDir = ConfigPathUtil.getAppRegistryDirPath();
        LOGGER.debug((Object)("Application Registry Directory is " + appRegistryDir));
        if (!MiddlewareUtils.isDirPathValid(appRegistryDir)) {
            LOGGER.error((Object)("Invalid folder name " + appRegistryDir));
            throw new AppRegistryException("14023", "Path manipulation - folder name contains malicious text " + appRegistryDir);
        }
        File file = new File(appRegistryDir);
        if (!file.exists()) {
            String errorCode = "14004";
            String errMsg = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errMsg);
            throw new AppRegistryException(errorCode, errMsg);
        }
        return appRegistryDir.replace("\\", "/");
    }

    @Override
    public Application buildApplication(String appId) throws AppRegistryException {
        return this.loadApplication(appId, ".xml");
    }

    private Application loadApplication(String appId, String fileExtension) throws AppRegistryException {
        Application app = null;
        FileInputStream fis = null;
        String filePath = this.getAppRegistryDir() + "/" + appId;
        if (StringUtils.isNotBlank((String)fileExtension)) {
            filePath = filePath + fileExtension;
        }
        try {
            if (!MiddlewareUtils.isFilePathValid(appId)) {
                LOGGER.error((Object)("Invalid file name " + filePath));
                throw new AppRegistryException("14023", "Path manipulation - file name contains malicious text " + filePath);
            }
            File appFile = new File(filePath);
            if (appFile.exists() && appFile.isFile()) {
                fis = new FileInputStream(appFile);
                app = this.buildApplication(fis);
            }
        }
        catch (IOException e) {
            String errorCode = "14023";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage, (Throwable)e);
            throw new AppRegistryException(errorCode, errorMessage, 500);
        }
        finally {
            Closer.closeQuietly(fis);
        }
        return app;
    }

    public void moveToTempFolder(String appId, File appFile) throws AppRegistryException {
        String rootPath = this.getAppRegistryDir();
        if (appFile.exists()) {
            File backUpFolder = new File(rootPath, "backup");
            boolean success = backUpFolder.exists();
            if (!success) {
                success = backUpFolder.mkdirs();
            }
            if (success) {
                StringBuffer pathName = new StringBuffer();
                pathName.append(backUpFolder.getAbsolutePath()).append("/").append(appId).append("_").append(System.currentTimeMillis()).append(".xml");
                String destPathName = pathName.toString();
                LOGGER.debug((Object)("Back up file name " + destPathName));
                File destFile = new File(destPathName);
                try {
                    FileUtils.copyFile((File)appFile, (File)destFile);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Back up file is unsuccessful ", (Throwable)e);
                }
                boolean isRenameSuccess = destFile.exists();
                if (!isRenameSuccess) {
                    LOGGER.debug((Object)"Back up file is unsuccessful ");
                }
            }
        }
    }

    @Override
    public boolean deleteApplication(String appId) throws Exception {
        boolean status = false;
        String filePath = this.getAppRegistryDir() + "/" + appId + ".xml";
        LOGGER.debug((Object)("Application File:" + filePath));
        if (!MiddlewareUtils.isFilePathValid(appId)) {
            LOGGER.error((Object)("Invalid file name " + filePath));
            throw new AppRegistryException("14023", "Path manipulation - file name contains malicious text " + filePath);
        }
        File appFile = new File(filePath);
        this.moveToTempFolder(appId, appFile);
        status = FileUtils.deleteQuietly((File)appFile);
        if (!status) {
            status = appFile.exists();
        }
        LOGGER.debug((Object)("file deletion status is  " + status));
        LOGGER.debug((Object)("Deletion of " + filePath + " is successful"));
        return status;
    }

    @Override
    public void storeProps(String fileName, String filePath) throws AppRegistryException {
        LOGGER.debug((Object)"***********storeProps method executing ******************** ");
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            File srcFile = new File(filePath);
            File destFile = new File(this.getAppRegistryDir() + "/" + fileName);
            LOGGER.debug((Object)("======== file name ==========> " + destFile.getName()));
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
                out.flush();
            }
            LOGGER.debug((Object)"****************** File copied.********************");
        }
        catch (IOException ex) {
            try {
                LOGGER.error((Object)(ex.getMessage() + " in the specified directory."), (Throwable)ex);
                String errorCode = "14003";
                String message = AppRegistryException.getErrorMessage((String)errorCode);
                throw new AppRegistryException(errorCode, message);
            }
            catch (Throwable throwable) {
                Closer.closeQuietly(in);
                Closer.closeQuietly(out);
                throw throwable;
            }
        }
        Closer.closeQuietly((Closeable)in);
        Closer.closeQuietly((Closeable)out);
    }

    @Override
    public Map<AppVersion, Application> getApplicationsFromRegistry() throws Exception {
        HashMap<AppVersion, Application> allApps = new HashMap<AppVersion, Application>();
        String fileExtension = null;
        File appFolder = new File(this.getAppRegistryDir());
        String[] fileNames = null;
        fileNames = appFolder.list(new XMLFilter());
        if (fileNames != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                Application application;
                if (!StringUtils.isNotBlank((String)fileNames[i]) || (application = this.loadApplication(fileNames[i], fileExtension)) == null) continue;
                allApps.put(new AppVersion(application.getId(), "1.0"), application);
                LOGGER.debug((Object)("Application ID:" + application.getId() + " Name:" + application.getName()));
            }
        } else {
            LOGGER.debug((Object)"There are no Apps in the registry");
        }
        return allApps;
    }

    @Override
    public Application buildApplication(AppVersion appVersion) throws AppRegistryException {
        return this.loadApplication(appVersion.getAppId(), ".xml");
    }

    @Override
    public List<AppVersion> getAppVersions(String appId) throws AppRegistryException {
        LOGGER.debug((Object)"Not supported implimentation");
        throw new AppRegistryException("14046", "No Implementation");
    }
}

