/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.registry.impl;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.cloud.CloudUtils;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.KonyAbstractRegistryManager;
import com.konylabs.middleware.registry.vo.Application;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KonyS3RegistryManager
extends KonyAbstractRegistryManager {
    private static final Logger LOGGER = Logger.getLogger(KonyS3RegistryManager.class);

    @Override
    public void addApplication(String appId, byte[] appendBuf) throws Exception {
        LOGGER.debug((Object)"Not supported implimentation");
        throw new Exception("adding application to cloud is not supported");
    }

    @Override
    public void createParentFoldersIfNotExist(String parentPath) throws Exception {
        LOGGER.debug((Object)"Not supported implimentation");
        throw new Exception("adding application to cloud is not supported");
    }

    @Override
    public Hashtable<String, String> getAllAppsFromRegistry() throws Exception {
        Hashtable<String, String> allApps = new Hashtable<String, String>();
        String fileExtension = ".xml";
        String prefix = null;
        String marker = null;
        List<String> appsNameList = CloudUtils.getFoldersList(CloudUtils.getS3BucketName(), prefix, marker);
        if (appsNameList.size() > 0) {
            for (String appId : appsNameList) {
                Application application;
                if (!StringUtils.isNotBlank((String)appId) || "JAVASCRIPT_FOLDER".equals(appId) || (application = this.loadApplication(appId, appId, fileExtension)) == null) continue;
                allApps.put(application.getId(), application.getName());
                LOGGER.debug((Object)("Application ID:" + application.getId() + " Name:" + application.getName()));
            }
        }
        return allApps;
    }

    private String getAppRegistryDir(String appId, boolean services) {
        StringBuilder appRegistryDir = new StringBuilder();
        if (StringUtils.isNotBlank((String)appId)) {
            appRegistryDir.append(appId);
        }
        if (services) {
            appRegistryDir.append("/").append("services");
        }
        LOGGER.debug((Object)("Application Root Directory " + appRegistryDir.toString()));
        return appRegistryDir.toString();
    }

    @Override
    public Application buildApplication(String appId) throws AppRegistryException {
        LOGGER.debug((Object)"buildApplication(String appId)");
        return this.loadApplication(appId, appId, ".xml");
    }

    private Application loadApplication(String path, String appId, String fileExtension) throws AppRegistryException {
        InputStream inputStream;
        Application application;
        block5: {
            LOGGER.debug((Object)"inside loadApplication(String path, String appId, String fileExtension)");
            application = null;
            inputStream = null;
            try {
                String key = this.getAppRegistryDir(path, true) + "/" + appId + fileExtension;
                LOGGER.info((Object)("Loading application from S3 with path : " + key));
                inputStream = CloudUtils.getS3ObjectIfExist(CloudUtils.getS3BucketName(), key);
                if (inputStream != null) {
                    LOGGER.debug((Object)("Found s3Object for appId : " + appId));
                    application = this.buildApplication(inputStream);
                    break block5;
                }
                LOGGER.debug((Object)("s3Object not found for appId : " + appId));
            }
            catch (Exception e) {
                try {
                    String errorCode = "14023";
                    String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
                    LOGGER.error((Object)errorMessage);
                    throw new AppRegistryException(errorCode, errorMessage, 500);
                }
                catch (Throwable throwable) {
                    Closer.closeQuietly(inputStream);
                    throw throwable;
                }
            }
        }
        Closer.closeQuietly((Closeable)inputStream);
        return application;
    }

    @Override
    public boolean deleteApplication(String appId) throws Exception {
        LOGGER.debug((Object)"Not supported implimentation");
        throw new Exception("deleting application to cloud is not supported");
    }

    @Override
    public void storeProps(String fileName, String filePath) {
    }

    @Override
    public Map<AppVersion, Application> getApplicationsFromRegistry() throws Exception {
        HashMap<AppVersion, Application> allApps = new HashMap<AppVersion, Application>();
        String prefix = null;
        String marker = null;
        int startLength = 0;
        List<String> appsNameList = CloudUtils.getFoldersList(CloudUtils.getS3BucketName(), prefix, marker);
        ArrayList<String> appsWithVersion = new ArrayList<String>();
        for (String app : appsNameList) {
            appsWithVersion.addAll(CloudUtils.getAppFolders(CloudUtils.getS3BucketName(), app + "/", marker));
        }
        for (String app : appsWithVersion) {
            if (app.indexOf("/V") <= 0) continue;
            appsNameList.add(app.substring(startLength, app.length() - 1));
        }
        if (appsNameList.size() > 0) {
            for (String appId : appsNameList) {
                Application application;
                if (!StringUtils.isNotBlank((String)appId) || "JAVASCRIPT_FOLDER".equals(appId) || (application = this.loadApplication(appId, appId, ".xml")) == null) continue;
                String api_version = application.getApiVersion();
                if (StringUtils.isBlank((String)api_version)) {
                    api_version = "1.0";
                }
                allApps.put(new AppVersion(application.getId(), api_version), application);
                LOGGER.debug((Object)("Application ID:" + application.getId() + " Name:" + application.getName()));
            }
        }
        return allApps;
    }

    @Override
    public List<AppVersion> getAppVersions(String appId) throws AppRegistryException {
        ArrayList<AppVersion> appVersionList = new ArrayList<AppVersion>();
        List<String> appsVersionList = CloudUtils.getAppFolders(CloudUtils.getS3BucketName(), appId + "/", null);
        String appVersion = null;
        for (String version : appsVersionList) {
            String[] appVersionAry = version.split("/V");
            if (appVersionAry.length > 1) {
                appVersion = appVersionAry[1];
                appVersion = appVersion.substring(0, appVersion.length() - 1);
            } else {
                appVersion = "1.0";
            }
            appVersionList.add(new AppVersion(appId, appVersion));
        }
        return appVersionList;
    }

    @Override
    public Application buildApplication(AppVersion appVersion) throws AppRegistryException {
        LOGGER.debug((Object)"inside buildApplication(AppVersion appVersion)");
        String version = appVersion.getVersion();
        String path = appVersion.getAppId();
        if (!"1.0".equalsIgnoreCase(version)) {
            path = appVersion.getAppId() + "/V" + version;
        }
        return this.loadApplication(path, appVersion.getAppId(), ".xml");
    }
}

