/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request;

import com.kony.api.auth.common.Integrity;
import com.kony.api.gateway.Gateway;
import com.kony.api.gateway.GatewayException;
import com.kony.mobilefabric.exceptions.MobileFabricRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HttpIntegrityRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOGGER = Logger.getLogger(HttpIntegrityRequestWrapper.class);
    private final Gateway gateway;
    private final HttpServletRequest request;

    public HttpIntegrityRequestWrapper(HttpServletRequest request, Gateway gateway) throws IOException {
        super(request);
        this.request = request;
        this.gateway = gateway;
    }

    public ServletInputStream getInputStream() throws IOException {
        ServletInputStream requestBody = this.request.getInputStream();
        try {
            final Integrity integrity = this.checkRequestIntegrity((InputStream)requestBody);
            if (integrity.isIntegrityPassed()) {
                return new ServletInputStream(){

                    public int read() throws IOException {
                        return integrity.getInputStream().read();
                    }
                };
            }
        }
        catch (GatewayException e) {
            LOGGER.error((Object)"Exception occurred while validating the integrity", (Throwable)e);
            throw new MobileFabricRuntimeException("Exception occurred while validating the integrity", (Throwable)e);
        }
        return null;
    }

    private Integrity checkRequestIntegrity(InputStream requestBody) throws GatewayException {
        return this.gateway.checkRequestIntegrity(this.request.getHeader("X-Kony-Integrity"), requestBody, StringUtils.contains((String)this.request.getContentType(), (String)"multipart/form-data"));
    }
}

