/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.common.MWProperties;
import com.konylabs.middleware.request.builder.AbstractAbortPolicy;
import com.konylabs.middleware.request.builder.ObjectServiceResponseData;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowMetadata;
import com.konylabs.middleware.request.builder.RowUtil;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class AbortOnError
extends AbstractAbortPolicy {
    private static final Logger LOGGER = Logger.getLogger(AbortOnError.class);

    @Override
    public boolean canProcessRequest(ObjectServiceResponseData objectServiceResponseData, Row currentRow) {
        LOGGER.debug((Object)"Entered into canProcessRequest().");
        if (objectServiceResponseData.isAnyRecordFailed()) {
            RowMetadata metadata = objectServiceResponseData.getLastFailedrecord().getMetadata();
            JsonElement rowId = metadata.getRowId();
            String errorMessage = MessageFormat.format(MWProperties.getInstance().getErrorMessage("client_row_entity_abortonerorr_msg"), rowId);
            JsonObject responseJson = RowUtil.getFailedErrorJson(objectServiceResponseData, currentRow, errorMessage, 14052L);
            objectServiceResponseData.updateResponseRecordsAndIncrementFailureCount((JsonElement)responseJson, currentRow.getMetadata().getObjectName());
            return false;
        }
        return true;
    }

    @Override
    public void processFailedResponse(ObjectServiceResponseData objectServiceResponseData, Row requestRow) {
        LOGGER.debug((Object)"Entered into processFailedResponse().");
        objectServiceResponseData.setLastFailedRecord(requestRow);
        JsonObject responseJson = RowUtil.getFailedErrorJson(objectServiceResponseData, requestRow, requestRow.getMetadata().getErrMsg(), requestRow.getMetadata().getOpstatus());
        objectServiceResponseData.updateResponseRecordsAndIncrementFailureCount((JsonElement)responseJson, requestRow.getMetadata().getObjectName());
    }
}

