/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.dataaccess.exception.DataAccessException;
import com.konylabs.middleware.appservices.servlet.RowUploadHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.objservices.runtime.ConflictResolver;
import com.konylabs.middleware.request.builder.GetAfterConflictResolver;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowUtil;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class AbstractConflictResolver
implements ConflictResolver {
    private static final Logger LOGGER = Logger.getLogger(AbstractConflictResolver.class);

    protected Row resultRowOnDelete(Row requestRow, Row responseRow) throws DataAccessException {
        LOGGER.debug((Object)"Entered into resultRowOnDelete().");
        JsonObject deleteJson = new JsonObject();
        JsonObject keyJson = responseRow.getJsonElement().getAsJsonObject();
        Set<String> primaryKeysList = requestRow.getMetadata().getPrimaryKey().getPkValues().keySet();
        for (String key : primaryKeysList) {
            if (!keyJson.has(key)) continue;
            deleteJson.add(key, keyJson.get(key));
        }
        JsonObject metadataObject = new JsonObject();
        metadataObject.addProperty("action", OperationEnum.delete.toString());
        deleteJson.add("_metadata", (JsonElement)metadataObject);
        Row deleteResponseRow = RowUtil.createResponseRow(requestRow, deleteJson);
        deleteResponseRow.getMetadata().setOpstatus(0L);
        return deleteResponseRow;
    }

    @Override
    public void resolveClientCreateServerExists(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
    }

    @Override
    public void resolveClientUpdateServerUpdate(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
    }

    @Override
    public void resolveClientUpdateServerDelete(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
    }

    @Override
    public void resolveClientDeleteServerUpdate(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
    }

    @Override
    public void resolveClientDeleteServerDelete(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)"Entered into resolveClientDeleteServerNotExists().");
        HttpServletRequest httpServletRequest = inputPayloadMetadata.getHttpServletRequest();
        HttpServletResponse httpServletResponse = inputPayloadMetadata.getHttpServletResponse();
        GetAfterConflictResolver rowUploadHandler = (GetAfterConflictResolver)context.get("handler");
        Context parentContext = (Context)context.get("parentContext");
        try {
            if (isSoftDeleted) {
                this.getAsyncHandler(rowUploadHandler).onSuccess(httpServletRequest, httpServletResponse, this.resultRowOnDelete(requestRow, responseRow), parentContext);
            } else {
                this.getAsyncHandler(rowUploadHandler).onSuccess(httpServletRequest, httpServletResponse, this.resultRowOnDelete(requestRow, requestRow), parentContext);
            }
        }
        catch (Exception ex) {
            rowUploadHandler.onError(httpServletRequest, httpServletResponse, ex, parentContext);
        }
    }

    public RowUploadHandler getAsyncHandler(GetAfterConflictResolver handler) {
        return handler.getAsyncHandler();
    }
}

