/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.dataaccess.exception.DataAccessException;
import com.konylabs.middleware.appservices.common.helper.DataFoundationWSHelper;
import com.konylabs.middleware.appservices.servlet.RowUploadHandler;
import com.konylabs.middleware.common.MWProperties;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.objservices.metadata.ActionsDto;
import com.konylabs.middleware.objservices.metadata.SupportedObjectDto;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.request.PrimaryKey;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.OperationStrategy;
import com.konylabs.middleware.request.builder.OperationStrategyAsyncHandler;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowMetadata;
import com.konylabs.middleware.request.builder.RowUtil;
import com.konylabs.middleware.utilities.ResponseUtils;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class AbstractOperationStrategy
implements OperationStrategy {
    private static final Logger LOGGER = Logger.getLogger(AbstractOperationStrategy.class);
    private static final OperationStrategyAsyncHandler operationStrategyAsyncHandler = new OperationStrategyAsyncHandler();

    @Override
    public void beforeProcessing(Row inputRow, InputPayloadMetadata inputPayloadMetadata, ApplicationMetadata appMetadata) {
        JsonObject inputJson = inputRow.getJsonElement().getAsJsonObject();
        String objectName = inputRow.getMetadata().getObjectName();
        String action = inputRow.getMetadata().getAction();
        ObjectMetadata objectMetadata = inputRow.getMetadata().getObjectMetadata();
        PrimaryKey requestPrimeryKey = PrimaryKey.extractPK(objectMetadata.getPrimaryKeys(), inputJson);
        SupportedObjectDto supportedObjectDto = appMetadata.getObjectMetadata(objectName).getSupportedObjectHierarchy().get(action);
        RowUtil.updateChecksum(inputPayloadMetadata, inputRow, objectMetadata, requestPrimeryKey);
        this.processRequestRowHierarchy(inputJson, requestPrimeryKey, objectName, inputPayloadMetadata, appMetadata, supportedObjectDto);
    }

    private void processRequestRowHierarchy(JsonObject inputJson, PrimaryKey requestPrimeryKey, String objectName, InputPayloadMetadata inputPayloadMetadata, ApplicationMetadata appMetadata, SupportedObjectDto supportedObjectDto) {
        ObjectMetadata objectMetadata = appMetadata.getObjectMetadata(objectName);
        RowUtil.fetchAndUpdateInputPrimarykey(inputJson, inputPayloadMetadata, objectMetadata, requestPrimeryKey);
        RowUtil.fetchAndUpdateInputForeignkey(inputJson, inputPayloadMetadata, objectMetadata);
        if (supportedObjectDto != null) {
            List<ActionsDto> actionsDto = supportedObjectDto.getActions();
            for (ActionsDto actionDto : actionsDto) {
                List<SupportedObjectDto> supportedObjectDtoList = actionDto.getSupportedObjects();
                this.iterateOnChildRowsInRequest(inputJson, inputPayloadMetadata, appMetadata, supportedObjectDtoList);
            }
        }
    }

    protected void iterateOnChildRowsInRequest(JsonObject inputJson, InputPayloadMetadata inputPayloadMetadata, ApplicationMetadata appMetadata, List<SupportedObjectDto> supportedObjectDtoList) {
        for (SupportedObjectDto childSupportedObjectDto : supportedObjectDtoList) {
            String childObjectName = childSupportedObjectDto.getName();
            if (inputJson.get(childObjectName) == null) continue;
            JsonArray childJsonArray = inputJson.get(childObjectName).getAsJsonArray();
            Iterator childJsonIterator = childJsonArray.iterator();
            while (childJsonIterator.hasNext()) {
                JsonObject childJson = ((JsonElement)childJsonIterator.next()).getAsJsonObject();
                ObjectMetadata childObjectMetadata = appMetadata.getObjectMetadata(childObjectName);
                PrimaryKey requestPrimeryKey = PrimaryKey.extractPK(childObjectMetadata.getPrimaryKeys(), childJson);
                this.processRequestRowHierarchy(childJson, requestPrimeryKey, childObjectName, inputPayloadMetadata, appMetadata, childSupportedObjectDto);
            }
        }
    }

    protected String getObjectName(Row requestRow) {
        return requestRow.getMetadata().getObjectName();
    }

    protected Row createChildRequestRow(ObjectMetadata objectMetadata, JsonObject inputChildJson, Row parentRequestRow) {
        String action;
        String operationId;
        JsonObject metadataObj;
        Row childRequestRow = new Row(inputChildJson);
        PrimaryKey childPrimaryKey = PrimaryKey.extractPK(objectMetadata.getPrimaryKeys(), inputChildJson);
        RowMetadata childRowMetadata = new RowMetadata(objectMetadata, objectMetadata.getName());
        JsonObject jsonObject = metadataObj = inputChildJson.has("_metadata") ? inputChildJson.get("_metadata").getAsJsonObject() : new JsonObject();
        if (metadataObj.has("action")) {
            operationId = metadataObj.get("action").getAsString();
            action = OperationEnum.valueOf(operationId).name();
        } else {
            operationId = parentRequestRow.getMetadata().getOperationId();
            action = parentRequestRow.getMetadata().getAction();
        }
        if (metadataObj.has("rowId")) {
            childRowMetadata.setRowId(metadataObj.get("rowId"));
        }
        childRowMetadata.setAction(action);
        childRowMetadata.setOperationId(operationId);
        childRowMetadata.setPrimaryKey(childPrimaryKey);
        childRequestRow.setMetadata(childRowMetadata);
        return childRequestRow;
    }

    @Override
    public void process(Row inputRow, InputPayloadMetadata inputPayloadMetadata, Context parentContext) {
        LOGGER.debug((Object)"Entered into process().");
        DataControllerRequest dcr = DataFoundationWSHelper.createDcr(inputPayloadMetadata, inputRow);
        HttpServletResponse httpServletResponse = inputPayloadMetadata.getHttpServletResponse();
        HttpServletRequest httpServletRequest = inputPayloadMetadata.getHttpServletRequest();
        Context context = new Context();
        context.put("inputRow", (Object)inputRow);
        context.put("httpServletRequest", (Object)httpServletRequest);
        context.put("httpServletResponse", (Object)httpServletResponse);
        context.put("abstractOperationStrategy", (Object)this);
        context.put("parentContext", (Object)parentContext);
        context.put("handler", (Object)operationStrategyAsyncHandler);
        try {
            DataFoundationWSHelper.executeRequest(dcr, inputPayloadMetadata.getHttpServletResponse(), context);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Exception occurred while processing the request ", (Throwable)exception);
            ((RowUploadHandler)parentContext.get("handler")).onError(httpServletRequest, httpServletResponse, exception, parentContext);
        }
    }

    protected void processResponse(Row inputRow, Context parentContext, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, DataControllerRequest dataControllerRequest, DataControllerResponse dataControllerResponse) throws DataAccessException {
        ResponseUtils.addResponseHeaders((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Map)dataControllerResponse.getDeviceHeaders());
        Object result = dataControllerResponse.getAttribute("chunkedresults_json");
        JsonObject responseJsonObject = new JsonParser().parse(result.toString()).getAsJsonObject();
        RowUploadHandler rowUploadHandler = (RowUploadHandler)parentContext.get("handler");
        if (responseJsonObject.has("errmsg") || responseJsonObject.get("opstatus").getAsLong() != 0L) {
            RowMetadata metadata = inputRow.getMetadata();
            String errorMessage = "";
            errorMessage = !responseJsonObject.has("errmsg") ? MessageFormat.format(MWProperties.getInstance().getErrorMessage("error_scenario_without_error_msg_with_nonzero_opstatus"), responseJsonObject.get("opstatus")) : (!responseJsonObject.get("errmsg").isJsonNull() ? responseJsonObject.get("errmsg").getAsString() : "Error message is null");
            metadata.setErrMsg(errorMessage);
            if (responseJsonObject.has("opstatus")) {
                metadata.setOpstatus(responseJsonObject.get("opstatus").getAsLong());
            }
            if (responseJsonObject.has("httpStatusCode")) {
                metadata.setHttpStatusCode(responseJsonObject.get("httpStatusCode").getAsLong());
            }
            rowUploadHandler.onFailure(httpServletRequest, httpServletResponse, inputRow, parentContext);
        } else {
            Row responseRow = this.prepareResponseRow(inputRow, responseJsonObject);
            rowUploadHandler.onSuccess(httpServletRequest, httpServletResponse, responseRow, parentContext);
        }
    }

    protected Row prepareResponseRow(Row inputRow, JsonObject responseJsonObject) throws DataAccessException {
        return RowUtil.createResponseRow(inputRow, responseJsonObject);
    }
}

