/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.datasourcelogs.DeviceRequestData;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.request.PrimaryKey;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.PayloadParser;
import com.konylabs.middleware.request.builder.PayloadParserUtil;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowMetadata;
import com.konylabs.middleware.request.builder.RowUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class AbstractPayloadParser
implements PayloadParser {
    private static final Logger LOGGER = Logger.getLogger(AbstractPayloadParser.class);
    protected RequestContext context;
    protected HttpServletRequest httpServletRequest;
    protected HttpServletResponse httpServletResponse;
    private JsonElement totalPayload;
    private Map<String, String> queryParams;

    public AbstractPayloadParser(HttpServletRequest httpServletRequest, RequestContext context, HttpServletResponse httpServletResponse, JsonElement totalPayload, Map<String, String> queryParams) {
        this(httpServletRequest, context, httpServletResponse);
        this.totalPayload = totalPayload;
        this.queryParams = queryParams;
        DeviceRequestData deviceRequestData = (DeviceRequestData)httpServletRequest.getAttribute("DeviceReqLogBean");
        deviceRequestData.setBody(this.totalPayload.toString());
        deviceRequestData.setQueryParams(this.queryParams.toString());
    }

    public AbstractPayloadParser(HttpServletRequest httpServletRequest, RequestContext context, HttpServletResponse httpServletResponse) {
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        this.context = context;
    }

    protected Row prepareRowWithMetadata(JsonObject inputFieldJson) throws AppRegistryException {
        String key;
        LOGGER.debug((Object)" Inside prepareRowWithMetadata()");
        JsonObject metadataObj = PayloadParserUtil.getAndRemove(inputFieldJson, "_metadata");
        if (metadataObj == null) {
            metadataObj = new JsonObject();
        }
        String objectName = metadataObj.has(key = "object") ? metadataObj.get(key).getAsString() : this.context.getObjectId();
        key = "action";
        String operationId = metadataObj.has(key) ? metadataObj.get(key).getAsString() : this.context.getDefaultOperation();
        ObjectMetadata objectMetadata = this.context.getAppMetadata().getObjectMetadata(objectName);
        PrimaryKey primaryKey = PrimaryKey.extractPK(objectMetadata.getPrimaryKeys(), inputFieldJson);
        RowMetadata metadata = new RowMetadata(objectMetadata, objectName);
        metadata.setOperationId(operationId);
        if (metadataObj.has("checksum")) {
            metadata.setCheckSum(metadataObj.get("checksum").getAsString());
        }
        metadata.setPrimaryKey(primaryKey);
        metadata.setAppVersion(this.context.getAppVersion());
        metadata.setAction(operationId);
        if (metadataObj.has("rowId")) {
            metadata.setRowId(metadataObj.get("rowId"));
        }
        Row row = new Row(inputFieldJson);
        row.setMetadata(metadata);
        row.setValue("appID", this.context.getAppId());
        row.setValue("X-Kony-API-Version", this.context.getAppVersion().getVersion());
        RowUtil.setServiceId(this.context, objectName, operationId, metadata, row);
        row.setValue("objectID", objectName);
        row.setValue("operationId", operationId);
        row.setStrategy(RowUtil.getOperationStratergyByOperationId(operationId));
        return row;
    }

    public JsonElement getTotalPayload() {
        return this.totalPayload;
    }

    Map<String, String> getQueryParams() {
        return this.queryParams;
    }
}

