/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.commons.xss.XSSValidator;
import com.konylabs.middleware.config.LoggerProperties;
import com.konylabs.middleware.datasourcelogs.DiagnosticLogService;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.exceptions.XssException;
import com.konylabs.middleware.mbaas.MBAASGateWayWrapper;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.PayloadParser;
import com.konylabs.middleware.request.builder.RequestBuilder;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.builder.UriContext;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.LoggerUtility;
import com.konylabs.middleware.utilities.MetricsBeanUtils;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractRequestBuilder
implements RequestBuilder {
    private static final Logger LOGGER = Logger.getLogger(AbstractRequestBuilder.class);
    protected HttpServletRequest httpServletRequest;
    protected HttpServletResponse httpServletResponse;
    protected UriContext uriContext;
    protected RequestContext requestContext;
    protected XSSValidator xssValidator;

    protected abstract PayloadParser getPayloadParser() throws Exception;

    protected abstract void addProcessingStrategy(PayloadParser var1, RequestData var2);

    protected abstract RequestData buildCore() throws Exception;

    @Override
    public RequestBuilder with(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
        return this;
    }

    @Override
    public RequestBuilder with(UriContext uriContext) {
        this.uriContext = uriContext;
        return this;
    }

    @Override
    public RequestBuilder with(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
        return this;
    }

    @Override
    public RequestBuilder with(XSSValidator xssValidator) {
        this.xssValidator = xssValidator;
        return this;
    }

    @Override
    public RequestBuilder with(RequestContext requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    @Override
    public RequestData build() throws MiddlewareException, Exception {
        LOGGER.debug((Object)"Inside build()");
        this.addServiceInfoToMetricsBean();
        RequestData requestData = this.buildCore();
        LoggerUtility.addClientLogLevelInResponseHeader(this.httpServletRequest, this.httpServletResponse);
        return requestData;
    }

    protected RequestData parsePayload() throws AppRegistryException, MiddlewareException, Exception {
        LOGGER.debug((Object)"Inside parsePayload()");
        PayloadParser payloadParser = this.getPayloadParser();
        RequestData requestData = payloadParser.parse();
        LoggerUtility.matchAndSetDynamicLogLevel(this.httpServletRequest, this.httpServletResponse, requestData.getAppId());
        this.addProcessingStrategy(payloadParser, requestData);
        DiagnosticLogService.setDiagnosticContextInfo(this.httpServletRequest, this.requestContext.isRequestpassthrough());
        return requestData;
    }

    protected void doXSSCheck() throws XssException {
        this.xssValidator.doXSSCheck(this.httpServletRequest, (ServletResponse)this.httpServletResponse);
    }

    protected void matchAndSetLevelForAppName(MBAASGateWayWrapper gatewayWrapper) {
        String appID;
        String criteria = (String)LoggerProperties.MFAPP_NAME_LOG_CRITERIA.getFromConfig();
        if (StringUtils.isNotBlank((String)criteria) && !"{}".equalsIgnoreCase(criteria) && (appID = gatewayWrapper.getFabricAppId()) != null) {
            LoggerUtility.matchAndSetDynamicLogLevel(LoggerProperties.MFAPP_NAME_LOG_CRITERIA, appID);
        }
    }

    protected void addServiceInfoToMetricsBean() {
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)this.httpServletRequest, (String)"svcid", (Object)this.requestContext.getServiceId());
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)this.httpServletRequest, (String)"svcgroup", (Object)this.requestContext.getAppId());
    }
}

