/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.kony.api.gateway.Gateway;
import com.kony.api.gateway.GatewayConfig;
import com.kony.api.gateway.GatewayException;
import com.konylabs.middleware.config.LoggerProperties;
import com.konylabs.middleware.datasourcelogs.DiagnosticLogService;
import com.konylabs.middleware.http.HttpMethods;
import com.konylabs.middleware.mbaas.MBAASGateWayWrapper;
import com.konylabs.middleware.mbaas.MiddlewareMBaasUtils;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.vo.SecurityTypeEnum;
import com.konylabs.middleware.request.builder.AuthorizationException;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.LoggerUtility;
import com.konylabs.middleware.utilities.MetricsBeanUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Authenticator {
    private static final Logger LOGGER = Logger.getLogger(Authenticator.class);
    private RequestContext requestContext;

    public Authenticator(RequestContext authContext) {
        this.requestContext = authContext;
    }

    public MBAASGateWayWrapper authorize() throws GatewayException, AuthorizationException {
        LOGGER.debug((Object)" Inside authorize()");
        MBAASGateWayWrapper gatewayWrapper = null;
        boolean isAuthorized = false;
        if (!this.requestContext.isGatewayEnabled()) {
            return gatewayWrapper;
        }
        boolean isSecurityPublic = SecurityTypeEnum.isSecurityPublicApp((String)this.requestContext.getSecurityLevel());
        boolean hasAuthHeader = StringUtils.isNotBlank((String)this.requestContext.getAuthHeader());
        if (hasAuthHeader) {
            gatewayWrapper = this.getGatewayWrapperInstance();
        }
        if (!isSecurityPublic) {
            String requestedMethod = this.requestContext.getRequestedMethod();
            if (gatewayWrapper != null) {
                isAuthorized = gatewayWrapper.isAuthorized(this.requestContext.getSecurityLevel(), this.requestContext.getResourceUrl(), requestedMethod, this.requestContext.getResourceName());
            }
            if (!isAuthorized) {
                this.throwAuthorizationException("17005");
            }
        }
        return gatewayWrapper;
    }

    public void throwAuthorizationException(String errorcode) throws AuthorizationException {
        String errorMessage = AuthorizationException.getErrorMessage(errorcode);
        throw new AuthorizationException(errorcode, errorMessage, this.requestContext.getAppId());
    }

    public void doPostAuthentication(HttpServletRequest httpServletRequest, MBAASGateWayWrapper gatewayWrapper) {
        if (gatewayWrapper != null) {
            LOGGER.debug((Object)"Authorization check is successful");
            String userId = gatewayWrapper.getClaimsToken().getUserId();
            LoggerUtility.matchAndSetDynamicLogLevel(LoggerProperties.USER_ID_LOG_CRITERIA, userId);
            this.matchAndSetLevelForAppName(gatewayWrapper);
            this.addAppIDToMetricsBean(httpServletRequest, gatewayWrapper);
            DiagnosticLogService.saveLogMetaIntoNDC("userId", userId);
            this.requestContext.setGateWayWrapper(gatewayWrapper);
        }
    }

    protected String getRequestedMethod() {
        String requestedMethod = this.getRequestContext().getRequestedMethod();
        return "upload".equals(requestedMethod) ? HttpMethods.POST.name() : requestedMethod;
    }

    protected RequestContext getRequestContext() {
        return this.requestContext;
    }

    protected MBAASGateWayWrapper getGatewayWrapperInstance() throws GatewayException {
        TenantBean<AppCache> tenantBean = this.requestContext.getTenantBean();
        GatewayConfig gateWayConfig = tenantBean.getGatewayConfig(this.requestContext.getCacheDirector());
        return MiddlewareMBaasUtils.getGatewayWrapper(this.requestContext.getAuthHeader(), this.requestContext.getRequestId(), gateWayConfig);
    }

    private void matchAndSetLevelForAppName(MBAASGateWayWrapper gatewayWrapper) {
        String appID;
        String criteria = (String)LoggerProperties.MFAPP_NAME_LOG_CRITERIA.getFromConfig();
        if (StringUtils.isNotBlank((String)criteria) && !"{}".equalsIgnoreCase(criteria) && (appID = gatewayWrapper.getFabricAppId()) != null) {
            LoggerUtility.matchAndSetDynamicLogLevel(LoggerProperties.MFAPP_NAME_LOG_CRITERIA, appID);
        }
    }

    private void addAppIDToMetricsBean(HttpServletRequest httpServletRequest, MBAASGateWayWrapper gatewayWrapper) {
        Gateway gatewayInstance = gatewayWrapper.getGateway();
        try {
            Map appAttributes = gatewayInstance.getAppAttributes();
            String appId = (String)appAttributes.get("app_id");
            String appName = (String)appAttributes.get("app_name");
            MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)httpServletRequest, (String)"aid", (Object)appId);
            MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)httpServletRequest, (String)"mfaid", (Object)appId);
            MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)httpServletRequest, (String)"aname", (Object)appName);
            MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)httpServletRequest, (String)"mfaname", (Object)appName);
            MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)httpServletRequest, (String)"mfbaseid", appAttributes.get("baseid"));
        }
        catch (GatewayException e) {
            LOGGER.error((Object)"Failed to get Gateway attributes.");
        }
    }
}

