/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.common.MWProperties;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.registry.AppRegistryException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AuthorizationException
extends MiddlewareException {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AppRegistryException.class);
    public static final String MBAAS_AUTHORIZATION_ERROR = "17005";
    private String appId;

    public AuthorizationException(String errorCode, String errorMessage, String appId) {
        super(errorCode, errorMessage);
        this.appId = appId;
    }

    private static String getErrorMessageKey(String errorCode) {
        if (StringUtils.isNumeric((String)errorCode)) {
            int code = Integer.parseInt(errorCode);
            switch (code) {
                case 17005: {
                    return "mbaas_authorization_error";
                }
            }
        }
        return null;
    }

    public static String getErrorMessage(String errorCode) {
        return MWProperties.getInstance().getErrorMessage(AuthorizationException.getErrorMessageKey(errorCode));
    }

    public Result prepareErrorResult() {
        return this.getErrorResult();
    }

    public Result getErrorResult() {
        LOGGER.debug((Object)"Authorization check failed and response is being returned without processing ");
        Result errorResult = new Result();
        errorResult.addParam(new Param("errcode", MBAAS_AUTHORIZATION_ERROR, "int"));
        errorResult.addParam(new Param("opstatus", MBAAS_AUTHORIZATION_ERROR, "int"));
        errorResult.addParam(new Param("errmsg", MWProperties.getInstance().getErrorMessage("mbaas_authorization_error"), "string"));
        errorResult.addParam(new Param("appId", this.appId, "string"));
        return errorResult;
    }
}

