/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.common.ActionType;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.customconflict.ConflictResolutionResult;
import com.konylabs.middleware.objservices.runtime.ConflictType;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.AbstractConflictResolver;
import com.konylabs.middleware.request.builder.CustomConflictUtil;
import com.konylabs.middleware.request.builder.GetAfterConflictResolver;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.Row;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class BaseCustomConflictResolver
extends AbstractConflictResolver {
    private static final Logger LOGGER = Logger.getLogger(BaseCustomConflictResolver.class);

    @Override
    public void resolveClientCreateServerExists(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientCreateServerExists()");
        this.processConflict(requestRow, responseRow, inputPayloadMetadata, context, isSoftDeleted, ConflictType.CLIENT_CREATE_SERVER_EXISTS);
    }

    @Override
    public void resolveClientUpdateServerUpdate(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientCreateServerExists()");
        this.processConflict(requestRow, responseRow, inputPayloadMetadata, context, isSoftDeleted, ConflictType.CLIENT_UPDATE_SERVER_UPDATE);
    }

    @Override
    public void resolveClientUpdateServerDelete(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        try {
            ConflictResolutionResult conflictResult = this.resolveConflict(requestRow, responseRow, inputPayloadMetadata, isSoftDeleted, ConflictType.CLIENT_UPDATE_SERVER_DELETE);
            if (conflictResult.isSubmitToServer() && conflictResult.getActionType() == ActionType.update && !isSoftDeleted) {
                conflictResult.setActionType(ActionType.create);
            }
            this.processConflictResult(requestRow, responseRow, inputPayloadMetadata, context, isSoftDeleted, conflictResult);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("error while processing custom conflict " + ex.getMessage()));
            ((GetAfterConflictResolver)context.get("handler")).onError(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getHttpServletResponse(), ex, (Context)context.get("parentContext"));
        }
    }

    @Override
    public void resolveClientDeleteServerUpdate(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientDeleteServerUpdate()");
        this.processConflict(requestRow, responseRow, inputPayloadMetadata, context, isSoftDeleted, ConflictType.CLIENT_DELETE_SERVER_UPDATE);
    }

    @Override
    public void resolveClientDeleteServerDelete(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientDeleteServerNotExists()");
        super.resolveClientDeleteServerDelete(requestRow, responseRow, inputPayloadMetadata, context, isSoftDeleted);
    }

    protected void returnResponseWithoutSubmittingToBackend(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        HttpServletRequest httpServletRequest = inputPayloadMetadata.getHttpServletRequest();
        HttpServletResponse httpServletResponse = inputPayloadMetadata.getHttpServletResponse();
        GetAfterConflictResolver rowUploadHandler = (GetAfterConflictResolver)context.get("handler");
        Context parentContext = (Context)context.get("parentContext");
        try {
            if (responseRow.getMetadata().getAction().equals(OperationEnum.delete.name())) {
                this.getAsyncHandler(rowUploadHandler).onSuccess(httpServletRequest, httpServletResponse, this.resultRowOnDelete(requestRow, requestRow), parentContext);
            } else {
                this.getAsyncHandler(rowUploadHandler).onSuccess(httpServletRequest, httpServletResponse, responseRow, parentContext);
            }
        }
        catch (Exception ex) {
            rowUploadHandler.onError(httpServletRequest, httpServletResponse, ex, parentContext);
        }
    }

    private void processConflict(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted, ConflictType conflictType) {
        try {
            ConflictResolutionResult conflictResult = this.resolveConflict(requestRow, responseRow, inputPayloadMetadata, isSoftDeleted, conflictType);
            this.processConflictResult(requestRow, responseRow, inputPayloadMetadata, context, isSoftDeleted, conflictResult);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error while processing custom conflict " + ex.getMessage()));
            ((GetAfterConflictResolver)context.get("handler")).onError(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getHttpServletResponse(), ex, (Context)context.get("parentContext"));
        }
    }

    private ConflictResolutionResult resolveConflict(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, boolean isSoftDeleted, ConflictType conflictType) throws Exception {
        ConflictResolutionResult conflictResult;
        try {
            conflictResult = CustomConflictUtil.resolveConflict(requestRow, responseRow, inputPayloadMetadata, isSoftDeleted, conflictType);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while resolving custom conflict " + e.getMessage()));
            throw e;
        }
        return conflictResult;
    }

    private void processConflictResult(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted, ConflictResolutionResult cr) throws AppRegistryException {
        try {
            if (!cr.isSubmitToServer() || cr.getActionType().equals((Object)ActionType.delete) && responseRow.getMetadata().getAction().equals(ActionType.delete.name())) {
                this.returnResponseWithoutSubmittingToBackend(requestRow, responseRow, inputPayloadMetadata, context, isSoftDeleted);
            } else {
                this.addRequiredParams(cr.getResolveddata(), requestRow.getMetadata().getObjectMetadata());
                Row resolvedRow = new Row(cr.getResolveddata());
                resolvedRow.setMetadata(requestRow.getMetadata());
                this.processConflictResultBasedOnAction(resolvedRow, inputPayloadMetadata, context, cr.getActionType().name());
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("processConflictResult() : error while processing conflict result" + ex.getMessage()));
            throw ex;
        }
    }

    private void addRequiredParams(JsonObject resolveddata, ObjectMetadata objectMetadata) {
        resolveddata.addProperty("objectID", objectMetadata.getName());
        resolveddata.addProperty("appID", objectMetadata.getAppMetadata().getApplicationVersion().getAppId());
    }

    private void processConflictResultBasedOnAction(Row conflictResultRow, InputPayloadMetadata inputPayloadMetadata, Context context, String action) throws AppRegistryException {
        try {
            conflictResultRow.getMetadata().setAction(action);
            String updateServiceId = ObjectServiceUtil.getServiceId(inputPayloadMetadata.getRequestData().getAppMetadata(), conflictResultRow.getMetadata().getObjectName(), action);
            conflictResultRow.getMetadata().setOperationId(action);
            conflictResultRow.setValue("serviceID", updateServiceId);
            conflictResultRow.setStrategy(OperationEnum.valueOf(action).getStrategy());
            conflictResultRow.getStrategy().process(conflictResultRow, inputPayloadMetadata, context);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("processConflictResultBasedOnAction() : error while submitting conflict result " + ex.getMessage()));
            throw ex;
        }
    }
}

