/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.servlet.AppServicesAsyncHandler;
import com.konylabs.middleware.appservices.servlet.RowUploadHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.controller.AppServicesAsyncHandlerChain;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.ObjectServiceResponseData;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowUtil;
import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class BulkUploadAsyncHandler
implements RowUploadHandler,
AppServicesAsyncHandlerChain {
    BulkUploadAsyncHandler() {
    }

    @Override
    public void onSuccess(HttpServletRequest request, HttpServletResponse response, Row responseRow, Context context) {
        Row requestRow = (Row)context.get("requestRow");
        ObjectServiceResponseData objectServiceResponseData = (ObjectServiceResponseData)context.get("objectServiceResponseData");
        ApplicationMetadata appMetadata = (ApplicationMetadata)context.get("appMetadata");
        requestRow.getStrategy().afterProcessing(requestRow, responseRow, (InputPayloadMetadata)context.get("inputPayloadMetadata"), appMetadata);
        JsonObject responseJson = RowUtil.prepareSuccessResponseJson(objectServiceResponseData, requestRow, responseRow);
        objectServiceResponseData.updateResponseRecordsAndIncrementSuccessCount((JsonElement)responseJson, requestRow.getMetadata().getObjectName());
        ((CountDownLatch)context.get("latch")).countDown();
    }

    @Override
    public void onError(HttpServletRequest request, HttpServletResponse response, Exception exception, Context context) {
        String opstatusStr;
        String errorMessage = "";
        errorMessage = exception.getMessage() != null && StringUtils.isNotBlank((String)exception.getMessage()) ? exception.getMessage() : "error_occurred_while_processing_record";
        long opstatus = 14056L;
        if (exception instanceof MiddlewareException && StringUtils.isNotBlank((String)(opstatusStr = ((MiddlewareException)((Object)exception)).getErrorCode()))) {
            opstatus = Long.parseLong(opstatusStr);
        }
        Row requestRow = (Row)context.get("requestRow");
        requestRow.getMetadata().setErrMsg(errorMessage);
        requestRow.getMetadata().setOpstatus(opstatus);
        this.processingFailedRecords(context);
    }

    private void processingFailedRecords(Context context) {
        ((InputPayloadMetadata)context.get("inputPayloadMetadata")).getAbortPolicy().processFailedResponse((ObjectServiceResponseData)context.get("objectServiceResponseData"), (Row)context.get("requestRow"));
        ((CountDownLatch)context.get("latch")).countDown();
    }

    @Override
    public void onFailure(HttpServletRequest request, HttpServletResponse response, Row result, Context context) {
        this.processingFailedRecords(context);
    }

    @Override
    public AppServicesAsyncHandler<?> getParentHandler(Context parentContext) {
        return (AppServicesAsyncHandler)parentContext.get("handler");
    }
}

