/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.ParentChildType;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.AbortOnError;
import com.konylabs.middleware.request.builder.AbstractPayloadParser;
import com.konylabs.middleware.request.builder.ContinueOnError;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.ObjectServiceRequestData;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowMetadata;
import com.konylabs.middleware.request.parser.RequestData;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class BulkUploadPayloadParser
extends AbstractPayloadParser {
    private static final Logger LOGGER = Logger.getLogger(BulkUploadPayloadParser.class);

    public BulkUploadPayloadParser(HttpServletRequest httpServletRequest, RequestContext context, HttpServletResponse httpServletResponse, JsonElement totalPayload, Map<String, String> queryParams) {
        super(httpServletRequest, context, httpServletResponse, totalPayload, queryParams);
    }

    @Override
    public RequestData parse() throws AppRegistryException, MiddlewareException, Exception {
        LOGGER.debug((Object)" Inside parse()");
        ObjectServiceRequestData objectServiceRequestData = new ObjectServiceRequestData(this.context.getAppMetadata());
        JsonElement inputPayload = this.getTotalPayload();
        InputPayloadMetadata payloadMetadata = this.prepareInputPayloadMetadata(inputPayload, this.context);
        payloadMetadata.setParentChildListByChildObjectname(this.context.getAppMetadata().getParentChildListByChildObjectname());
        payloadMetadata.setJsonQueryParam(this.getQueryParams());
        objectServiceRequestData.setHttpServletRequest(this.httpServletRequest);
        objectServiceRequestData.setHttpServletResponse(this.httpServletResponse);
        objectServiceRequestData.setInputPayloadMetadata(payloadMetadata);
        this.context.setRequestCacheSupported(true);
        return objectServiceRequestData;
    }

    public InputPayloadMetadata prepareInputPayloadMetadata(JsonElement inputJsonElement, RequestContext context) throws AppRegistryException {
        LOGGER.debug((Object)" Inside prepareObjectServiceRequestData()");
        boolean abort = false;
        JsonArray jsonArray = null;
        if (inputJsonElement.isJsonArray()) {
            jsonArray = inputJsonElement.getAsJsonArray();
        } else if (inputJsonElement.isJsonObject()) {
            JsonObject jsonObject = inputJsonElement.getAsJsonObject();
            boolean bl = abort = jsonObject.has("abortonError") && Boolean.valueOf(jsonObject.get("abortonError").getAsString()) != false;
            if (jsonObject.has("records")) {
                JsonElement element = jsonObject.get("records");
                jsonArray = element.getAsJsonArray();
            } else {
                jsonArray = new JsonArray();
                jsonArray.add(inputJsonElement);
            }
        }
        InputPayloadMetadata inputPayloadMetadata = this.getObjectServiceRequestData(jsonArray);
        inputPayloadMetadata.setAbortPolicy(abort ? new AbortOnError() : new ContinueOnError());
        return inputPayloadMetadata;
    }

    private InputPayloadMetadata getObjectServiceRequestData(JsonArray jsonArray) throws AppRegistryException {
        LOGGER.debug((Object)" Inside getObjectServiceRequestData()");
        InputPayloadMetadata inputPayloadMetadata = new InputPayloadMetadata();
        int index = 1;
        for (JsonElement jsonElement : jsonArray) {
            if (jsonElement.isJsonArray()) {
                this.getObjectServiceRequestData(jsonElement.getAsJsonArray());
                continue;
            }
            JsonObject inputFieldJson = jsonElement.getAsJsonObject();
            Row row = this.createRow(inputFieldJson);
            row.getMetadata().setUploadedOrder(index);
            inputPayloadMetadata.addRow(row);
            ++index;
        }
        return inputPayloadMetadata;
    }

    private Row createRow(JsonObject inputFieldJson) throws AppRegistryException {
        LOGGER.debug((Object)" Inside createRow()");
        Row row = this.prepareRowWithMetadata(inputFieldJson);
        RowMetadata metadata = row.getMetadata();
        ObjectMetadata objectMetadata = metadata.getObjectMetadata();
        List<ParentChildType> parentChildList = objectMetadata.getParentChildList();
        if (parentChildList != null && !parentChildList.isEmpty()) {
            for (ParentChildType parentChildType : parentChildList) {
                List<String> parentFieldTypes = parentChildType.getParentFieldTypes();
                JsonArray inputFkValues = new JsonArray();
                for (String parentField : parentFieldTypes) {
                    if (!inputFieldJson.has(parentField)) continue;
                    inputFkValues.add(inputFieldJson.get(parentField));
                }
                metadata.setInputFkValue(parentChildType.getRelationshipName(), inputFkValues);
            }
        }
        return row;
    }
}

