/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.request.builder.BulkUploadAsyncHandler;
import com.konylabs.middleware.request.builder.BulkUploadResponseAsyncHandler;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.ObjectServiceResponseData;
import com.konylabs.middleware.request.builder.RequestProcessingStrategy;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.UploadRowStrategy;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class BulkUploadProcessingStrategy
implements RequestProcessingStrategy {
    private static final Logger LOGGER = Logger.getLogger(BulkUploadProcessingStrategy.class);
    private static final BulkUploadResponseAsyncHandler bulkUploadResponseAsyncHandler = new BulkUploadResponseAsyncHandler();
    private static final BulkUploadAsyncHandler bulkUploadAsyncHandler = new BulkUploadAsyncHandler();

    @Override
    public void process(InputPayloadMetadata inputPayloadMetadata, Context parentContext) {
        LOGGER.debug((Object)" Inside process()");
        List<Row> rowList = inputPayloadMetadata.getRowList();
        ObjectServiceResponseData objectServiceResponseData = new ObjectServiceResponseData();
        objectServiceResponseData.setParentListByChildName(inputPayloadMetadata.getParentChildListByChildObjectnameMap());
        Context context = new Context();
        context.put("parentContext", (Object)parentContext);
        context.put("handler", (Object)bulkUploadResponseAsyncHandler);
        ApplicationMetadata appMetadata = (ApplicationMetadata)parentContext.get("appMetadata");
        context.put("appMetadata", (Object)appMetadata);
        for (Row requestRow : rowList) {
            requestRow.getStrategy().beforeProcessing(requestRow, inputPayloadMetadata, appMetadata);
            if (!inputPayloadMetadata.getAbortPolicy().canProcessRequest(objectServiceResponseData, requestRow)) continue;
            this.process(requestRow, objectServiceResponseData, inputPayloadMetadata, context);
        }
        bulkUploadResponseAsyncHandler.onSuccess(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getHttpServletResponse(), objectServiceResponseData, context);
    }

    private void process(Row requestRow, ObjectServiceResponseData objectServiceResponseData, InputPayloadMetadata inputPayloadMetadata, Context parentContext) {
        LOGGER.debug((Object)" Inside process()");
        UploadRowStrategy uploadRowStrategy = requestRow.getMetadata().getObjectMetadata().getUploadRowStrategy();
        CountDownLatch latch = new CountDownLatch(1);
        Context context = new Context();
        ApplicationMetadata appMetadata = (ApplicationMetadata)parentContext.get("appMetadata");
        context.put("appMetadata", (Object)appMetadata);
        context.put("parentContext", (Object)parentContext);
        context.put("requestRow", (Object)requestRow);
        context.put("objectServiceResponseData", (Object)objectServiceResponseData);
        context.put("inputPayloadMetadata", (Object)inputPayloadMetadata);
        context.put("latch", (Object)latch);
        context.put("handler", (Object)bulkUploadAsyncHandler);
        uploadRowStrategy.performAction(requestRow, inputPayloadMetadata, context);
        this.waitForResults(latch);
    }

    protected void waitForResults(CountDownLatch latch) {
        LOGGER.debug((Object)"Submitted the operation and waiting for results.");
        try {
            latch.await(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Failed executing the operation", (Throwable)e);
        }
    }
}

