/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.servlet.AppServicesAsyncHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.controller.AppServicesAsyncHandlerChain;
import com.konylabs.middleware.request.builder.ObjectServiceResponseData;
import com.konylabs.middleware.request.builder.Row;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BulkUploadResponseAsyncHandler
implements AppServicesAsyncHandler<ObjectServiceResponseData>,
AppServicesAsyncHandlerChain {
    BulkUploadResponseAsyncHandler() {
    }

    @Override
    public void onSuccess(HttpServletRequest request, HttpServletResponse response, ObjectServiceResponseData objectServiceResponseData, Context context) {
        Context parentContext = (Context)context.get("parentContext");
        long startTimeOfResponseProcessing = System.currentTimeMillis();
        JsonObject responseJson = objectServiceResponseData.getResponseInJson();
        this.addResponseParamsToMetricsBeanForUploadFlow(objectServiceResponseData, request, startTimeOfResponseProcessing);
        objectServiceResponseData.setResponseStream(new Gson().toJson((JsonElement)responseJson));
        this.getParentHandler(parentContext).onSuccess(request, response, objectServiceResponseData, parentContext);
    }

    @Override
    public void onError(HttpServletRequest request, HttpServletResponse response, Exception exception, Context context) {
        Context parentContext = (Context)context.get("parentContext");
        this.getParentHandler(parentContext).onError(request, response, exception, parentContext);
    }

    public AppServicesAsyncHandler<ObjectServiceResponseData> getParentHandler(Context parentContext) {
        return (AppServicesAsyncHandler)parentContext.get("handler");
    }

    private void addResponseParamsToMetricsBeanForUploadFlow(ObjectServiceResponseData objectServiceResponseData, HttpServletRequest request, long startTimeOfResponseProcessing) {
        Row lastFailedRecord = objectServiceResponseData.getLastFailedrecord();
        String errMsg = lastFailedRecord != null ? lastFailedRecord.getMetadata().getErrMsg() : "";
        MetricsUtils.addResponseInfoToMetricsBean(request, startTimeOfResponseProcessing, objectServiceResponseData.getResponseInJson(), objectServiceResponseData.getSuccessCount(), errMsg, errMsg);
    }
}

