/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.appservices.servlet.RowUploadHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.request.builder.AbstractConflictResolver;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowMetadata;
import org.apache.log4j.Logger;

public class ClientWinsConflictResolver
extends AbstractConflictResolver {
    private static final Logger LOGGER = Logger.getLogger(ClientWinsConflictResolver.class);

    @Override
    public void resolveClientCreateServerExists(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientCreateServerExists()");
        try {
            RowMetadata rowMetadata = requestRow.getMetadata();
            String updateOperationId = OperationEnum.update.name();
            String updateServiceId = ObjectServiceUtil.getServiceId(inputPayloadMetadata.getRequestData().getAppMetadata(), rowMetadata.getObjectName(), updateOperationId);
            requestRow.getMetadata().setOperationId(updateOperationId);
            requestRow.getMetadata().setAction(updateOperationId);
            requestRow.setValue("serviceID", updateServiceId);
            requestRow.setStrategy(OperationEnum.update.getStrategy());
            requestRow.getStrategy().process(requestRow, inputPayloadMetadata, context);
        }
        catch (Exception ex) {
            ((RowUploadHandler)context.get("handler")).onError(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getHttpServletResponse(), ex, context);
        }
    }

    @Override
    public void resolveClientUpdateServerUpdate(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientUpdateServerUpdate()");
        requestRow.getStrategy().process(requestRow, inputPayloadMetadata, context);
    }

    @Override
    public void resolveClientUpdateServerDelete(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientUpdateServerDelete()");
        try {
            if (!isSoftDeleted) {
                RowMetadata rowMetadata = requestRow.getMetadata();
                String createOperationId = OperationEnum.create.name();
                String createServiceId = ObjectServiceUtil.getServiceId(inputPayloadMetadata.getRequestData().getAppMetadata(), rowMetadata.getObjectName(), createOperationId);
                requestRow.getMetadata().setOperationId(createOperationId);
                requestRow.getMetadata().setAction(createOperationId);
                requestRow.setValue("serviceID", createServiceId);
                requestRow.setStrategy(OperationEnum.create.getStrategy());
                requestRow.getStrategy().process(requestRow, inputPayloadMetadata, context);
            } else {
                requestRow.getStrategy().process(requestRow, inputPayloadMetadata, context);
            }
        }
        catch (Exception ex) {
            ((RowUploadHandler)context.get("handler")).onError(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getHttpServletResponse(), ex, context);
        }
    }

    @Override
    public void resolveClientDeleteServerUpdate(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientDeleteServerUpdate()");
        requestRow.getStrategy().process(requestRow, inputPayloadMetadata, context);
    }

    @Override
    public void resolveClientDeleteServerDelete(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientDeleteServerNotExists()");
        super.resolveClientDeleteServerDelete(requestRow, responseRow, inputPayloadMetadata, context, isSoftDeleted);
    }
}

