/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.util.DeltaContextUtil;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.appservices.servlet.RowUploadHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.objservices.runtime.AbstractUploadStrategy;
import com.konylabs.middleware.objservices.runtime.ConflictResolver;
import com.konylabs.middleware.objservices.runtime.ConflictResolvingHandler;
import com.konylabs.middleware.objservices.runtime.metadata.FieldMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.GetAfterConflictResolver;
import com.konylabs.middleware.request.builder.GetOperationStrategy;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowMetadata;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConflictUploadStrategy
extends AbstractUploadStrategy {
    private static final Logger LOGGER = Logger.getLogger(ConflictUploadStrategy.class);

    public void doGet(Row requestRow, InputPayloadMetadata inputPayloadMetadata, RowUploadHandler asyncHandler, Row originalRequestRow, Context context) {
        LOGGER.debug((Object)" Inside doGet()");
        try {
            RowMetadata rowMetadata = requestRow.getMetadata();
            ObjectMetadata objMetadata = rowMetadata.getObjectMetadata();
            String getOperationId = OperationEnum.get.name();
            String getServiceId = DeltaContextUtil.getGetVariantServiceId(inputPayloadMetadata.getRequestData().getAppMetadata(), rowMetadata.getObjectName(), OperationEnum.getbypk.name());
            if (StringUtils.isBlank((String)getServiceId)) {
                getServiceId = ObjectServiceUtil.getServiceId(inputPayloadMetadata.getRequestData().getAppMetadata(), rowMetadata.getObjectName(), getOperationId);
            }
            Row getRequestRow = new Row(new JsonObject());
            RowMetadata metadata = new RowMetadata(objMetadata, rowMetadata.getObjectName());
            metadata.setOperationId(getOperationId);
            metadata.setRowId(rowMetadata.getRowId());
            metadata.setPrimaryKey(rowMetadata.getPrimaryKey());
            metadata.setAppVersion(rowMetadata.getAppVersion());
            metadata.setAction(getOperationId);
            getRequestRow.setMetadata(metadata);
            getRequestRow.setValue("_metadata", (JsonElement)metadata.getAsJsonObject());
            JsonObject jsonpayload = (JsonObject)requestRow.getJsonElement();
            getRequestRow.setValue("appID", metadata.getAppVersion().getAppId());
            getRequestRow.setValue("X-Kony-API-Version", metadata.getAppVersion().getVersion());
            getRequestRow.setValue("serviceID", getServiceId);
            getRequestRow.setValue("objectID", metadata.getObjectName());
            getRequestRow.setStrategy(new GetOperationStrategy());
            List<String> primaryKeysList = objMetadata.getPrimaryKeys();
            String odataFilter = this.getOdataFilterFromJsonPayload(jsonpayload, primaryKeysList);
            if (StringUtils.isEmpty((String)odataFilter)) {
                odataFilter = this.getOdataFilterFromJsonPayload(originalRequestRow.getJsonElement().getAsJsonObject(), primaryKeysList);
            }
            inputPayloadMetadata.getQueryParamMap().put("$filter", odataFilter);
            getRequestRow.setValue("$filter", odataFilter);
            getRequestRow.getStrategy().process(getRequestRow, inputPayloadMetadata, context);
        }
        catch (AppRegistryException ex) {
            StringBuilder errorMessage = new StringBuilder().append(OperationEnum.get.name()).append(" ").append(AppRegistryException.getErrorMessageForKey((String)"service_not_configured_operation"));
            String errorCode = "14042";
            asyncHandler.onError(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getHttpServletResponse(), (Exception)((Object)new AppRegistryException(errorCode, errorMessage.toString())), context);
        }
        catch (Exception ex) {
            asyncHandler.onError(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getHttpServletResponse(), ex, context);
        }
    }

    protected String getOdataFilterFromJsonPayload(JsonObject jsonpayload, List<String> primaryKeysList) {
        LOGGER.debug((Object)" Inside getOdataFilterFromJsonPayload()");
        StringBuffer odataFilter = new StringBuffer();
        for (String primaryKey : primaryKeysList) {
            JsonElement primaryKeyJson;
            if (jsonpayload.has(primaryKey) && odataFilter.length() != 0) {
                odataFilter.append(" and ");
            }
            if ((primaryKeyJson = jsonpayload.get(primaryKey)) == null || StringUtils.isEmpty((String)primaryKeyJson.getAsString())) continue;
            String primaryKeyAsString = primaryKeyJson.getAsString();
            primaryKeyAsString = primaryKeyAsString.contains(" ") ? "'" + primaryKeyAsString + "'" : primaryKeyAsString;
            odataFilter.append(primaryKey).append(" eq ").append(primaryKeyAsString);
        }
        return odataFilter.toString().trim();
    }

    private boolean checkIfPKIsAutogenerated(ObjectMetadata objectMetadata) {
        List<String> primaryKeysList = objectMetadata.getPrimaryKeys();
        boolean isPKAutogenerated = false;
        for (String key : primaryKeysList) {
            FieldMetadata fieldMetadata = objectMetadata.getFieldMetadataMap().get(key);
            isPKAutogenerated = fieldMetadata.isAutoGenerated();
            if (!isPKAutogenerated) continue;
            break;
        }
        return isPKAutogenerated;
    }

    @Override
    public void performAction(Row requestRow, InputPayloadMetadata inputPayloadMetadata, Context parentContext) {
        LOGGER.debug((Object)" Inside performAction()");
        RowMetadata rowMetadata = requestRow.getMetadata();
        ObjectMetadata objectMetadata = rowMetadata.getObjectMetadata();
        ConflictResolver conflictResolver = objectMetadata.getConflictResolver();
        GetAfterConflictResolver conflictRowUploadhandler = new GetAfterConflictResolver(this, inputPayloadMetadata, (RowUploadHandler)parentContext.get("handler"), requestRow);
        Context context = new Context();
        context.put("handler", (Object)conflictRowUploadhandler);
        context.put("parentContext", (Object)parentContext);
        if (this.checkIfPKIsAutogenerated(objectMetadata) && OperationEnum.create.name().equalsIgnoreCase(rowMetadata.getAction())) {
            requestRow.getStrategy().process(requestRow, inputPayloadMetadata, context);
        } else {
            ConflictResolvingHandler resolvingHandler = new ConflictResolvingHandler(requestRow, inputPayloadMetadata, conflictResolver, conflictRowUploadhandler);
            context.put("handler", (Object)resolvingHandler);
            this.doGet(requestRow, inputPayloadMetadata, resolvingHandler, requestRow, context);
        }
    }
}

