/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.common.MWProperties;
import com.konylabs.middleware.objservices.runtime.metadata.ParentChildType;
import com.konylabs.middleware.request.builder.AbstractAbortPolicy;
import com.konylabs.middleware.request.builder.ObjectServiceResponseData;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowMetadata;
import com.konylabs.middleware.request.builder.RowUtil;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;

public class ContinueOnError
extends AbstractAbortPolicy {
    private static final Logger LOGGER = Logger.getLogger(ContinueOnError.class);

    @Override
    public boolean canProcessRequest(ObjectServiceResponseData objectServiceResponseData, Row currentRow) {
        LOGGER.debug((Object)" Inside canProcessRequest()");
        if (objectServiceResponseData.isAnyRecordFailed()) {
            StringBuffer failedRowIDs;
            RowMetadata metadata = currentRow.getMetadata();
            String objectName = metadata.getObjectName();
            List<Row> failedRowListByObjNameInputPk = objectServiceResponseData.getFailedRowListByObjNameInputPk(objectName, metadata.getPrimaryKey());
            if (failedRowListByObjNameInputPk != null && !failedRowListByObjNameInputPk.isEmpty()) {
                Row failedRow = failedRowListByObjNameInputPk.get(0);
                String action = failedRow.getMetadata().getAction();
                if (OperationEnum.create.name().equalsIgnoreCase(action)) {
                    JsonElement rowId = failedRow.getMetadata().getRowId();
                    String errorMessage = MWProperties.getInstance().getErrorMessage("client_row_entity_continueonerror_msg");
                    errorMessage = MessageFormat.format(errorMessage, rowId);
                    JsonObject responseJson = RowUtil.getFailedErrorJson(objectServiceResponseData, currentRow, errorMessage, 14053L);
                    objectServiceResponseData.updateResponseRecordsAndIncrementFailureCount((JsonElement)responseJson, currentRow.getMetadata().getObjectName());
                    return false;
                }
                return true;
            }
            List<ParentChildType> parentChildList = objectServiceResponseData.getParentChildListByChildObjectname(objectName);
            JsonObject inputFieldJson = currentRow.getJsonElement().getAsJsonObject();
            if (parentChildList != null && !parentChildList.isEmpty() && (failedRowIDs = this.getParentFailureRowIds(objectServiceResponseData, parentChildList, inputFieldJson)).length() > 0) {
                String errorMessage = MWProperties.getInstance().getErrorMessage("related_entity_continueonerror_msg");
                errorMessage = MessageFormat.format(errorMessage, failedRowIDs.toString());
                RowUtil.getFailedErrorJson(objectServiceResponseData, currentRow, errorMessage, 14054L);
                this.processFailedResponse(objectServiceResponseData, currentRow);
                return false;
            }
        }
        return true;
    }

    private StringBuffer getParentFailureRowIds(ObjectServiceResponseData objectServiceResponseData, List<ParentChildType> parentChildList, JsonObject inputFieldJson) {
        StringBuffer failedRowIDs = new StringBuffer();
        for (ParentChildType parentChildType : parentChildList) {
            List<Row> parentFailedRows;
            List<String> childFieldTypes = parentChildType.getChildFieldTypes();
            JsonArray fkList = new JsonArray();
            for (String childField : childFieldTypes) {
                if (!inputFieldJson.has(childField)) continue;
                fkList.add(inputFieldJson.get(childField));
            }
            if (fkList.size() <= 0 || (parentFailedRows = objectServiceResponseData.getFailedRowListByObjNameRelationshipNameInputFk(parentChildType.getParentObjectName(), parentChildType.getRelationshipName(), fkList)) == null || parentFailedRows.isEmpty()) continue;
            if (failedRowIDs.length() > 0) {
                failedRowIDs.append(",");
            }
            failedRowIDs.append(parentFailedRows.get(0).getMetadata().getRowId());
        }
        return failedRowIDs;
    }

    @Override
    public void processFailedResponse(ObjectServiceResponseData objectServiceResponseData, Row requestRow) {
        this.updateCurrentRowFailureWithPk(objectServiceResponseData, requestRow);
        this.markParentAsFailedWithRelations(objectServiceResponseData, requestRow);
    }
}

