/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.dataaccess.exception.DataAccessException;
import com.konylabs.middleware.objservices.metadata.ActionsDto;
import com.konylabs.middleware.objservices.metadata.SupportedObjectDto;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.request.PrimaryKey;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.request.builder.AbstractOperationStrategy;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowUtil;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class CreateOperationStrategy
extends AbstractOperationStrategy {
    private static final Logger LOGGER = Logger.getLogger(CreateOperationStrategy.class);

    @Override
    public void afterProcessing(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, ApplicationMetadata appMetadata) {
        LOGGER.debug((Object)" Inside afterProcessing()");
        String objectName = this.getObjectName(requestRow);
        this.processHierarchy(requestRow, requestRow.getMetadata().getPrimaryKey(), responseRow, objectName, inputPayloadMetadata, appMetadata);
    }

    @Override
    public void processHierarchy(Row requestRow, PrimaryKey requestPrimaryKey, Row responseRow, String objectName, InputPayloadMetadata inputPayloadMetadata, ApplicationMetadata appMetadata) {
        JsonObject inputJson = requestRow.getJsonElement().getAsJsonObject();
        JsonObject responseJson = responseRow.getJsonElement().getAsJsonObject();
        ObjectMetadata objectMetadata = appMetadata.getObjectMetadata(objectName);
        SupportedObjectDto supportedObjectDto = objectMetadata.getSupportedObjectHierarchy().get(requestRow.getMetadata().getAction());
        RowUtil.setResponseRowWithPrimeryKey(objectMetadata.getName(), requestPrimaryKey, responseRow, inputPayloadMetadata);
        RowUtil.setResponseRowWithForeignKey(objectMetadata.getName(), objectMetadata, inputJson, responseRow, inputPayloadMetadata);
        RowUtil.putReconciledColumn(responseJson, requestPrimaryKey);
        this.processChildHierarchy(requestRow, inputPayloadMetadata, responseJson, appMetadata, supportedObjectDto);
    }

    protected void processChildHierarchy(Row parentRequestRow, InputPayloadMetadata inputPayloadMetadata, JsonObject responseJson, ApplicationMetadata appMetadata, SupportedObjectDto supportedObjectDto) {
        if (supportedObjectDto != null) {
            List<ActionsDto> actionsDto = supportedObjectDto.getActions();
            for (ActionsDto actionDto : actionsDto) {
                List<SupportedObjectDto> supportedObjectDtoList = actionDto.getSupportedObjects();
                for (SupportedObjectDto childSupportedObjectDto : supportedObjectDtoList) {
                    String childObjectName = childSupportedObjectDto.getName();
                    this.processChildResponseHier(parentRequestRow, inputPayloadMetadata, responseJson, appMetadata, childObjectName);
                }
            }
        }
    }

    protected void processChildResponseHier(Row parentRequestRow, InputPayloadMetadata inputPayloadMetadata, JsonObject responseJson, ApplicationMetadata appMetadata, String childObjectName) {
        if (parentRequestRow.getValue(childObjectName) != null && responseJson.get(childObjectName) != null) {
            JsonArray inputChildJsonArray = parentRequestRow.getValue(childObjectName).getJsonElement().getAsJsonArray();
            JsonArray responseChildJsonArray = responseJson.get(childObjectName).getAsJsonArray();
            Iterator inputChildJsonIterator = inputChildJsonArray.iterator();
            Iterator responseChildJsonIterator = responseChildJsonArray.iterator();
            while (inputChildJsonIterator.hasNext() && responseChildJsonIterator.hasNext()) {
                JsonObject inputChildJson = ((JsonElement)inputChildJsonIterator.next()).getAsJsonObject();
                ObjectMetadata childObjectMetadata = appMetadata.getObjectMetadata(childObjectName);
                Row childRequestRow = this.createChildRequestRow(childObjectMetadata, inputChildJson, parentRequestRow);
                JsonObject responseChildJson = ((JsonElement)responseChildJsonIterator.next()).getAsJsonObject();
                try {
                    Row childResponseRow = RowUtil.createResponseRow(childRequestRow, responseChildJson);
                    responseChildJson.add("_metadata", (JsonElement)childResponseRow.getMetadata().getAsJsonObject());
                    OperationEnum childOperationEnum = OperationEnum.valueOf(OperationEnum.valueOf(childRequestRow.getMetadata().getAction()).name());
                    PrimaryKey childPrimaryKey = PrimaryKey.extractPK(childObjectMetadata.getPrimaryKeys(), inputChildJson);
                    childOperationEnum.getStrategy().processHierarchy(childRequestRow, childPrimaryKey, childResponseRow, childObjectName, inputPayloadMetadata, appMetadata);
                }
                catch (DataAccessException e) {
                    LOGGER.debug((Object)("Unable to process the response for row " + childRequestRow.getMetadata().getRowId() + e));
                }
            }
        }
    }

    @Override
    protected Row prepareResponseRow(Row inputRow, JsonObject responseJsonObject) throws DataAccessException {
        RowUtil.copyMetaDataFromInputIfNotPresentInResponse(inputRow, responseJsonObject);
        Row responseRow = RowUtil.createResponseRow(inputRow, responseJsonObject);
        return responseRow;
    }
}

