/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.appservices.common.constants.ObjectParamEnum;
import com.konylabs.middleware.appservices.custom.processors.exception.FabricCustomCodeException;
import com.konylabs.middleware.classloader.ClassLoaderUtils;
import com.konylabs.middleware.cloud.CloudUtils;
import com.konylabs.middleware.common.ActionType;
import com.konylabs.middleware.customconflict.ConflictContext;
import com.konylabs.middleware.customconflict.ConflictResolutionResult;
import com.konylabs.middleware.customconflict.CustomConflictResolver;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.objservices.runtime.ConflictType;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.SoftDeleteFieldObject;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CustomConflictUtil {
    private static final Logger LOGGER = Logger.getLogger(CustomConflictUtil.class);

    public static ConflictResolutionResult resolveConflict(Row clientRow, Row serverRow, InputPayloadMetadata inputPayloadMetadata, boolean isSoftDeleted, ConflictType conflictType) throws ConnectorException, FabricCustomCodeException {
        if (CloudUtils.isCustomCodeEnabled()) {
            LOGGER.debug((Object)"CustomConflictProcessor Called");
            Map<String, String> configParams = clientRow.getMetadata().getObjectMetadata().getObjectParamMap();
            String conflictName = configParams.get(ObjectParamEnum.conflict_policy_class.name());
            if (StringUtils.isNotBlank((String)conflictName)) {
                String jarModule = MiddlewareUtils.getJarModuleName(clientRow);
                Object customConflictObj = ClassLoaderUtils.getCustomClassInstance(clientRow.getMetadata().getAppVersion().getAppId(), jarModule, conflictName);
                if (customConflictObj instanceof CustomConflictResolver) {
                    ConflictContext conflictCtxt = CustomConflictUtil.getConflictContext(clientRow, serverRow, inputPayloadMetadata, isSoftDeleted, conflictType);
                    LOGGER.debug((Object)("Processing custom conflict: " + conflictName));
                    return CustomConflictUtil.processJavaCustomConflict(clientRow, serverRow, conflictCtxt, (CustomConflictResolver)customConflictObj);
                }
                CustomConflictUtil.logAndThrowError(clientRow, conflictName);
            } else {
                CustomConflictUtil.logAndThrowError(clientRow, conflictName);
            }
        } else {
            CustomConflictUtil.logAndThrowCustomCodeNotSupportedError(clientRow);
        }
        return null;
    }

    public static ConflictContext getConflictContext(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, boolean isSoftDeleted, ConflictType conflictType) {
        SoftDeleteFieldObject sd;
        ConflictContext ctxt = new ConflictContext();
        ObjectMetadata objMetdata = requestRow.getMetadata().getObjectMetadata();
        AppVersion appver = objMetdata.getAppMetadata().getApplicationVersion();
        ctxt.setServiceId(appver.getAppId());
        ctxt.setVersion(appver.getVersion());
        ctxt.setServerDataSoftDeleted(isSoftDeleted);
        ctxt.setConflictType(conflictType.name());
        ctxt.setClientAction(ActionType.getActionType((String)requestRow.getMetadata().getAction()));
        ctxt.setServerAction(ActionType.getActionType((String)responseRow.getMetadata().getAction()));
        ctxt.setObjectId(objMetdata.getName());
        ctxt.setOffline(objMetdata.isOffline());
        ctxt.setFields(objMetdata.getFieldMetadataMap().keySet());
        ctxt.setPrimaryKeys(objMetdata.getPrimaryKeys());
        if (objMetdata.getDeltaContextfieldObj() != null) {
            ctxt.setDeltaContextFieldName(objMetdata.getDeltaContextfieldObj().getDeltaContextFieldName());
        }
        if ((sd = objMetdata.getSoftDeleteFieldObj()) != null) {
            ctxt.setDeltaContextFieldName(sd.getSoftDeleteFieldName());
            ctxt.setSoftDeleteDeletedValue(sd.getDeletedValue());
            ctxt.setSoftDeleteActiveValue(sd.getActiveValue());
        }
        ctxt.setQueryParams(inputPayloadMetadata.getQueryParamMap());
        return ctxt;
    }

    private static ConflictResolutionResult processJavaCustomConflict(Row clientData, Row serverData, ConflictContext conflictCtxt, CustomConflictResolver customConflictObj) {
        ConflictResolutionResult cr = null;
        ActionType defaultAction = ActionType.update;
        switch (ConflictType.valueOf(conflictCtxt.getConflictType())) {
            case CLIENT_CREATE_SERVER_EXISTS: {
                cr = customConflictObj.resolveClientCreateServerExists(clientData.getJsonElement().getAsJsonObject(), serverData.getJsonElement().getAsJsonObject(), conflictCtxt);
                cr = CustomConflictUtil.validateConflictResult(clientData, cr, defaultAction, conflictCtxt.getConflictType());
                break;
            }
            case CLIENT_UPDATE_SERVER_UPDATE: {
                cr = customConflictObj.resolveClientUpdateServerUpdate(clientData.getJsonElement().getAsJsonObject(), serverData.getJsonElement().getAsJsonObject(), conflictCtxt);
                break;
            }
            case CLIENT_UPDATE_SERVER_DELETE: {
                cr = customConflictObj.resolveClientUpdateServerDelete(clientData.getJsonElement().getAsJsonObject(), serverData.getJsonElement().getAsJsonObject(), conflictCtxt);
                break;
            }
            case CLIENT_DELETE_SERVER_UPDATE: {
                cr = customConflictObj.resolveClientDeleteServerUpdate(clientData.getJsonElement().getAsJsonObject(), serverData.getJsonElement().getAsJsonObject(), conflictCtxt);
                defaultAction = ActionType.delete;
            }
        }
        cr = CustomConflictUtil.validateConflictResult(clientData, cr, defaultAction, conflictCtxt.getConflictType());
        if (LOGGER.isDebugEnabled()) {
            String action = cr.getActionType() != null ? cr.getActionType().name() : "NoActionSet";
            LOGGER.debug((Object)String.format("Custom conflict returned with action [%s] and submittoserver [%s]", action, cr.isSubmitToServer()));
        }
        return cr;
    }

    private static ConflictResolutionResult validateConflictResult(Row clientData, ConflictResolutionResult cr, ActionType action, String conflictType) {
        if (cr == null) {
            LOGGER.error((Object)String.format("For Conflict [%s], No conflictResolutionResult returned for object [%s]", conflictType, clientData.getMetadata().getObjectName()));
            cr = new ConflictResolutionResult(clientData.getJsonElement().getAsJsonObject(), action, true);
        }
        return cr;
    }

    private static void logAndThrowError(Row clientData, String conflictName) throws FabricCustomCodeException {
        LOGGER.warn((Object)String.format("CustomConflict for object [%s] with name [%s] is not valid", clientData.getMetadata().getObjectName(), conflictName));
        String errMsg = FabricCustomCodeException.getErrorMessage("16002", conflictName, clientData.getMetadata().getObjectName());
        throw new FabricCustomCodeException("16002", errMsg);
    }

    private static void logAndThrowCustomCodeNotSupportedError(Row clientData) throws FabricCustomCodeException {
        LOGGER.warn((Object)String.format("Customcode is not supported in this environment for object [%s]", clientData.getMetadata().getObjectName()));
        String errMsg = FabricCustomCodeException.getErrorMessageForKey((String)"16003");
        throw new FabricCustomCodeException("16003", errMsg);
    }
}

