/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.util.DownloadResponseFormatter;
import com.konylabs.middleware.appservices.common.util.ObjectServicesGetResponseFormatter;
import com.konylabs.middleware.appservices.servlet.AppServicesAsyncHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.controller.AppServicesAsyncHandlerChain;
import com.konylabs.middleware.objservices.runtime.ResponseDeltaContextDTO;
import com.konylabs.middleware.objservices.runtime.response.GetResponse;
import com.konylabs.middleware.request.builder.ObjectServiceResponseData;
import com.konylabs.middleware.request.parser.RequestData;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DownloadAsyncHandler
implements AppServicesAsyncHandler<Object>,
AppServicesAsyncHandlerChain {
    private static final Logger LOGGER = Logger.getLogger(DownloadAsyncHandler.class);

    DownloadAsyncHandler() {
    }

    @Override
    public void onSuccess(HttpServletRequest request, HttpServletResponse response, Object result, Context context) {
        long responseProcessingstartTime = System.currentTimeMillis();
        RequestData requestData = (RequestData)context.get("requestData");
        GetResponse objectServiceresp = (GetResponse)context.get("ObjectServiceresp");
        JsonObject finalResponse = null;
        Context parentContext = (Context)context.get("parentContext");
        AppServicesAsyncHandler<ObjectServiceResponseData> appServicesAsyncHandler = this.getParentHandler(parentContext);
        ResponseDeltaContextDTO deltaContextObj = (ResponseDeltaContextDTO)context.get("deltaContextObj");
        if (requestData.isRequestAtObjectServiceLevel()) {
            finalResponse = this.getResponse(requestData, objectServiceresp, deltaContextObj, false, result);
        } else {
            try {
                finalResponse = DownloadResponseFormatter.processJsonResponse(result, requestData, requestData.getObjectMetadata(), deltaContextObj);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception occurred while parsing response ", (Throwable)e);
                appServicesAsyncHandler.onError(request, response, e, parentContext);
            }
        }
        MetricsUtils.addResponseInfoToMetricsBean(request, responseProcessingstartTime, finalResponse, objectServiceresp.getTotalRecords(), null, null);
        ObjectServiceResponseData objectServiceResponseData = this.prepareJsonResponseData(finalResponse);
        appServicesAsyncHandler.onSuccess(request, response, objectServiceResponseData, parentContext);
    }

    @Override
    public void onError(HttpServletRequest request, HttpServletResponse response, Exception exception, Context context) {
        RequestData requestData = (RequestData)context.get("requestData");
        GetResponse objectServiceresp = (GetResponse)context.get("ObjectServiceresp");
        ResponseDeltaContextDTO deltaContextObj = (ResponseDeltaContextDTO)context.get("deltaContextObj");
        Context parentContext = (Context)context.get("parentContext");
        AppServicesAsyncHandler<ObjectServiceResponseData> appServicesAsyncHandler = this.getParentHandler(parentContext);
        if (requestData.isRequestAtObjectServiceLevel()) {
            JsonObject finalResponse = this.getResponse(requestData, objectServiceresp, deltaContextObj, true, null);
            ObjectServiceResponseData objectServiceResponseData = this.prepareJsonResponseData(finalResponse);
            MetricsUtils.addResponseInfoToMetricsBean(request, 0L, finalResponse, 0, exception.getMessage(), exception.getStackTrace().toString());
            appServicesAsyncHandler.onSuccess(request, response, objectServiceResponseData, parentContext);
        } else {
            LOGGER.error((Object)"Exception occurred while processing  request ", (Throwable)exception);
            appServicesAsyncHandler.onError(request, response, exception, parentContext);
        }
    }

    public AppServicesAsyncHandler<ObjectServiceResponseData> getParentHandler(Context parentContext) {
        return (AppServicesAsyncHandler)parentContext.get("handler");
    }

    private ObjectServiceResponseData prepareJsonResponseData(JsonObject finalResponse) {
        ObjectServiceResponseData objectServiceResponseData = new ObjectServiceResponseData();
        objectServiceResponseData.setResponseStream(finalResponse);
        return objectServiceResponseData;
    }

    private JsonObject getResponse(RequestData requestData, GetResponse responseObj, ResponseDeltaContextDTO deltaContextObj, boolean isError, Object result) {
        LOGGER.debug((Object)" Inside getResponse()");
        ObjectServicesGetResponseFormatter dr = new ObjectServicesGetResponseFormatter();
        JsonObject responsejson = dr.prepareJsonResponse(result, requestData, responseObj, deltaContextObj, isError);
        return responsejson;
    }
}

