/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.konylabs.middleware.appservices.common.helper.DataFoundationWSHelper;
import com.konylabs.middleware.appservices.common.util.DeltaContextUtil;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.exceptions.ObjectServicesException;
import com.konylabs.middleware.objservices.runtime.ResponseDeltaContextDTO;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.AbstractPayloadParser;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.ObjectServiceRequestData;
import com.konylabs.middleware.request.builder.PayloadParserUtil;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.parser.RequestData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DownloadPayloadParser
extends AbstractPayloadParser {
    private static final Logger LOGGER = Logger.getLogger(DownloadPayloadParser.class);

    public DownloadPayloadParser(HttpServletRequest httpServletRequest, RequestContext context, HttpServletResponse httpServletResponse, JsonElement totalPayload, Map<String, String> queryParams) {
        super(httpServletRequest, context, httpServletResponse, totalPayload, queryParams);
    }

    @Override
    public RequestData parse() throws AppRegistryException, MiddlewareException, Exception {
        LOGGER.debug((Object)" Inside GetPayloadParser()");
        ObjectServiceRequestData objectServiceRequestData = new ObjectServiceRequestData(this.context.getAppMetadata());
        InputPayloadMetadata payloadMetadata = new InputPayloadMetadata();
        payloadMetadata.setJsonQueryParam(this.getQueryParams());
        this.setDeltaContextFromPayload(objectServiceRequestData);
        this.setParamsToObjectServiceRequestData(objectServiceRequestData, payloadMetadata);
        if (StringUtils.isNotEmpty((String)this.getQueryParams().get("$batchsize"))) {
            this.validateThatBatchSizeIsNumber(this.getQueryParams().get("$batchsize"));
        }
        if (this.context.isResponsePassThrough()) {
            this.prepareDcrForResponsePassthrough(objectServiceRequestData, payloadMetadata);
        } else {
            List<String> objectsTobeDownloaded = this.getObjectsTobeDownloaded(objectServiceRequestData);
            if (objectsTobeDownloaded.size() <= 0) {
                String errorMessage = ObjectServicesException.getErrorMessage("14050");
                String errorCode = "14050";
                throw new ObjectServicesException(errorCode, errorMessage);
            }
            payloadMetadata.setDownloadbleObjectList(objectsTobeDownloaded);
        }
        return objectServiceRequestData;
    }

    private void validateThatBatchSizeIsNumber(String batchSize) throws ObjectServicesException {
        try {
            Integer.parseInt(batchSize);
        }
        catch (Exception e) {
            String errorMessage = ObjectServicesException.getErrorMessage("20022", batchSize);
            String errorCode = "20022";
            throw new ObjectServicesException(errorCode, errorMessage, e);
        }
    }

    private void prepareDcrForResponsePassthrough(ObjectServiceRequestData objectServiceRequestData, InputPayloadMetadata payloadMetadata) throws IOException {
        HashMap<String, String[]> urlParams = new HashMap<String, String[]>();
        if (this.httpServletRequest.getParameterMap() != null) {
            urlParams.putAll(this.httpServletRequest.getParameterMap());
        }
        DataControllerRequest jsonDcr = DataFoundationWSHelper.createDcr(this.httpServletRequest, urlParams, objectServiceRequestData);
        payloadMetadata.setDCR(jsonDcr);
    }

    private void setDeltaContextFromPayload(ObjectServiceRequestData objectServiceRequestData) {
        if (this.getTotalPayload() != null && this.getTotalPayload().isJsonObject()) {
            JsonElement deltaContextJE;
            JsonObject rawJsonPayload = this.getTotalPayload().getAsJsonObject();
            if (rawJsonPayload.has("delta_context") && !(deltaContextJE = rawJsonPayload.get("delta_context")).isJsonNull()) {
                objectServiceRequestData.putParam("delta_context", rawJsonPayload.get("delta_context").getAsJsonObject());
            }
        } else {
            String deltaContext = this.getQueryParams().get("delta_context");
            if (StringUtils.isNotBlank((String)deltaContext)) {
                objectServiceRequestData.putParam("delta_context", new JsonParser().parse(deltaContext).getAsJsonObject());
            }
        }
    }

    private List<String> getObjectsTobeDownloaded(ObjectServiceRequestData objectServiceRequestData) {
        ArrayList<String> objectsTobeDownloaded = new ArrayList<String>();
        ResponseDeltaContextDTO deltaContextObj = new DeltaContextUtil().prepareDeltaContextObj((JsonObject)objectServiceRequestData.getParam("delta_context"));
        if (this.context.isObjectLevelCall()) {
            objectsTobeDownloaded.add(this.context.getObjectId());
        } else {
            boolean downloadMode = false;
            if (this.getQueryParams().get("offline") != null) {
                downloadMode = Boolean.parseBoolean(this.getQueryParams().get("offline").toString());
            }
            PayloadParserUtil.getObjectsToBeDownloaded(this.context.getAppMetadata(), deltaContextObj, downloadMode, objectsTobeDownloaded);
        }
        return objectsTobeDownloaded;
    }

    private void setParamsToObjectServiceRequestData(ObjectServiceRequestData objectServiceRequestData, InputPayloadMetadata payloadMetadata) {
        objectServiceRequestData.putCustomParam("objectID", this.context.getObjectId());
        objectServiceRequestData.putCustomParam("appID", this.context.getAppId());
        objectServiceRequestData.putCustomParam(RequestData.URL_PARAM_KEYS.isObjectServiceRequest.name(), !this.context.isObjectLevelCall());
        objectServiceRequestData.setQueryParamMap(this.getQueryParams());
        objectServiceRequestData.setAppVersion(this.context.getAppVersion());
        objectServiceRequestData.setHttpServletRequest(this.httpServletRequest);
        objectServiceRequestData.setHttpServletResponse(this.httpServletResponse);
        objectServiceRequestData.setInputPayloadMetadata(payloadMetadata);
        objectServiceRequestData.setAppId(this.context.getAppId());
        objectServiceRequestData.setServiceId(this.context.getServiceId());
    }
}

