/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.konylabs.middleware.appservices.common.util.DeltaContextUtil;
import com.konylabs.middleware.appservices.servlet.AppServicesAsyncHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.controller.AppServicesAsyncHandlerChain;
import com.konylabs.middleware.objservices.runtime.ResponseDeltaContextDTO;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.response.GetResponse;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.MetricsBeanUtils;
import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DownloadProcessingAsyncHandler
implements AppServicesAsyncHandler<Object>,
AppServicesAsyncHandlerChain {
    private static final Logger LOGGER = Logger.getLogger(DownloadProcessingAsyncHandler.class);

    DownloadProcessingAsyncHandler() {
    }

    @Override
    public void onSuccess(HttpServletRequest request, HttpServletResponse response, Object result, Context context) {
        RequestData requestData = (RequestData)context.get("requestData");
        String currentObj = (String)context.get("currentObj");
        String nextObject = (String)context.get("nextObject");
        int batchSize = (Integer)context.get("batchSize");
        ResponseDeltaContextDTO deltaContextObj = (ResponseDeltaContextDTO)context.get("deltaContextObj");
        GetResponse objectServiceresp = (GetResponse)context.get("objectServiceresp");
        ObjectMetadata objMetadata = requestData.getAppMetadata().getObjectMetadata(currentObj);
        CountDownLatch latch = (CountDownLatch)context.get("latch");
        Context parentContext = (Context)context.get("parentContext");
        AppServicesAsyncHandler<Object> requestDownloadHandler = this.getParentHandler(parentContext);
        try {
            this.processResults(requestData, result, currentObj, nextObject, batchSize, deltaContextObj, objectServiceresp, objMetadata);
            latch.countDown();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Exception while processing the response at objectservices level", (Throwable)ex);
            requestDownloadHandler.onError(request, response, ex, parentContext);
            latch.countDown();
        }
    }

    @Override
    public void onError(HttpServletRequest request, HttpServletResponse response, Exception exception, Context context) {
        GetResponse objectServiceresp = (GetResponse)context.get("objectServiceresp");
        String currentObj = (String)context.get("currentObj");
        ResponseDeltaContextDTO deltaContextObj = (ResponseDeltaContextDTO)context.get("deltaContextObj");
        CountDownLatch latch = (CountDownLatch)context.get("latch");
        Context parentContext = (Context)context.get("parentContext");
        AppServicesAsyncHandler<Object> requestDownloadHandler = this.getParentHandler(parentContext);
        try {
            LOGGER.error((Object)"Exception while invoking the service", (Throwable)exception);
            this.processExceptionOnResultOrNextObjectCall(objectServiceresp, currentObj, exception, true, deltaContextObj);
            requestDownloadHandler.onError(request, response, exception, parentContext);
            latch.countDown();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Exception while processing the error response", (Throwable)ex);
            requestDownloadHandler.onError(request, response, ex, parentContext);
            latch.countDown();
        }
    }

    public void processExceptionOnResultOrNextObjectCall(GetResponse objectServiceresp, String nextObjectName, Exception ex, boolean resetCurentObj, ResponseDeltaContextDTO deltaContextObj) {
        LOGGER.debug((Object)" Inside processExceptionOnResultOrNextObjectCall()");
        LOGGER.error((Object)"Exception while processing the next get call", (Throwable)ex);
        if (nextObjectName != null) {
            Object obj = objectServiceresp.getResponseMap().get(nextObjectName);
            JsonObject jsonObj = new JsonObject();
            if (obj != null) {
                jsonObj = (JsonObject)obj;
            }
            jsonObj.addProperty("errmsg", ex.getMessage());
            objectServiceresp.getResponseMap().put(nextObjectName, jsonObj);
            objectServiceresp.setHasMoreChangesAvailable(true);
            if (resetCurentObj && deltaContextObj != null) {
                deltaContextObj.setCurobj(nextObjectName);
            }
        } else {
            objectServiceresp.setErrMessage(ex.getMessage());
        }
        objectServiceresp.setHasMoreChangesAvailable(true);
    }

    public void processResults(RequestData requestData, Object result, String currentObj, String nextObject, int batchSize, ResponseDeltaContextDTO deltaContextObj, GetResponse objectServiceresp, ObjectMetadata objMetadata) {
        LOGGER.debug((Object)" Inside processResults()");
        if (result != null) {
            objectServiceresp.setLastInvocationResult(result);
            JsonObject middlewareResponse = (JsonObject)new JsonParser().parse((String)result);
            boolean hasMoreRecords = false;
            if (middlewareResponse.get("opstatus").getAsInt() != 0) {
                objectServiceresp.setContinueDownload(false);
            } else {
                if (middlewareResponse.has("hasMoreRecords")) {
                    hasMoreRecords = !middlewareResponse.get("hasMoreRecords").isJsonNull() ? middlewareResponse.get("hasMoreRecords").getAsBoolean() : false;
                }
                int totalRecords = 0;
                totalRecords = middlewareResponse.has("recordCount") ? middlewareResponse.get("recordCount").getAsInt() : (middlewareResponse.has(currentObj) && middlewareResponse.get(currentObj).isJsonArray() ? middlewareResponse.get(currentObj).getAsJsonArray().size() : 1);
                objectServiceresp.updateTotalRecords(totalRecords);
                new DeltaContextUtil().updateDeltaContextFromResponse(deltaContextObj, requestData, middlewareResponse, objMetadata);
                this.updateResponseBasedOnBatchSize(currentObj, nextObject, batchSize, deltaContextObj, objectServiceresp, hasMoreRecords, totalRecords);
            }
            if (middlewareResponse.has("errmsg")) {
                MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)requestData.getInputPayloadMetadata().getHttpServletRequest(), (String)"errmsg", (Object)middlewareResponse.get("errmsg").getAsString());
            }
            objectServiceresp.getResponseMap().put(currentObj, middlewareResponse);
        }
    }

    public void updateResponseBasedOnBatchSize(String currentObj, String nextObject, int batchSize, ResponseDeltaContextDTO deltaContextObj, GetResponse objectServiceresp, boolean hasMoreRecords, int totalRecords) {
        int remainingBatchSpace = -1;
        if (batchSize > 0) {
            remainingBatchSpace = batchSize - totalRecords;
            objectServiceresp.setBatchSize(remainingBatchSpace);
        }
        if (batchSize < 0) {
            if (null == nextObject) {
                deltaContextObj.setCurobj(null);
                objectServiceresp.setHasMoreChangesAvailable(false);
            } else {
                objectServiceresp.setContinueDownload(true);
            }
        } else if (remainingBatchSpace > 0 && hasMoreRecords) {
            deltaContextObj.setCurobj(currentObj);
            objectServiceresp.setHasMoreChangesAvailable(true);
        } else if (remainingBatchSpace > 0 && !hasMoreRecords) {
            if (null == nextObject) {
                deltaContextObj.setCurobj(null);
                objectServiceresp.setHasMoreChangesAvailable(false);
            } else {
                objectServiceresp.setContinueDownload(true);
            }
        } else if (remainingBatchSpace <= 0 && hasMoreRecords) {
            deltaContextObj.setCurobj(currentObj);
            objectServiceresp.setHasMoreChangesAvailable(true);
        } else if (remainingBatchSpace <= 0 && !hasMoreRecords) {
            if (null == nextObject) {
                deltaContextObj.setCurobj(null);
                objectServiceresp.setHasMoreChangesAvailable(false);
            } else {
                deltaContextObj.setCurobj(nextObject);
                objectServiceresp.setHasMoreChangesAvailable(true);
            }
        }
    }

    public AppServicesAsyncHandler<Object> getParentHandler(Context parentContext) {
        return (AppServicesAsyncHandler)parentContext.get("handler");
    }
}

