/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.helper.DataFoundationWSHelper;
import com.konylabs.middleware.appservices.common.util.DeltaContextUtil;
import com.konylabs.middleware.appservices.servlet.AppServicesAsyncHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.objservices.runtime.ResponseDeltaContextDTO;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.response.GetResponse;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.request.builder.DownloadAsyncHandler;
import com.konylabs.middleware.request.builder.DownloadProcessingAsyncHandler;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.RequestProcessingStrategy;
import com.konylabs.middleware.request.parser.RequestData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DownloadProcessingStrategy
implements RequestProcessingStrategy {
    private static final Logger LOGGER = Logger.getLogger(DownloadProcessingStrategy.class);
    private static final DownloadProcessingAsyncHandler requestDownloadHandler = new DownloadProcessingAsyncHandler();
    private static final DownloadAsyncHandler downloadRequestHandler = new DownloadAsyncHandler();

    @Override
    public void process(InputPayloadMetadata inputPayloadMetadata, Context parentContext) {
        LOGGER.debug((Object)" Inside process()");
        try {
            RequestData requestData = inputPayloadMetadata.getRequestData();
            HashMap<String, String[]> originalURLParams = new HashMap<String, String[]>();
            if (inputPayloadMetadata.getHttpServletRequest().getParameterMap() != null) {
                originalURLParams.putAll(inputPayloadMetadata.getHttpServletRequest().getParameterMap());
            }
            HashMap<String, String> originalQueryParams = new HashMap<String, String>();
            originalQueryParams.putAll(requestData.getQueryParamMap());
            ResponseDeltaContextDTO deltaContextObj = new DeltaContextUtil().getDeltaContextObjectFromRequest(requestData);
            int batchSize = -1;
            if (requestData.getQueryParamMap().get("$batchsize") != null) {
                batchSize = Integer.parseInt(requestData.getQueryParamMap().get("$batchsize").toString());
            }
            GetResponse objectServiceResp = new GetResponse();
            Context context = new Context();
            context.put("parentContext", (Object)parentContext);
            context.put("requestData", (Object)requestData);
            context.put("deltaContextObj", (Object)deltaContextObj);
            context.put("ObjectServiceresp", (Object)objectServiceResp);
            context.put("handler", (Object)downloadRequestHandler);
            for (int i = 0; i < inputPayloadMetadata.getDownloadbleObjectList().size(); ++i) {
                String objectToBeDownloaded = inputPayloadMetadata.getDownloadbleObjectList().get(i);
                String nextObjectTobeDownloaded = null;
                if (i + 1 != inputPayloadMetadata.getDownloadbleObjectList().size()) {
                    nextObjectTobeDownloaded = inputPayloadMetadata.getDownloadbleObjectList().get(i + 1);
                }
                String serviceid = this.getServiceID(requestData.getAppMetadata(), objectToBeDownloaded, OperationEnum.get.name());
                requestData.setServiceId(serviceid);
                this.executeDownload(objectToBeDownloaded, nextObjectTobeDownloaded, batchSize, inputPayloadMetadata, context, deltaContextObj, objectServiceResp, originalQueryParams, originalURLParams);
                if (!objectServiceResp.isContinueDownload()) break;
                batchSize = objectServiceResp.getBatchSize();
                objectServiceResp.setContinueDownload(false);
            }
            downloadRequestHandler.onSuccess(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getHttpServletResponse(), objectServiceResp.getLastInvocationResult(), context);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Exception while processing the get Request", (Throwable)ex);
            ((AppServicesAsyncHandler)parentContext.get("handler")).onError(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getHttpServletResponse(), ex, parentContext);
        }
    }

    public void executeDownload(String currentObj, String nextObject, int batchSize, InputPayloadMetadata inputPayloadMetadata, Context parentContext, ResponseDeltaContextDTO deltaContextObj, GetResponse objectServiceresp, Map<String, String> originalQueryParams, Map<String, String[]> originalURLParams) {
        LOGGER.debug((Object)" Inside executeDownload()");
        try {
            RequestData requestData = inputPayloadMetadata.getRequestData();
            ObjectMetadata objMetadata = requestData.getAppMetadata().getObjectMetadata(currentObj);
            HashMap<String, String[]> urlParams = new HashMap<String, String[]>();
            urlParams.putAll(originalURLParams);
            HashMap<String, String> queryParamsMap = new HashMap<String, String>();
            queryParamsMap.putAll(originalQueryParams);
            requestData.setQueryParamMap(queryParamsMap);
            if (deltaContextObj != null) {
                deltaContextObj.setCurobj(currentObj);
                new DeltaContextUtil().processDeltaContext(requestData, deltaContextObj, objMetadata, urlParams);
            }
            if (batchSize > 0) {
                urlParams.put("$batchsize", new String[]{String.valueOf(batchSize)});
            }
            requestData.putCustomParam("objectID", currentObj);
            CountDownLatch latch = new CountDownLatch(1);
            Context context = new Context();
            context.put("parentContext", (Object)parentContext);
            context.put("latch", (Object)latch);
            context.put("downloadProcessingStrategy", (Object)this);
            context.put("requestData", (Object)requestData);
            context.put("currentObj", (Object)currentObj);
            context.put("nextObject", (Object)nextObject);
            context.put("batchSize", (Object)batchSize);
            context.put("handler", (Object)requestDownloadHandler);
            context.put("objectServiceresp", (Object)objectServiceresp);
            context.put("deltaContextObj", (Object)deltaContextObj);
            DataFoundationWSHelper.executeDownload(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getRequestData(), inputPayloadMetadata.getHttpServletResponse(), objMetadata, urlParams, context);
            this.waitForResults(latch);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Exception while invoking the service", (Throwable)ex);
            requestDownloadHandler.processExceptionOnResultOrNextObjectCall(objectServiceresp, currentObj, ex, false, deltaContextObj);
            requestDownloadHandler.onError(inputPayloadMetadata.getHttpServletRequest(), inputPayloadMetadata.getHttpServletResponse(), ex, parentContext);
        }
    }

    public String getServiceID(ApplicationMetadata appMetadata, String objectId, Object operationId) throws AppRegistryException {
        LOGGER.debug((Object)" Inside getServiceID()");
        if (!appMetadata.getOperatonMapingByObjectId(objectId).containsKey(operationId)) {
            String errorMessage = AppRegistryException.getErrorMessageForKey((String)"operation_not_found");
            String errorCode = "14041";
            throw new AppRegistryException(errorCode, errorMessage);
        }
        String serviceId = appMetadata.getOperatonMapingByObjectId(objectId).get(operationId).getServiceid();
        if (StringUtils.isBlank((String)serviceId)) {
            String errorMessage = AppRegistryException.getErrorMessageForKey((String)"service_not_configured_operation");
            String errorCode = "14042";
            throw new AppRegistryException(errorCode, errorMessage);
        }
        return serviceId;
    }

    protected void waitForResults(CountDownLatch latch) throws InterruptedException {
        LOGGER.debug((Object)"Submitted the operation and waiting for results.");
        latch.await(5L, TimeUnit.MINUTES);
    }
}

