/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.servlet.RowUploadHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.request.builder.ConflictUploadStrategy;
import com.konylabs.middleware.request.builder.GetAfterResolverAsyncHandler;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.Row;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetAfterConflictResolver
implements RowUploadHandler {
    private final Row originalRequestRow;
    private ConflictUploadStrategy uploadStrategy;
    private InputPayloadMetadata inputPayloadMetadata;
    private final RowUploadHandler asyncHandler;
    private static final GetAfterResolverAsyncHandler rowUploadhandler = new GetAfterResolverAsyncHandler();

    public GetAfterConflictResolver(ConflictUploadStrategy uploadStrategy, InputPayloadMetadata inputPayloadMetadata, RowUploadHandler asyncHandler, Row requestRow) {
        this.uploadStrategy = uploadStrategy;
        this.inputPayloadMetadata = inputPayloadMetadata;
        this.asyncHandler = asyncHandler;
        this.originalRequestRow = requestRow;
    }

    public RowUploadHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    @Override
    public void onSuccess(HttpServletRequest request, HttpServletResponse response, Row result, Context context) {
        Row responseRow = new Row(result.getJsonElement().getAsJsonObject());
        responseRow.setMetadata(result.getMetadata());
        Context parentContext = (Context)context.get("parentContext");
        context.put("responseRow", (Object)responseRow);
        if (!OperationEnum.delete.name().equalsIgnoreCase(this.originalRequestRow.getMetadata().getAction())) {
            context.put("handler", (Object)rowUploadhandler);
            this.uploadStrategy.doGet(result, this.inputPayloadMetadata, rowUploadhandler, this.originalRequestRow, context);
        } else {
            this.asyncHandler.onSuccess(request, response, result, parentContext);
        }
    }

    @Override
    public void onError(HttpServletRequest request, HttpServletResponse response, Exception exception, Context context) {
        Context parentContext = (Context)context.get("parentContext");
        this.asyncHandler.onError(request, response, exception, parentContext);
    }

    @Override
    public void onFailure(HttpServletRequest request, HttpServletResponse response, Row result, Context context) {
        Context parentContext = (Context)context.get("parentContext");
        Row inputRow = (Row)parentContext.get("requestRow");
        inputRow.getMetadata().setErrMsg(result.getMetadata().getErrMsg());
        inputRow.getMetadata().setOpstatus(result.getMetadata().getOpstatus());
        this.asyncHandler.onFailure(request, response, result, parentContext);
    }
}

