/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.kony.adapter.DataAdapterFactory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.common.KHttpServletRequestWrapper;
import com.konylabs.middleware.common.KHttpServletResponseWrapper;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.request.builder.AbstractPayloadParser;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IntegrationServicePayloadParser
extends AbstractPayloadParser {
    private static final Logger LOGGER = Logger.getLogger(IntegrationServicePayloadParser.class);

    public IntegrationServicePayloadParser(HttpServletRequest httpServletRequest, RequestContext context, HttpServletResponse httpServletResponse) {
        super(httpServletRequest, context, httpServletResponse);
    }

    @Override
    public RequestData parse() throws AppRegistryException {
        ApplicationMetadata appMetadata;
        LOGGER.debug((Object)" Inside parse()");
        String appId = this.context.getAppId();
        String serviceId = this.context.getServiceId();
        boolean isRequestPassthrough = false;
        boolean isHeaderPassthrough = false;
        boolean isResponsePassthrough = false;
        if (StringUtils.isNotBlank((String)appId) && StringUtils.isNotBlank((String)serviceId) && (appMetadata = (ApplicationMetadata)this.context.getAppCache().getAppMetadata(new AppVersion(appId, this.context.getApiVersion()))) != null) {
            Service service;
            Service service2 = service = appMetadata.getServiceMetadata(serviceId) != null ? appMetadata.getServiceMetadata(serviceId).getService() : null;
            if (service != null) {
                String adapterType = service.getServiceConfig().getConfigParamValue("adaptertype");
                if (DataAdapterFactory.DataAdapterType.KONY_INTEGRATION_SERVICE.toString().equals(adapterType)) {
                    service = MiddlewareUtils.getIntegrationServiceFromSDO(appId, serviceId, this.context.getApiVersion(), service);
                }
                isRequestPassthrough = MiddlewareUtils.isRequestPassThrough(service);
                isHeaderPassthrough = MiddlewareUtils.isHeadersPassThrough(service);
                isResponsePassthrough = MiddlewareUtils.isResponsePassThrough(service);
            }
        }
        KHttpServletRequestWrapper requestWrapper = MiddlewareUtils.getKHttpServletRequestWrapper(this.httpServletRequest, isRequestPassthrough);
        KHttpServletResponseWrapper responseWrapper = MiddlewareUtils.getKHttpServletResponseWrapper(this.httpServletResponse);
        this.context.setRequestPassThrough(isRequestPassthrough);
        if (!isResponsePassthrough) {
            isResponsePassthrough = "bytes".equals(requestWrapper.getParameter("type"));
        }
        if (StringUtils.isNotBlank((String)appId) && StringUtils.isNotBlank((String)serviceId)) {
            requestWrapper.setParameter("appID", appId);
            requestWrapper.setParameter("serviceID", serviceId);
        } else {
            appId = requestWrapper.getParameter("appID");
            serviceId = requestWrapper.getParameter("serviceID");
            this.context.setAppId(appId);
            this.context.setServiceId(serviceId);
        }
        requestWrapper.setHeader("X-Kony-API-Version", this.context.getApiVersion());
        requestWrapper.setParameter("current_appID", appId);
        requestWrapper.setParameter("curent_apiVersion", this.context.getApiVersion());
        requestWrapper.setParameter("current_serviceID", serviceId);
        RequestData requestData = new RequestData(this.context.getAppMetadata());
        requestData.setAppVersion(this.context.getAppVersion());
        requestData.setServiceId(serviceId);
        requestData.setAppId(appId);
        requestData.setRequestPassThrough(isRequestPassthrough);
        requestData.setHeaderPassThrough(isHeaderPassthrough);
        requestData.setResponsePassThrough(isResponsePassthrough);
        requestData.setHttpServletRequest((HttpServletRequest)requestWrapper);
        requestData.setHttpServletResponse((HttpServletResponse)responseWrapper);
        this.setChannel(requestWrapper, responseWrapper);
        return requestData;
    }

    private void setChannel(KHttpServletRequestWrapper requestWrapper, KHttpServletResponseWrapper responseWrapper) {
        LOGGER.debug((Object)"Converting the url query string to request parameters");
        String channel = requestWrapper.getParameter("channel");
        requestWrapper.setParameter("channel", channel != null && !channel.trim().isEmpty() ? channel : "rc");
        responseWrapper.setRequest((HttpServletRequest)requestWrapper);
        requestWrapper.setResponse((HttpServletResponse)responseWrapper);
    }
}

