/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.identityproviders.MBaaSIdentityProvider;
import com.konylabs.middleware.request.builder.AbstractRequestBuilder;
import com.konylabs.middleware.request.builder.IntegrationServicePayloadParser;
import com.konylabs.middleware.request.builder.PayloadParser;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.MetricsBeanUtils;
import com.konylabs.middleware.utilities.MobileFabricUtils;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class IntegrationServiceRequestBuilder
extends AbstractRequestBuilder {
    private static final Logger LOGGER = Logger.getLogger(IntegrationServiceRequestBuilder.class);

    @Override
    protected PayloadParser getPayloadParser() {
        return new IntegrationServicePayloadParser(this.httpServletRequest, this.requestContext, this.httpServletResponse);
    }

    @Override
    protected void addProcessingStrategy(PayloadParser payloadParser, RequestData requestData) {
    }

    @Override
    protected RequestData buildCore() throws Exception {
        LOGGER.debug((Object)"Inside buildCore of IntegrationServiceRequestBuilder");
        RequestData parsePayload = this.parsePayload();
        HttpServletRequest httpServletRequest = parsePayload.getAndRemoveHttpServletRequest();
        this.xssValidator.doXSSCheck(httpServletRequest, (ServletResponse)this.httpServletResponse);
        parsePayload.setHttpServletRequest(httpServletRequest);
        if (!MobileFabricUtils.isRequestRedirectionEnabled(this.requestContext.getAppId(), this.requestContext.getServiceId())) {
            parsePayload.setAppMetadata(this.requestContext.getAppMetadata());
            parsePayload.setMbaasGateWayWrapper(this.requestContext.getGateWayWrapper());
        }
        return parsePayload;
    }

    @Override
    protected void addServiceInfoToMetricsBean() {
        super.addServiceInfoToMetricsBean();
        String svcType = this.requestContext.getAppMetadata().getServiceMetadata(this.requestContext.getServiceId()).getService().getServiceType();
        svcType = MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.CompositeConnector.name().equalsIgnoreCase(svcType) || MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.LoopingConnector.name().equalsIgnoreCase(svcType) ? "orchestration" : "integration";
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)this.httpServletRequest, (String)"svctype", (Object)svcType);
    }
}

