/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.objservices.metadata.MetadataUtils;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.AbstractPayloadParser;
import com.konylabs.middleware.request.builder.ObjectServiceRequestData;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.parser.RequestData;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class MetadataPayloadParser
extends AbstractPayloadParser {
    private static final Logger LOGGER = Logger.getLogger(MetadataPayloadParser.class);

    public MetadataPayloadParser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RequestContext context) {
        super(httpServletRequest, context, httpServletResponse);
    }

    @Override
    public RequestData parse() throws AppRegistryException, MiddlewareException, Exception {
        LOGGER.debug((Object)" Inside parse()");
        ObjectServiceRequestData objectServiceRequestData = new ObjectServiceRequestData(this.context.getAppMetadata());
        objectServiceRequestData.setHttpServletRequest(this.httpServletRequest);
        objectServiceRequestData.setHttpServletResponse(this.httpServletResponse);
        objectServiceRequestData.setAppVersion(this.context.getAppVersion());
        objectServiceRequestData.putCustomParam("objectID", this.context.getObjectId());
        objectServiceRequestData.putCustomParam("X-Kony-Service-Version", MetadataUtils.getServiceVersionForMetadata(this.httpServletRequest.getHeader("X-Kony-Service-Version")));
        ObjectServiceUtil.setQueryParams(this.httpServletRequest, objectServiceRequestData);
        return objectServiceRequestData;
    }
}

