/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.request.builder.AbstractRequestBuilder;
import com.konylabs.middleware.request.builder.PassthroughPayloadParser;
import com.konylabs.middleware.request.builder.PayloadParser;
import com.konylabs.middleware.request.builder.PayloadParserUtil;
import com.konylabs.middleware.request.builder.ProcessingStrategyFactory;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.MetricsBeanUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ObjectServiceRequestBuilder
extends AbstractRequestBuilder {
    private static final Logger LOGGER = Logger.getLogger(ObjectServiceRequestBuilder.class);

    @Override
    protected PayloadParser getPayloadParser() throws Exception {
        LOGGER.debug((Object)"Inside getPayloadParser of ObjectServiceRequestBuilder");
        return this.isRequestPassthrough() ? new PassthroughPayloadParser(this.httpServletRequest, this.requestContext, this.httpServletResponse) : PayloadParserUtil.getPayloadParser(this.httpServletRequest, this.httpServletResponse, this.requestContext);
    }

    protected boolean isRequestPassthrough() {
        return false;
    }

    @Override
    protected RequestData parsePayload() throws Exception {
        RequestData requestData = super.parsePayload();
        requestData.setAppId(this.requestContext.getAppId());
        requestData.setServiceId(this.requestContext.getServiceId());
        return requestData;
    }

    @Override
    protected void addProcessingStrategy(PayloadParser payloadParser, RequestData requestData) {
        requestData.setRequestProcessingStrategy(ProcessingStrategyFactory.getProcessingStrategy(payloadParser, this.requestContext));
    }

    @Override
    protected RequestData buildCore() throws Exception {
        ConfigParam uploadCacheParam;
        LOGGER.debug((Object)"Inside buildCore of ObjectServiceRequestBuilder");
        RequestData requestData = this.parsePayload();
        requestData.setRequestedMethod(this.requestContext.getRequestedMethod());
        requestData.putParam("objectID", this.requestContext.getObjectId());
        requestData.setAppId(this.requestContext.getAppId());
        requestData.putParam("rawJson", this.requestContext.getRawJson());
        requestData.setMbaasGateWayWrapper(this.requestContext.getGateWayWrapper());
        requestData.setRequestPassThrough(this.requestContext.isRequestpassthrough());
        this.doXSSCheck();
        if (this.requestContext.isRequestCacheSupported() && null != (uploadCacheParam = this.requestContext.getAppMetadata().getConfigParamByParamName("uploadCache")) && Boolean.parseBoolean(uploadCacheParam.getValue())) {
            this.httpServletRequest.setAttribute("isCachedObjectRequestExecutor", (Object)true);
        }
        return requestData;
    }

    @Override
    protected void addServiceInfoToMetricsBean() {
        this.addObjectServicesInfoToMetricsBean();
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)this.httpServletRequest, (String)"oname", (Object)"not applicable");
    }

    protected void addObjectServicesInfoToMetricsBean() {
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)this.httpServletRequest, (String)"svcgroup", (Object)this.requestContext.getAppId());
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)this.httpServletRequest, (String)"svctype", (Object)"object");
        this.setRequestTypeAndRequestMethod();
    }

    protected void setServiceIdForObjectServiceUpload(HttpServletRequest httpServletRequest) {
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)httpServletRequest, (String)"svcid", (Object)this.requestContext.getServiceId());
    }

    private void setRequestTypeAndRequestMethod() {
        this.setServiceIdForObjectServiceUpload(this.httpServletRequest);
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)this.httpServletRequest, (String)"reqtype", (Object)this.requestContext.getRequestType());
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)this.httpServletRequest, (String)"omethod", (Object)this.getObjectServiceMethod());
    }

    private String getObjectServiceMethod() {
        String overrideMethod = this.requestContext.getRequestOverrideMethod();
        return StringUtils.isNotBlank((String)this.requestContext.getRequestOverrideMethod()) && !"upload".equalsIgnoreCase(overrideMethod) ? overrideMethod : this.requestContext.getRequestedMethod();
    }
}

