/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.appservices.common.util.ResponseStatusEnum;
import com.konylabs.middleware.objservices.runtime.metadata.ParentChildType;
import com.konylabs.middleware.objservices.runtime.request.PrimaryKey;
import com.konylabs.middleware.request.builder.ResponseRecord;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ObjectServiceResponseData {
    private static final Logger LOGGER = Logger.getLogger(ObjectServiceResponseData.class);
    private final Map<String, ResponseRecord> responseRecords = new LinkedHashMap<String, ResponseRecord>();
    private final Map<String, Map<PrimaryKey, List<Row>>> failedRowListByObjNameAndInPk = new LinkedHashMap<String, Map<PrimaryKey, List<Row>>>();
    private final Map<String, Map<String, Map<JsonArray, List<Row>>>> failedRowListByObjNameRelationshipNameAndInputFk = new HashMap<String, Map<String, Map<JsonArray, List<Row>>>>();
    private Row lastFailedrecord;
    private Map<String, List<ParentChildType>> parentChildListByChildObjectnameMap;
    private int failureCount;
    private int totalCount;
    private int successCount;
    private Object resposne;

    public List<Row> getFailedRowListByObjNameInputPk(String objectName, PrimaryKey requestPrimeryKey) {
        LOGGER.debug((Object)" Inside getFailedRowListByObjNameInputPk()");
        Map<PrimaryKey, List<Row>> responsePkByInputPk = this.failedRowListByObjNameAndInPk.get(objectName);
        return responsePkByInputPk != null ? responsePkByInputPk.get(requestPrimeryKey) : null;
    }

    public List<Row> getAndRemoveFailedRowList(String objectName, PrimaryKey requestPrimeryKey) {
        LOGGER.debug((Object)" Inside getAndRemoveFailedRowList()");
        Map<PrimaryKey, List<Row>> responsePkByInputPk = this.failedRowListByObjNameAndInPk.get(objectName);
        if (responsePkByInputPk != null) {
            List<Row> list = responsePkByInputPk.get(requestPrimeryKey);
            responsePkByInputPk.remove(requestPrimeryKey);
            return list;
        }
        return null;
    }

    public void putFailedRowListWithObjNameInputPk(String objectName, PrimaryKey requestPrimeryKey, Row responseRow) {
        LOGGER.debug((Object)" Inside putFailedRowListWithObjNameInputPk()");
        this.lastFailedrecord = responseRow;
        Map<PrimaryKey, List<Row>> responseRowByRequestPk = this.failedRowListByObjNameAndInPk.get(objectName);
        List<Row> rowList = null;
        if (responseRowByRequestPk == null) {
            responseRowByRequestPk = new LinkedHashMap<PrimaryKey, List<Row>>();
            rowList = new ArrayList<Row>();
            responseRowByRequestPk.put(requestPrimeryKey, rowList);
            this.failedRowListByObjNameAndInPk.put(objectName, responseRowByRequestPk);
        } else {
            rowList = responseRowByRequestPk.get(requestPrimeryKey);
            if (rowList == null) {
                rowList = new ArrayList<Row>();
                responseRowByRequestPk.put(requestPrimeryKey, rowList);
            }
        }
        rowList.add(responseRow);
    }

    public List<Row> getFailedRowListByObjNameRelationshipNameInputFk(String objectName, String relationshipName, JsonArray fkValues) {
        LOGGER.debug((Object)" Inside getFailedRowListByObjNameRelationshipNameInputFk()");
        Map<String, Map<JsonArray, List<Row>>> responseRowByRelationshipnameAndInputFk = this.failedRowListByObjNameRelationshipNameAndInputFk.get(objectName);
        if (responseRowByRelationshipnameAndInputFk != null) {
            Map<JsonArray, List<Row>> responseRowByInputFk = responseRowByRelationshipnameAndInputFk.get(relationshipName);
            return responseRowByInputFk.get(fkValues);
        }
        return null;
    }

    public List<Row> getAndRemoveFailedRowListByFkValues(String objectName, String relationshipName, JsonArray fkValues) {
        Map<JsonArray, List<Row>> responseRowByInputFk;
        List<Row> failedRows;
        LOGGER.debug((Object)" Inside getAndRemoveFailedRowListByFkValues()");
        Map<String, Map<JsonArray, List<Row>>> responseRowByRelationshipnameAndInputFk = this.failedRowListByObjNameRelationshipNameAndInputFk.get(objectName);
        if (responseRowByRelationshipnameAndInputFk != null && (failedRows = (responseRowByInputFk = responseRowByRelationshipnameAndInputFk.get(relationshipName)).get(fkValues)) != null) {
            responseRowByInputFk.remove(fkValues);
            return failedRows;
        }
        return null;
    }

    public void putFailedRowListByObjNameRelationshipNameInputFk(String objectName, String relationshipName, JsonArray fkValues, Row responseRow) {
        LOGGER.debug((Object)" Inside putFailedRowListByObjNameRelationshipNameInputFk()");
        this.lastFailedrecord = responseRow;
        Map<String, Map<JsonArray, List<Row>>> responseRowByRelationshipnameAndInputFk = this.failedRowListByObjNameRelationshipNameAndInputFk.get(objectName);
        if (responseRowByRelationshipnameAndInputFk == null) {
            responseRowByRelationshipnameAndInputFk = new HashMap<String, Map<JsonArray, List<Row>>>();
            HashMap responseRowByInputFk = new HashMap();
            ArrayList<Row> rowList = new ArrayList<Row>();
            rowList.add(responseRow);
            responseRowByInputFk.put(fkValues, rowList);
            responseRowByRelationshipnameAndInputFk.put(relationshipName, responseRowByInputFk);
            this.failedRowListByObjNameRelationshipNameAndInputFk.put(objectName, responseRowByRelationshipnameAndInputFk);
        } else {
            Map<JsonArray, List<Row>> responseRowByInputFk = responseRowByRelationshipnameAndInputFk.get(relationshipName);
            if (responseRowByInputFk == null) {
                responseRowByInputFk = new HashMap<JsonArray, List<Row>>();
                ArrayList<Row> rowList = new ArrayList<Row>();
                rowList.add(responseRow);
                responseRowByInputFk.put(fkValues, rowList);
                responseRowByRelationshipnameAndInputFk.put(relationshipName, responseRowByInputFk);
            } else {
                List<Row> rowList = responseRowByInputFk.get(fkValues);
                if (rowList == null) {
                    rowList = new ArrayList<Row>();
                    responseRowByInputFk.put(fkValues, rowList);
                }
                rowList.add(responseRow);
            }
        }
    }

    void updateResponseRecordsAndIncrementSuccessCount(JsonElement jsonElement, String objectName) {
        LOGGER.debug((Object)" Inside updateResponseRecordsAndIncrementSuccessCount()");
        jsonElement = this.filterJson(jsonElement);
        this.updateResponseRecords(jsonElement, objectName);
        ++this.successCount;
        ++this.totalCount;
    }

    void updateResponseRecords(JsonElement jsonElement, String objectName) {
        if (this.responseRecords.get(objectName) != null) {
            this.responseRecords.get(objectName).addRecord(jsonElement);
        } else {
            ResponseRecord responseRecord = new ResponseRecord();
            responseRecord.setName(objectName);
            responseRecord.addRecord(jsonElement);
            this.responseRecords.put(objectName, responseRecord);
        }
    }

    void updateResponseRecordsAndIncrementFailureCount(JsonElement jsonElement, String objectName) {
        LOGGER.debug((Object)" Inside updateResponseRecordsAndIncrementFailureCount()");
        jsonElement = this.filterJson(jsonElement);
        this.updateResponseRecords(jsonElement, objectName);
        ++this.failureCount;
        ++this.totalCount;
    }

    void incrementTotalRecordCount() {
        ++this.totalCount;
    }

    private JsonElement filterJson(JsonElement jsonElement) {
        LOGGER.debug((Object)" Inside addRequestParams()");
        if (jsonElement.isJsonObject()) {
            JsonObject asJsonObject = jsonElement.getAsJsonObject();
            asJsonObject.remove("appID");
            asJsonObject.remove("objectID");
            asJsonObject.remove("serviceID");
            asJsonObject.remove("X-Kony-API-Version");
            asJsonObject.remove("channel");
            asJsonObject.remove("operationId");
            return asJsonObject;
        }
        return jsonElement;
    }

    boolean isAnyRecordFailed() {
        return this.lastFailedrecord != null;
    }

    Row getLastFailedrecord() {
        return this.lastFailedrecord;
    }

    void setParentListByChildName(Map<String, List<ParentChildType>> parentChildListByChildObjectnameMap) {
        this.parentChildListByChildObjectnameMap = parentChildListByChildObjectnameMap;
    }

    public List<ParentChildType> getParentChildListByChildObjectname(String objectName) {
        return this.parentChildListByChildObjectnameMap.get(objectName);
    }

    public void setResponseStream(Object resposne) {
        this.resposne = resposne;
    }

    public Object getResposne() {
        return this.resposne;
    }

    private Row putAndRemoveAllRemaingRecordsIntoFailed() {
        LOGGER.debug((Object)" Inside addRequestParams()");
        Row lastRow = this.getLastFailedrecord();
        if (!this.failedRowListByObjNameAndInPk.isEmpty()) {
            Collection<Map<PrimaryKey, List<Row>>> values = this.failedRowListByObjNameAndInPk.values();
            for (Map<PrimaryKey, List<Row>> map : values) {
                Collection<List<Row>> rowList = map.values();
                for (List<Row> list : rowList) {
                    for (Row row : list) {
                        JsonObject responseJson = RowUtil.getFailedErrorJson(this, row);
                        this.updateResponseRecordsAndIncrementFailureCount((JsonElement)responseJson, row.getMetadata().getObjectName());
                        lastRow = row;
                    }
                }
            }
            this.failedRowListByObjNameAndInPk.clear();
            this.failedRowListByObjNameRelationshipNameAndInputFk.clear();
        }
        return lastRow;
    }

    JsonObject getResponseInJson() {
        LOGGER.debug((Object)" Inside addRequestParams()");
        this.putAndRemoveAllRemaingRecordsIntoFailed();
        Gson gson = new Gson();
        ResponseStatusEnum responseStatusEnum = null;
        if (this.failureCount == 0) {
            responseStatusEnum = ResponseStatusEnum.SUCCESS;
        } else if (this.successCount == 0) {
            responseStatusEnum = ResponseStatusEnum.BULK_RECORD_COMPLETE_FAILURE;
        } else if (this.failureCount > 0 && this.successCount > 0) {
            responseStatusEnum = ResponseStatusEnum.PARTIAL_SUCCESS;
        }
        JsonArray responseRecordsJson = gson.toJsonTree(this.responseRecords.values(), List.class).getAsJsonArray();
        JsonObject responseJson = this.prepareFinalResponse(responseRecordsJson);
        ObjectServiceUtil.addHttpStatusCodeAndOpstatusAsPerResponseStatus(responseStatusEnum, responseJson);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("recordCount", (Number)this.totalCount);
        jsonObject.addProperty("successCount", (Number)this.successCount);
        jsonObject.addProperty("failureCount", (Number)this.failureCount);
        responseJson.add("_metadata", (JsonElement)jsonObject);
        return responseJson;
    }

    private JsonObject prepareFinalResponse(JsonArray responseJsonArray) {
        JsonObject jsonWithObjects = new JsonObject();
        jsonWithObjects.add("objects", (JsonElement)responseJsonArray);
        return jsonWithObjects;
    }

    void setLastFailedRecord(Row lastFailedrecord) {
        this.lastFailedrecord = lastFailedrecord;
    }

    public Map<String, ResponseRecord> getResponseRecords() {
        return this.responseRecords;
    }

    public int getSuccessCount() {
        return this.successCount;
    }
}

