/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.api.processor.impl.ProcessorInfo;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.request.builder.ObjectRequestBuilder;
import com.konylabs.middleware.request.builder.ObjectServiceUriContext;
import com.konylabs.middleware.request.builder.RequestBuilder;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.validator.BulkOperationRequestValidator;
import com.konylabs.middleware.request.validator.ObjectsRequestValidator;
import com.konylabs.middleware.request.validator.RequestValidator;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ObjectsUriContext
extends ObjectServiceUriContext {
    private static final Logger LOGGER = Logger.getLogger(ObjectsUriContext.class);

    public ObjectsUriContext(String[] uriParams) {
        super(uriParams);
    }

    @Override
    public RequestBuilder getBuilder() {
        return new ObjectRequestBuilder();
    }

    @Override
    public RequestValidator getRequestValidator(RequestContext context) {
        return context.isBulkRequest() ? new BulkOperationRequestValidator() : new ObjectsRequestValidator();
    }

    @Override
    public void prepareRequestContext(HttpServletRequest httpServletRequest, RequestContext requestContext) {
        LOGGER.debug((Object)"Inside prepareRequestContext method of ObjectsUriContext class");
        super.prepareRequestContext(httpServletRequest, requestContext);
        this.setDefaultOperation(requestContext);
        this.prepareRequestContextForObjects(requestContext);
    }

    @Override
    public ProcessorInfo getCustomProcesorInfo(RequestContext requestContext) {
        if (requestContext.isBulkRequest()) {
            LOGGER.debug((Object)"Found bulk api, so returning processor info as null.");
            return null;
        }
        String objectId = requestContext.getObjectId();
        String verb = requestContext.getDefaultOperation();
        AppCache appCache = requestContext.getAppCache();
        return appCache.getProcessorMetadata(requestContext.getAppVersion(), objectId.concat(":").concat(verb));
    }

    protected void setDefaultOperation(RequestContext requestContext) {
    }
}

